/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.BitFieldArgs;
import com.lambdaworks.redis.GeoArgs;
import com.lambdaworks.redis.GeoCoordinates;
import com.lambdaworks.redis.GeoRadiusStoreArgs;
import com.lambdaworks.redis.GeoWithin;
import com.lambdaworks.redis.KeyScanCursor;
import com.lambdaworks.redis.KeyValue;
import com.lambdaworks.redis.KillArgs;
import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.Limit;
import com.lambdaworks.redis.MapScanCursor;
import com.lambdaworks.redis.MigrateArgs;
import com.lambdaworks.redis.Range;
import com.lambdaworks.redis.ReactiveCommandDispatcher;
import com.lambdaworks.redis.RedisCommandBuilder;
import com.lambdaworks.redis.ScanArgs;
import com.lambdaworks.redis.ScanCursor;
import com.lambdaworks.redis.ScoredValue;
import com.lambdaworks.redis.ScoredValueScanCursor;
import com.lambdaworks.redis.ScriptOutputType;
import com.lambdaworks.redis.SetArgs;
import com.lambdaworks.redis.SortArgs;
import com.lambdaworks.redis.StreamScanCursor;
import com.lambdaworks.redis.ValueScanCursor;
import com.lambdaworks.redis.ZAddArgs;
import com.lambdaworks.redis.ZStoreArgs;
import com.lambdaworks.redis.api.StatefulConnection;
import com.lambdaworks.redis.api.rx.BaseRedisReactiveCommands;
import com.lambdaworks.redis.api.rx.RedisGeoReactiveCommands;
import com.lambdaworks.redis.api.rx.RedisHLLReactiveCommands;
import com.lambdaworks.redis.api.rx.RedisHashReactiveCommands;
import com.lambdaworks.redis.api.rx.RedisKeyReactiveCommands;
import com.lambdaworks.redis.api.rx.RedisListReactiveCommands;
import com.lambdaworks.redis.api.rx.RedisScriptingReactiveCommands;
import com.lambdaworks.redis.api.rx.RedisServerReactiveCommands;
import com.lambdaworks.redis.api.rx.RedisSetReactiveCommands;
import com.lambdaworks.redis.api.rx.RedisSortedSetReactiveCommands;
import com.lambdaworks.redis.api.rx.RedisStringReactiveCommands;
import com.lambdaworks.redis.api.rx.RedisTransactionalReactiveCommands;
import com.lambdaworks.redis.api.rx.Success;
import com.lambdaworks.redis.cluster.api.rx.RedisClusterReactiveCommands;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.output.CommandOutput;
import com.lambdaworks.redis.output.KeyStreamingChannel;
import com.lambdaworks.redis.output.KeyValueStreamingChannel;
import com.lambdaworks.redis.output.MultiOutput;
import com.lambdaworks.redis.output.ScoredValueStreamingChannel;
import com.lambdaworks.redis.output.ValueStreamingChannel;
import com.lambdaworks.redis.protocol.Command;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandType;
import com.lambdaworks.redis.protocol.ProtocolKeyword;
import com.lambdaworks.redis.protocol.RedisCommand;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import rx.Observable;
import rx.Subscriber;

public abstract class AbstractRedisReactiveCommands<K, V>
implements RedisHashReactiveCommands<K, V>,
RedisKeyReactiveCommands<K, V>,
RedisStringReactiveCommands<K, V>,
RedisListReactiveCommands<K, V>,
RedisSetReactiveCommands<K, V>,
RedisSortedSetReactiveCommands<K, V>,
RedisScriptingReactiveCommands<K, V>,
RedisServerReactiveCommands<K, V>,
RedisHLLReactiveCommands<K, V>,
BaseRedisReactiveCommands<K, V>,
RedisTransactionalReactiveCommands<K, V>,
RedisGeoReactiveCommands<K, V>,
RedisClusterReactiveCommands<K, V> {
    protected MultiOutput<K, V> multi;
    protected RedisCommandBuilder<K, V> commandBuilder;
    protected RedisCodec<K, V> codec;
    protected StatefulConnection<K, V> connection;

    public AbstractRedisReactiveCommands(StatefulConnection<K, V> connection, RedisCodec<K, V> codec) {
        this.connection = connection;
        this.codec = codec;
        this.commandBuilder = new RedisCommandBuilder<K, V>(codec);
    }

    @Override
    public Observable<Long> append(K key, V value) {
        return this.createObservable(() -> this.commandBuilder.append(key, value));
    }

    @Override
    public Observable<String> auth(String password) {
        return this.createObservable(() -> this.commandBuilder.auth(password));
    }

    @Override
    public Observable<String> bgrewriteaof() {
        return this.createObservable(this.commandBuilder::bgrewriteaof);
    }

    @Override
    public Observable<String> bgsave() {
        return this.createObservable(this.commandBuilder::bgsave);
    }

    @Override
    public Observable<Long> bitcount(K key) {
        return this.createObservable(() -> this.commandBuilder.bitcount(key));
    }

    @Override
    public Observable<Long> bitcount(K key, long start, long end) {
        return this.createObservable(() -> this.commandBuilder.bitcount(key, start, end));
    }

    @Override
    public Observable<Long> bitfield(K key, BitFieldArgs args) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.bitfield(key, args));
    }

    @Override
    public Observable<Long> bitpos(K key, boolean state) {
        return this.createObservable(() -> this.commandBuilder.bitpos(key, state));
    }

    @Override
    public Observable<Long> bitpos(K key, boolean state, long start, long end) {
        return this.createObservable(() -> this.commandBuilder.bitpos(key, state, start, end));
    }

    @Override
    public Observable<Long> bitopAnd(K destination, K ... keys) {
        return this.createObservable(() -> this.commandBuilder.bitopAnd(destination, keys));
    }

    @Override
    public Observable<Long> bitopNot(K destination, K source) {
        return this.createObservable(() -> this.commandBuilder.bitopNot(destination, source));
    }

    @Override
    public Observable<Long> bitopOr(K destination, K ... keys) {
        return this.createObservable(() -> this.commandBuilder.bitopOr(destination, keys));
    }

    @Override
    public Observable<Long> bitopXor(K destination, K ... keys) {
        return this.createObservable(() -> this.commandBuilder.bitopXor(destination, keys));
    }

    @Override
    public Observable<KeyValue<K, V>> blpop(long timeout, K ... keys) {
        return this.createObservable(() -> this.commandBuilder.blpop(timeout, keys));
    }

    @Override
    public Observable<KeyValue<K, V>> brpop(long timeout, K ... keys) {
        return this.createObservable(() -> this.commandBuilder.brpop(timeout, keys));
    }

    @Override
    public Observable<V> brpoplpush(long timeout, K source, K destination) {
        return this.createObservable(() -> this.commandBuilder.brpoplpush(timeout, source, destination));
    }

    @Override
    public Observable<K> clientGetname() {
        return this.createObservable(this.commandBuilder::clientGetname);
    }

    @Override
    public Observable<String> clientSetname(K name) {
        return this.createObservable(() -> this.commandBuilder.clientSetname(name));
    }

    @Override
    public Observable<String> clientKill(String addr) {
        return this.createObservable(() -> this.commandBuilder.clientKill(addr));
    }

    @Override
    public Observable<Long> clientKill(KillArgs killArgs) {
        return this.createObservable(() -> this.commandBuilder.clientKill(killArgs));
    }

    @Override
    public Observable<String> clientPause(long timeout) {
        return this.createObservable(() -> this.commandBuilder.clientPause(timeout));
    }

    @Override
    public Observable<String> clientList() {
        return this.createObservable(this.commandBuilder::clientList);
    }

    @Override
    public Observable<Object> command() {
        return (Observable)this.createDissolvingObservable(this.commandBuilder::command);
    }

    @Override
    public Observable<Object> commandInfo(String ... commands) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.commandInfo(commands));
    }

    @Override
    public Observable<Object> commandInfo(CommandType ... commands) {
        String[] stringCommands = new String[commands.length];
        for (int i = 0; i < commands.length; ++i) {
            stringCommands[i] = commands[i].name();
        }
        return this.commandInfo(stringCommands);
    }

    @Override
    public Observable<Long> commandCount() {
        return this.createObservable(this.commandBuilder::commandCount);
    }

    @Override
    public Observable<String> configGet(String parameter) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.configGet(parameter));
    }

    @Override
    public Observable<String> configResetstat() {
        return this.createObservable(this.commandBuilder::configResetstat);
    }

    @Override
    public Observable<String> configSet(String parameter, String value) {
        return this.createObservable(() -> this.commandBuilder.configSet(parameter, value));
    }

    @Override
    public Observable<String> configRewrite() {
        return this.createObservable(this.commandBuilder::configRewrite);
    }

    @Override
    public Observable<Long> dbsize() {
        return this.createObservable(this.commandBuilder::dbsize);
    }

    @Override
    public Observable<String> debugCrashAndRecover(Long delay) {
        return this.createObservable(() -> this.commandBuilder.debugCrashAndRecover(delay));
    }

    @Override
    public Observable<String> debugHtstats(int db) {
        return this.createObservable(() -> this.commandBuilder.debugHtstats(db));
    }

    @Override
    public Observable<String> debugObject(K key) {
        return this.createObservable(() -> this.commandBuilder.debugObject(key));
    }

    @Override
    public Observable<Success> debugOom() {
        return Observable.just((Object)((Object)Success.Success)).doOnCompleted(this.commandBuilder::debugOom);
    }

    @Override
    public Observable<String> debugReload() {
        return this.createObservable(() -> this.commandBuilder.debugReload());
    }

    @Override
    public Observable<String> debugRestart(Long delay) {
        return this.createObservable(() -> this.commandBuilder.debugRestart(delay));
    }

    @Override
    public Observable<String> debugSdslen(K key) {
        return this.createObservable(() -> this.commandBuilder.debugSdslen(key));
    }

    @Override
    public Observable<Success> debugSegfault() {
        return Observable.just((Object)((Object)Success.Success)).doOnCompleted(this.commandBuilder::debugSegfault);
    }

    @Override
    public Observable<Long> decr(K key) {
        return this.createObservable(() -> this.commandBuilder.decr(key));
    }

    @Override
    public Observable<Long> decrby(K key, long amount) {
        return this.createObservable(() -> this.commandBuilder.decrby(key, amount));
    }

    @Override
    public Observable<Long> del(K ... keys) {
        return this.createObservable(() -> this.commandBuilder.del(keys));
    }

    public Observable<Long> del(Iterable<K> keys) {
        return this.createObservable(() -> this.commandBuilder.del(keys));
    }

    @Override
    public Observable<Long> unlink(K ... keys) {
        return this.createObservable(() -> this.commandBuilder.unlink(keys));
    }

    public Observable<Long> unlink(Iterable<K> keys) {
        return this.createObservable(() -> this.commandBuilder.unlink(keys));
    }

    @Override
    public Observable<String> discard() {
        return this.createObservable(this.commandBuilder::discard);
    }

    @Override
    public Observable<byte[]> dump(K key) {
        return this.createObservable(() -> this.commandBuilder.dump(key));
    }

    @Override
    public Observable<V> echo(V msg) {
        return this.createObservable(() -> this.commandBuilder.echo(msg));
    }

    @Override
    public <T> Observable<T> eval(String script, ScriptOutputType type, K ... keys) {
        return this.createObservable(() -> this.commandBuilder.eval(script, type, keys));
    }

    @Override
    public <T> Observable<T> eval(String script, ScriptOutputType type, K[] keys, V ... values) {
        return this.createObservable(() -> this.commandBuilder.eval(script, type, keys, values));
    }

    @Override
    public <T> Observable<T> evalsha(String digest, ScriptOutputType type, K ... keys) {
        return this.createObservable(() -> this.commandBuilder.evalsha(digest, type, keys));
    }

    @Override
    public <T> Observable<T> evalsha(String digest, ScriptOutputType type, K[] keys, V ... values) {
        return this.createObservable(() -> this.commandBuilder.evalsha(digest, type, keys, values));
    }

    public Observable<Boolean> exists(K key) {
        return this.createObservable(() -> this.commandBuilder.exists((Object)key));
    }

    @Override
    public Observable<Long> exists(K ... keys) {
        return this.createObservable(() -> this.commandBuilder.exists(keys));
    }

    public Observable<Long> exists(Iterable<K> keys) {
        return this.createObservable(() -> this.commandBuilder.exists(keys));
    }

    @Override
    public Observable<Boolean> expire(K key, long seconds) {
        return this.createObservable(() -> this.commandBuilder.expire(key, seconds));
    }

    @Override
    public Observable<Boolean> expireat(K key, long timestamp) {
        return this.createObservable(() -> this.commandBuilder.expireat(key, timestamp));
    }

    @Override
    public Observable<Boolean> expireat(K key, Date timestamp) {
        return this.expireat(key, timestamp.getTime() / 1000L);
    }

    @Override
    public Observable<Object> exec() {
        return (Observable)this.createDissolvingObservable(CommandType.EXEC, null, null);
    }

    @Override
    public Observable<String> flushall() {
        return this.createObservable(this.commandBuilder::flushall);
    }

    @Override
    public Observable<String> flushallAsync() {
        return this.createObservable(this.commandBuilder::flushallAsync);
    }

    @Override
    public Observable<String> flushdb() {
        return this.createObservable(this.commandBuilder::flushdb);
    }

    @Override
    public Observable<String> flushdbAsync() {
        return this.createObservable(this.commandBuilder::flushdbAsync);
    }

    @Override
    public Observable<V> get(K key) {
        return this.createObservable(() -> this.commandBuilder.get(key));
    }

    @Override
    public Observable<Long> getbit(K key, long offset) {
        return this.createObservable(() -> this.commandBuilder.getbit(key, offset));
    }

    @Override
    public Observable<V> getrange(K key, long start, long end) {
        return this.createObservable(() -> this.commandBuilder.getrange(key, start, end));
    }

    @Override
    public Observable<V> getset(K key, V value) {
        return this.createObservable(() -> this.commandBuilder.getset(key, value));
    }

    @Override
    public Observable<Long> hdel(K key, K ... fields) {
        return this.createObservable(() -> this.commandBuilder.hdel(key, fields));
    }

    @Override
    public Observable<Boolean> hexists(K key, K field) {
        return this.createObservable(() -> this.commandBuilder.hexists(key, field));
    }

    @Override
    public Observable<V> hget(K key, K field) {
        return this.createObservable(() -> this.commandBuilder.hget(key, field));
    }

    @Override
    public Observable<Long> hincrby(K key, K field, long amount) {
        return this.createObservable(() -> this.commandBuilder.hincrby(key, field, amount));
    }

    @Override
    public Observable<Double> hincrbyfloat(K key, K field, double amount) {
        return this.createObservable(() -> this.commandBuilder.hincrbyfloat(key, field, amount));
    }

    @Override
    public Observable<Map<K, V>> hgetall(K key) {
        return this.createObservable(() -> this.commandBuilder.hgetall(key));
    }

    @Override
    public Observable<Long> hgetall(KeyValueStreamingChannel<K, V> channel, K key) {
        return this.createObservable(() -> this.commandBuilder.hgetall(channel, key));
    }

    @Override
    public Observable<K> hkeys(K key) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.hkeys(key));
    }

    @Override
    public Observable<Long> hkeys(KeyStreamingChannel<K> channel, K key) {
        return this.createObservable(() -> this.commandBuilder.hkeys(channel, key));
    }

    @Override
    public Observable<Long> hlen(K key) {
        return this.createObservable(() -> this.commandBuilder.hlen(key));
    }

    @Override
    public Observable<Long> hstrlen(K key, K field) {
        return this.createObservable(() -> this.commandBuilder.hstrlen(key, field));
    }

    @Override
    public Observable<V> hmget(K key, K ... fields) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.hmget(key, fields));
    }

    @Override
    public Observable<Long> hmget(ValueStreamingChannel<V> channel, K key, K ... fields) {
        return this.createObservable(() -> this.commandBuilder.hmget(channel, key, fields));
    }

    @Override
    public Observable<String> hmset(K key, Map<K, V> map) {
        return this.createObservable(() -> this.commandBuilder.hmset(key, map));
    }

    @Override
    public Observable<Boolean> hset(K key, K field, V value) {
        return this.createObservable(() -> this.commandBuilder.hset(key, field, value));
    }

    @Override
    public Observable<Boolean> hsetnx(K key, K field, V value) {
        return this.createObservable(() -> this.commandBuilder.hsetnx(key, field, value));
    }

    @Override
    public Observable<V> hvals(K key) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.hvals(key));
    }

    @Override
    public Observable<Long> hvals(ValueStreamingChannel<V> channel, K key) {
        return this.createObservable(() -> this.commandBuilder.hvals(channel, key));
    }

    @Override
    public Observable<Long> incr(K key) {
        return this.createObservable(() -> this.commandBuilder.incr(key));
    }

    @Override
    public Observable<Long> incrby(K key, long amount) {
        return this.createObservable(() -> this.commandBuilder.incrby(key, amount));
    }

    @Override
    public Observable<Double> incrbyfloat(K key, double amount) {
        return this.createObservable(() -> this.commandBuilder.incrbyfloat(key, amount));
    }

    @Override
    public Observable<String> info() {
        return this.createObservable(this.commandBuilder::info);
    }

    @Override
    public Observable<String> info(String section) {
        return this.createObservable(() -> this.commandBuilder.info(section));
    }

    @Override
    public Observable<K> keys(K pattern) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.keys(pattern));
    }

    @Override
    public Observable<Long> keys(KeyStreamingChannel<K> channel, K pattern) {
        return this.createObservable(() -> this.commandBuilder.keys(channel, pattern));
    }

    @Override
    public Observable<Date> lastsave() {
        return this.createObservable(this.commandBuilder::lastsave);
    }

    @Override
    public Observable<V> lindex(K key, long index) {
        return this.createObservable(() -> this.commandBuilder.lindex(key, index));
    }

    @Override
    public Observable<Long> linsert(K key, boolean before, V pivot, V value) {
        return this.createObservable(() -> this.commandBuilder.linsert(key, before, pivot, value));
    }

    @Override
    public Observable<Long> llen(K key) {
        return this.createObservable(() -> this.commandBuilder.llen(key));
    }

    @Override
    public Observable<V> lpop(K key) {
        return this.createObservable(() -> this.commandBuilder.lpop(key));
    }

    @Override
    public Observable<Long> lpush(K key, V ... values) {
        return this.createObservable(() -> this.commandBuilder.lpush(key, values));
    }

    @Override
    public Observable<Long> lpushx(K key, V value) {
        return this.createObservable(() -> this.commandBuilder.lpushx(key, value));
    }

    @Override
    public Observable<Long> lpushx(K key, V ... values) {
        return this.createObservable(() -> this.commandBuilder.lpushx(key, values));
    }

    @Override
    public Observable<V> lrange(K key, long start, long stop) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.lrange(key, start, stop));
    }

    @Override
    public Observable<Long> lrange(ValueStreamingChannel<V> channel, K key, long start, long stop) {
        return this.createObservable(() -> this.commandBuilder.lrange(channel, key, start, stop));
    }

    @Override
    public Observable<Long> lrem(K key, long count, V value) {
        return this.createObservable(() -> this.commandBuilder.lrem(key, count, value));
    }

    @Override
    public Observable<String> lset(K key, long index, V value) {
        return this.createObservable(() -> this.commandBuilder.lset(key, index, value));
    }

    @Override
    public Observable<String> ltrim(K key, long start, long stop) {
        return this.createObservable(() -> this.commandBuilder.ltrim(key, start, stop));
    }

    @Override
    public Observable<String> migrate(String host, int port, K key, int db, long timeout) {
        return this.createObservable(() -> this.commandBuilder.migrate(host, port, key, db, timeout));
    }

    @Override
    public Observable<String> migrate(String host, int port, int db, long timeout, MigrateArgs<K> migrateArgs) {
        return this.createObservable(() -> this.commandBuilder.migrate(host, port, db, timeout, migrateArgs));
    }

    @Override
    public Observable<V> mget(K ... keys) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.mget(keys));
    }

    public Observable<V> mget(Iterable<K> keys) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.mget(keys));
    }

    @Override
    public Observable<Long> mget(ValueStreamingChannel<V> channel, K ... keys) {
        return this.createObservable(() -> this.commandBuilder.mget(channel, keys));
    }

    public Observable<Long> mget(ValueStreamingChannel<V> channel, Iterable<K> keys) {
        return this.createObservable(() -> this.commandBuilder.mget(channel, keys));
    }

    @Override
    public Observable<Boolean> move(K key, int db) {
        return this.createObservable(() -> this.commandBuilder.move(key, db));
    }

    @Override
    public Observable<String> multi() {
        return this.createObservable(this.commandBuilder::multi);
    }

    @Override
    public Observable<String> mset(Map<K, V> map) {
        return this.createObservable(() -> this.commandBuilder.mset(map));
    }

    @Override
    public Observable<Boolean> msetnx(Map<K, V> map) {
        return this.createObservable(() -> this.commandBuilder.msetnx(map));
    }

    @Override
    public Observable<String> objectEncoding(K key) {
        return this.createObservable(() -> this.commandBuilder.objectEncoding(key));
    }

    @Override
    public Observable<Long> objectIdletime(K key) {
        return this.createObservable(() -> this.commandBuilder.objectIdletime(key));
    }

    @Override
    public Observable<Long> objectRefcount(K key) {
        return this.createObservable(() -> this.commandBuilder.objectRefcount(key));
    }

    @Override
    public Observable<Boolean> persist(K key) {
        return this.createObservable(() -> this.commandBuilder.persist(key));
    }

    @Override
    public Observable<Boolean> pexpire(K key, long milliseconds) {
        return this.createObservable(() -> this.commandBuilder.pexpire(key, milliseconds));
    }

    @Override
    public Observable<Boolean> pexpireat(K key, Date timestamp) {
        return this.pexpireat(key, timestamp.getTime());
    }

    @Override
    public Observable<Boolean> pexpireat(K key, long timestamp) {
        return this.createObservable(() -> this.commandBuilder.pexpireat(key, timestamp));
    }

    @Override
    public Observable<String> ping() {
        return this.createObservable(this.commandBuilder::ping);
    }

    @Override
    public Observable<String> readOnly() {
        return this.createObservable(this.commandBuilder::readOnly);
    }

    @Override
    public Observable<String> readWrite() {
        return this.createObservable(this.commandBuilder::readWrite);
    }

    @Override
    public Observable<Long> pttl(K key) {
        return this.createObservable(() -> this.commandBuilder.pttl(key));
    }

    @Override
    public Observable<Long> publish(K channel, V message) {
        return this.createObservable(() -> this.commandBuilder.publish(channel, message));
    }

    @Override
    public Observable<K> pubsubChannels() {
        return (Observable)this.createDissolvingObservable(this.commandBuilder::pubsubChannels);
    }

    @Override
    public Observable<K> pubsubChannels(K channel) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.pubsubChannels(channel));
    }

    @Override
    public Observable<Map<K, Long>> pubsubNumsub(K ... channels) {
        return this.createObservable(() -> this.commandBuilder.pubsubNumsub(channels));
    }

    @Override
    public Observable<Long> pubsubNumpat() {
        return this.createObservable(this.commandBuilder::pubsubNumpat);
    }

    @Override
    public Observable<String> quit() {
        return this.createObservable(this.commandBuilder::quit);
    }

    @Override
    public Observable<Object> role() {
        return (Observable)this.createDissolvingObservable(this.commandBuilder::role);
    }

    @Override
    public Observable<V> randomkey() {
        return this.createObservable(this.commandBuilder::randomkey);
    }

    @Override
    public Observable<String> rename(K key, K newKey) {
        return this.createObservable(() -> this.commandBuilder.rename(key, newKey));
    }

    @Override
    public Observable<Boolean> renamenx(K key, K newKey) {
        return this.createObservable(() -> this.commandBuilder.renamenx(key, newKey));
    }

    @Override
    public Observable<String> restore(K key, long ttl, byte[] value) {
        return this.createObservable(() -> this.commandBuilder.restore(key, ttl, value));
    }

    @Override
    public Observable<V> rpop(K key) {
        return this.createObservable(() -> this.commandBuilder.rpop(key));
    }

    @Override
    public Observable<V> rpoplpush(K source, K destination) {
        return this.createObservable(() -> this.commandBuilder.rpoplpush(source, destination));
    }

    @Override
    public Observable<Long> rpush(K key, V ... values) {
        return this.createObservable(() -> this.commandBuilder.rpush(key, values));
    }

    @Override
    public Observable<Long> rpushx(K key, V value) {
        return this.createObservable(() -> this.commandBuilder.rpushx(key, value));
    }

    @Override
    public Observable<Long> rpushx(K key, V ... values) {
        return this.createObservable(() -> this.commandBuilder.rpushx(key, values));
    }

    @Override
    public Observable<Long> sadd(K key, V ... members) {
        return this.createObservable(() -> this.commandBuilder.sadd(key, members));
    }

    @Override
    public Observable<String> save() {
        return this.createObservable(this.commandBuilder::save);
    }

    @Override
    public Observable<Long> scard(K key) {
        return this.createObservable(() -> this.commandBuilder.scard(key));
    }

    @Override
    public Observable<Boolean> scriptExists(String ... digests) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.scriptExists(digests));
    }

    @Override
    public Observable<String> scriptFlush() {
        return this.createObservable(this.commandBuilder::scriptFlush);
    }

    @Override
    public Observable<String> scriptKill() {
        return this.createObservable(this.commandBuilder::scriptKill);
    }

    @Override
    public Observable<String> scriptLoad(V script) {
        return this.createObservable(() -> this.commandBuilder.scriptLoad(script));
    }

    @Override
    public Observable<V> sdiff(K ... keys) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.sdiff(keys));
    }

    @Override
    public Observable<Long> sdiff(ValueStreamingChannel<V> channel, K ... keys) {
        return this.createObservable(() -> this.commandBuilder.sdiff(channel, keys));
    }

    @Override
    public Observable<Long> sdiffstore(K destination, K ... keys) {
        return this.createObservable(() -> this.commandBuilder.sdiffstore(destination, keys));
    }

    public Observable<String> select(int db) {
        return this.createObservable(() -> this.commandBuilder.select(db));
    }

    public Observable<String> swapdb(int db1, int db2) {
        return this.createObservable(() -> this.commandBuilder.swapdb(db1, db2));
    }

    @Override
    public Observable<String> set(K key, V value) {
        return this.createObservable(() -> this.commandBuilder.set(key, value));
    }

    @Override
    public Observable<String> set(K key, V value, SetArgs setArgs) {
        return this.createObservable(() -> this.commandBuilder.set(key, value, setArgs));
    }

    @Override
    public Observable<Long> setbit(K key, long offset, int value) {
        return this.createObservable(() -> this.commandBuilder.setbit(key, offset, value));
    }

    @Override
    public Observable<String> setex(K key, long seconds, V value) {
        return this.createObservable(() -> this.commandBuilder.setex(key, seconds, value));
    }

    @Override
    public Observable<String> psetex(K key, long milliseconds, V value) {
        return this.createObservable(() -> this.commandBuilder.psetex(key, milliseconds, value));
    }

    @Override
    public Observable<Boolean> setnx(K key, V value) {
        return this.createObservable(() -> this.commandBuilder.setnx(key, value));
    }

    @Override
    public Observable<Long> setrange(K key, long offset, V value) {
        return this.createObservable(() -> this.commandBuilder.setrange(key, offset, value));
    }

    @Override
    public Observable<Success> shutdown(boolean save) {
        return this.getSuccessObservable(this.createObservable(() -> this.commandBuilder.shutdown(save)));
    }

    @Override
    public Observable<V> sinter(K ... keys) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.sinter(keys));
    }

    @Override
    public Observable<Long> sinter(ValueStreamingChannel<V> channel, K ... keys) {
        return this.createObservable(() -> this.commandBuilder.sinter(channel, keys));
    }

    @Override
    public Observable<Long> sinterstore(K destination, K ... keys) {
        return this.createObservable(() -> this.commandBuilder.sinterstore(destination, keys));
    }

    @Override
    public Observable<Boolean> sismember(K key, V member) {
        return this.createObservable(() -> this.commandBuilder.sismember(key, member));
    }

    @Override
    public Observable<Boolean> smove(K source, K destination, V member) {
        return this.createObservable(() -> this.commandBuilder.smove(source, destination, member));
    }

    @Override
    public Observable<String> slaveof(String host, int port) {
        return this.createObservable(() -> this.commandBuilder.slaveof(host, port));
    }

    @Override
    public Observable<String> slaveofNoOne() {
        return this.createObservable(() -> this.commandBuilder.slaveofNoOne());
    }

    @Override
    public Observable<Object> slowlogGet() {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.slowlogGet());
    }

    @Override
    public Observable<Object> slowlogGet(int count) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.slowlogGet(count));
    }

    @Override
    public Observable<Long> slowlogLen() {
        return this.createObservable(() -> this.commandBuilder.slowlogLen());
    }

    @Override
    public Observable<String> slowlogReset() {
        return this.createObservable(() -> this.commandBuilder.slowlogReset());
    }

    @Override
    public Observable<V> smembers(K key) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.smembers(key));
    }

    @Override
    public Observable<Long> smembers(ValueStreamingChannel<V> channel, K key) {
        return this.createObservable(() -> this.commandBuilder.smembers(channel, key));
    }

    @Override
    public Observable<V> sort(K key) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.sort(key));
    }

    @Override
    public Observable<Long> sort(ValueStreamingChannel<V> channel, K key) {
        return this.createObservable(() -> this.commandBuilder.sort(channel, key));
    }

    @Override
    public Observable<V> sort(K key, SortArgs sortArgs) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.sort(key, sortArgs));
    }

    @Override
    public Observable<Long> sort(ValueStreamingChannel<V> channel, K key, SortArgs sortArgs) {
        return this.createObservable(() -> this.commandBuilder.sort(channel, key, sortArgs));
    }

    @Override
    public Observable<Long> sortStore(K key, SortArgs sortArgs, K destination) {
        return this.createObservable(() -> this.commandBuilder.sortStore(key, sortArgs, destination));
    }

    @Override
    public Observable<V> spop(K key) {
        return this.createObservable(() -> this.commandBuilder.spop(key));
    }

    @Override
    public Observable<V> spop(K key, long count) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.spop(key, count));
    }

    @Override
    public Observable<V> srandmember(K key) {
        return this.createObservable(() -> this.commandBuilder.srandmember(key));
    }

    @Override
    public Observable<V> srandmember(K key, long count) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.srandmember(key, count));
    }

    @Override
    public Observable<Long> srandmember(ValueStreamingChannel<V> channel, K key, long count) {
        return this.createObservable(() -> this.commandBuilder.srandmember(channel, key, count));
    }

    @Override
    public Observable<Long> srem(K key, V ... members) {
        return this.createObservable(() -> this.commandBuilder.srem(key, members));
    }

    @Override
    public Observable<V> sunion(K ... keys) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.sunion(keys));
    }

    @Override
    public Observable<Long> sunion(ValueStreamingChannel<V> channel, K ... keys) {
        return this.createObservable(() -> this.commandBuilder.sunion(channel, keys));
    }

    @Override
    public Observable<Long> sunionstore(K destination, K ... keys) {
        return this.createObservable(() -> this.commandBuilder.sunionstore(destination, keys));
    }

    @Override
    public Observable<String> sync() {
        return this.createObservable(this.commandBuilder::sync);
    }

    @Override
    public Observable<Long> strlen(K key) {
        return this.createObservable(() -> this.commandBuilder.strlen(key));
    }

    @Override
    public Observable<Long> touch(K ... keys) {
        return this.createObservable(() -> this.commandBuilder.touch(keys));
    }

    public Observable<Long> touch(Iterable<K> keys) {
        return this.createObservable(() -> this.commandBuilder.touch(keys));
    }

    @Override
    public Observable<Long> ttl(K key) {
        return this.createObservable(() -> this.commandBuilder.ttl(key));
    }

    @Override
    public Observable<String> type(K key) {
        return this.createObservable(() -> this.commandBuilder.type(key));
    }

    @Override
    public Observable<String> watch(K ... keys) {
        return this.createObservable(() -> this.commandBuilder.watch(keys));
    }

    @Override
    public Observable<String> unwatch() {
        return this.createObservable(this.commandBuilder::unwatch);
    }

    @Override
    public Observable<Long> zadd(K key, double score, V member) {
        return this.createObservable(() -> this.commandBuilder.zadd(key, (ZAddArgs)null, score, member));
    }

    @Override
    public Observable<Long> zadd(K key, Object ... scoresAndValues) {
        return this.createObservable(() -> this.commandBuilder.zadd(key, null, scoresAndValues));
    }

    @Override
    public Observable<Long> zadd(K key, ScoredValue<V> ... scoredValues) {
        return this.createObservable(() -> this.commandBuilder.zadd(key, null, scoredValues));
    }

    @Override
    public Observable<Long> zadd(K key, ZAddArgs zAddArgs, double score, V member) {
        return this.createObservable(() -> this.commandBuilder.zadd(key, zAddArgs, score, member));
    }

    @Override
    public Observable<Long> zadd(K key, ZAddArgs zAddArgs, Object ... scoresAndValues) {
        return this.createObservable(() -> this.commandBuilder.zadd(key, zAddArgs, scoresAndValues));
    }

    @Override
    public Observable<Long> zadd(K key, ZAddArgs zAddArgs, ScoredValue<V> ... scoredValues) {
        return this.createObservable(() -> this.commandBuilder.zadd(key, zAddArgs, scoredValues));
    }

    @Override
    public Observable<Double> zaddincr(K key, double score, V member) {
        return this.createObservable(() -> this.commandBuilder.zaddincr(key, null, score, member));
    }

    @Override
    public Observable<Double> zaddincr(K key, ZAddArgs zAddArgs, double score, V member) {
        return this.createObservable(() -> this.commandBuilder.zaddincr(key, zAddArgs, score, member));
    }

    @Override
    public Observable<Long> zcard(K key) {
        return this.createObservable(() -> this.commandBuilder.zcard(key));
    }

    @Override
    public Observable<Long> zcount(K key, double min, double max) {
        return this.createObservable(() -> this.commandBuilder.zcount(key, min, max));
    }

    @Override
    public Observable<Long> zcount(K key, String min, String max) {
        return this.createObservable(() -> this.commandBuilder.zcount(key, min, max));
    }

    @Override
    public Observable<Long> zcount(K key, Range<? extends Number> range) {
        return this.createObservable(() -> this.commandBuilder.zcount(key, range));
    }

    @Override
    public Observable<Double> zincrby(K key, double amount, K member) {
        return this.createObservable(() -> this.commandBuilder.zincrby(key, amount, member));
    }

    @Override
    public Observable<Long> zinterstore(K destination, K ... keys) {
        return this.createObservable(() -> this.commandBuilder.zinterstore(destination, keys));
    }

    @Override
    public Observable<Long> zinterstore(K destination, ZStoreArgs storeArgs, K ... keys) {
        return this.createObservable(() -> this.commandBuilder.zinterstore(destination, storeArgs, keys));
    }

    @Override
    public Observable<V> zrange(K key, long start, long stop) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrange(key, start, stop));
    }

    @Override
    public Observable<ScoredValue<V>> zrangeWithScores(K key, long start, long stop) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrangeWithScores(key, start, stop));
    }

    @Override
    public Observable<V> zrangebyscore(K key, double min, double max) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrangebyscore(key, min, max));
    }

    @Override
    public Observable<V> zrangebyscore(K key, String min, String max) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrangebyscore(key, min, max));
    }

    @Override
    public Observable<V> zrangebyscore(K key, Range<? extends Number> range) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrangebyscore(key, range, Limit.unlimited()));
    }

    @Override
    public Observable<V> zrangebyscore(K key, double min, double max, long offset, long count) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrangebyscore(key, min, max, offset, count));
    }

    @Override
    public Observable<V> zrangebyscore(K key, String min, String max, long offset, long count) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrangebyscore(key, min, max, offset, count));
    }

    @Override
    public Observable<V> zrangebyscore(K key, Range<? extends Number> range, Limit limit) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrangebyscore(key, range, limit));
    }

    @Override
    public Observable<ScoredValue<V>> zrangebyscoreWithScores(K key, double min, double max) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrangebyscoreWithScores(key, min, max));
    }

    @Override
    public Observable<ScoredValue<V>> zrangebyscoreWithScores(K key, String min, String max) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrangebyscoreWithScores(key, min, max));
    }

    @Override
    public Observable<ScoredValue<V>> zrangebyscoreWithScores(K key, Range<? extends Number> range) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrangebyscoreWithScores(key, range, Limit.unlimited()));
    }

    @Override
    public Observable<ScoredValue<V>> zrangebyscoreWithScores(K key, double min, double max, long offset, long count) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrangebyscoreWithScores(key, min, max, offset, count));
    }

    @Override
    public Observable<ScoredValue<V>> zrangebyscoreWithScores(K key, String min, String max, long offset, long count) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrangebyscoreWithScores(key, min, max, offset, count));
    }

    @Override
    public Observable<ScoredValue<V>> zrangebyscoreWithScores(K key, Range<? extends Number> range, Limit limit) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrangebyscoreWithScores(key, range, limit));
    }

    @Override
    public Observable<Long> zrange(ValueStreamingChannel<V> channel, K key, long start, long stop) {
        return this.createObservable(() -> this.commandBuilder.zrange(channel, key, start, stop));
    }

    @Override
    public Observable<Long> zrangeWithScores(ScoredValueStreamingChannel<V> channel, K key, long start, long stop) {
        return this.createObservable(() -> this.commandBuilder.zrangeWithScores(channel, key, start, stop));
    }

    @Override
    public Observable<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, double min, double max) {
        return this.createObservable(() -> this.commandBuilder.zrangebyscore(channel, key, min, max));
    }

    @Override
    public Observable<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, String min, String max) {
        return this.createObservable(() -> this.commandBuilder.zrangebyscore(channel, key, min, max));
    }

    @Override
    public Observable<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range) {
        return this.createObservable(() -> this.commandBuilder.zrangebyscore(channel, key, range, Limit.unlimited()));
    }

    @Override
    public Observable<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, double min, double max, long offset, long count) {
        return this.createObservable(() -> this.commandBuilder.zrangebyscore(channel, key, min, max, offset, count));
    }

    @Override
    public Observable<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, String min, String max, long offset, long count) {
        return this.createObservable(() -> this.commandBuilder.zrangebyscore(channel, key, min, max, offset, count));
    }

    @Override
    public Observable<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        return this.createObservable(() -> this.commandBuilder.zrangebyscore(channel, key, range, limit));
    }

    @Override
    public Observable<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double min, double max) {
        return this.createObservable(() -> this.commandBuilder.zrangebyscoreWithScores(channel, key, min, max));
    }

    @Override
    public Observable<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String min, String max) {
        return this.createObservable(() -> this.commandBuilder.zrangebyscoreWithScores(channel, key, min, max));
    }

    @Override
    public Observable<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range) {
        return this.createObservable(() -> this.commandBuilder.zrangebyscoreWithScores(channel, key, range, Limit.unlimited()));
    }

    @Override
    public Observable<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double min, double max, long offset, long count) {
        return this.createObservable(() -> this.commandBuilder.zrangebyscoreWithScores(channel, key, min, max, offset, count));
    }

    @Override
    public Observable<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String min, String max, long offset, long count) {
        return this.createObservable(() -> this.commandBuilder.zrangebyscoreWithScores(channel, key, min, max, offset, count));
    }

    @Override
    public Observable<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        return this.createObservable(() -> this.commandBuilder.zrangebyscoreWithScores(channel, key, range, limit));
    }

    @Override
    public Observable<Long> zrank(K key, V member) {
        return this.createObservable(() -> this.commandBuilder.zrank(key, member));
    }

    @Override
    public Observable<Long> zrem(K key, V ... members) {
        return this.createObservable(() -> this.commandBuilder.zrem(key, members));
    }

    @Override
    public Observable<Long> zremrangebyrank(K key, long start, long stop) {
        return this.createObservable(() -> this.commandBuilder.zremrangebyrank(key, start, stop));
    }

    @Override
    public Observable<Long> zremrangebyscore(K key, double min, double max) {
        return this.createObservable(() -> this.commandBuilder.zremrangebyscore(key, min, max));
    }

    @Override
    public Observable<Long> zremrangebyscore(K key, String min, String max) {
        return this.createObservable(() -> this.commandBuilder.zremrangebyscore(key, min, max));
    }

    @Override
    public Observable<Long> zremrangebyscore(K key, Range<? extends Number> range) {
        return this.createObservable(() -> this.commandBuilder.zremrangebyscore(key, range));
    }

    @Override
    public Observable<V> zrevrange(K key, long start, long stop) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrevrange(key, start, stop));
    }

    @Override
    public Observable<ScoredValue<V>> zrevrangeWithScores(K key, long start, long stop) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrevrangeWithScores(key, start, stop));
    }

    @Override
    public Observable<V> zrevrangebylex(K key, Range<? extends V> range) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrevrangebylex(key, range, Limit.unlimited()));
    }

    @Override
    public Observable<V> zrevrangebylex(K key, Range<? extends V> range, Limit limit) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrevrangebylex(key, range, limit));
    }

    @Override
    public Observable<V> zrevrangebyscore(K key, double max, double min) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrevrangebyscore(key, max, min));
    }

    @Override
    public Observable<V> zrevrangebyscore(K key, String max, String min) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrevrangebyscore(key, max, min));
    }

    @Override
    public Observable<V> zrevrangebyscore(K key, Range<? extends Number> range) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrevrangebyscore(key, range, Limit.unlimited()));
    }

    @Override
    public Observable<V> zrevrangebyscore(K key, double max, double min, long offset, long count) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrevrangebyscore(key, max, min, offset, count));
    }

    @Override
    public Observable<V> zrevrangebyscore(K key, String max, String min, long offset, long count) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrevrangebyscore(key, max, min, offset, count));
    }

    @Override
    public Observable<V> zrevrangebyscore(K key, Range<? extends Number> range, Limit limit) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrevrangebyscore(key, range, limit));
    }

    @Override
    public Observable<ScoredValue<V>> zrevrangebyscoreWithScores(K key, double max, double min) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrevrangebyscoreWithScores(key, max, min));
    }

    @Override
    public Observable<ScoredValue<V>> zrevrangebyscoreWithScores(K key, String max, String min) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrevrangebyscoreWithScores(key, max, min));
    }

    @Override
    public Observable<ScoredValue<V>> zrevrangebyscoreWithScores(K key, Range<? extends Number> range) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrevrangebyscoreWithScores(key, range, Limit.unlimited()));
    }

    @Override
    public Observable<ScoredValue<V>> zrevrangebyscoreWithScores(K key, double max, double min, long offset, long count) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrevrangebyscoreWithScores(key, max, min, offset, count));
    }

    @Override
    public Observable<ScoredValue<V>> zrevrangebyscoreWithScores(K key, String max, String min, long offset, long count) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrevrangebyscoreWithScores(key, max, min, offset, count));
    }

    @Override
    public Observable<ScoredValue<V>> zrevrangebyscoreWithScores(K key, Range<? extends Number> range, Limit limit) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrevrangebyscoreWithScores(key, range, limit));
    }

    @Override
    public Observable<Long> zrevrange(ValueStreamingChannel<V> channel, K key, long start, long stop) {
        return this.createObservable(() -> this.commandBuilder.zrevrange(channel, key, start, stop));
    }

    @Override
    public Observable<Long> zrevrangeWithScores(ScoredValueStreamingChannel<V> channel, K key, long start, long stop) {
        return this.createObservable(() -> this.commandBuilder.zrevrangeWithScores(channel, key, start, stop));
    }

    @Override
    public Observable<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, double max, double min) {
        return this.createObservable(() -> this.commandBuilder.zrevrangebyscore(channel, key, max, min));
    }

    @Override
    public Observable<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, String max, String min) {
        return this.createObservable(() -> this.commandBuilder.zrevrangebyscore(channel, key, max, min));
    }

    @Override
    public Observable<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range) {
        return this.createObservable(() -> this.commandBuilder.zrevrangebyscore(channel, key, range, Limit.unlimited()));
    }

    @Override
    public Observable<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, double max, double min, long offset, long count) {
        return this.createObservable(() -> this.commandBuilder.zrevrangebyscore(channel, key, max, min, offset, count));
    }

    @Override
    public Observable<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, String max, String min, long offset, long count) {
        return this.createObservable(() -> this.commandBuilder.zrevrangebyscore(channel, key, max, min, offset, count));
    }

    @Override
    public Observable<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        return this.createObservable(() -> this.commandBuilder.zrevrangebyscore(channel, key, range, limit));
    }

    @Override
    public Observable<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double max, double min) {
        return this.createObservable(() -> this.commandBuilder.zrevrangebyscoreWithScores(channel, key, max, min));
    }

    @Override
    public Observable<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String max, String min) {
        return this.createObservable(() -> this.commandBuilder.zrevrangebyscoreWithScores(channel, key, max, min));
    }

    @Override
    public Observable<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range) {
        return this.createObservable(() -> this.commandBuilder.zrevrangebyscoreWithScores(channel, key, range, Limit.unlimited()));
    }

    @Override
    public Observable<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double max, double min, long offset, long count) {
        return this.createObservable(() -> this.commandBuilder.zrevrangebyscoreWithScores(channel, key, max, min, offset, count));
    }

    @Override
    public Observable<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String max, String min, long offset, long count) {
        return this.createObservable(() -> this.commandBuilder.zrevrangebyscoreWithScores(channel, key, max, min, offset, count));
    }

    @Override
    public Observable<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        return this.createObservable(() -> this.commandBuilder.zrevrangebyscoreWithScores(channel, key, range, limit));
    }

    @Override
    public Observable<Long> zrevrank(K key, V member) {
        return this.createObservable(() -> this.commandBuilder.zrevrank(key, member));
    }

    @Override
    public Observable<Double> zscore(K key, V member) {
        return this.createObservable(() -> this.commandBuilder.zscore(key, member));
    }

    @Override
    public Observable<Long> zunionstore(K destination, K ... keys) {
        return this.createObservable(() -> this.commandBuilder.zunionstore(destination, keys));
    }

    @Override
    public Observable<Long> zunionstore(K destination, ZStoreArgs storeArgs, K ... keys) {
        return this.createObservable(() -> this.commandBuilder.zunionstore(destination, storeArgs, keys));
    }

    @Override
    public Observable<KeyScanCursor<K>> scan() {
        return this.createObservable(this.commandBuilder::scan);
    }

    @Override
    public Observable<KeyScanCursor<K>> scan(ScanArgs scanArgs) {
        return this.createObservable(() -> this.commandBuilder.scan(scanArgs));
    }

    @Override
    public Observable<KeyScanCursor<K>> scan(ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.createObservable(() -> this.commandBuilder.scan(scanCursor, scanArgs));
    }

    @Override
    public Observable<KeyScanCursor<K>> scan(ScanCursor scanCursor) {
        return this.createObservable(() -> this.commandBuilder.scan(scanCursor));
    }

    @Override
    public Observable<StreamScanCursor> scan(KeyStreamingChannel<K> channel) {
        return this.createObservable(() -> this.commandBuilder.scanStreaming(channel));
    }

    @Override
    public Observable<StreamScanCursor> scan(KeyStreamingChannel<K> channel, ScanArgs scanArgs) {
        return this.createObservable(() -> this.commandBuilder.scanStreaming(channel, scanArgs));
    }

    @Override
    public Observable<StreamScanCursor> scan(KeyStreamingChannel<K> channel, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.createObservable(() -> this.commandBuilder.scanStreaming(channel, scanCursor, scanArgs));
    }

    @Override
    public Observable<StreamScanCursor> scan(KeyStreamingChannel<K> channel, ScanCursor scanCursor) {
        return this.createObservable(() -> this.commandBuilder.scanStreaming(channel, scanCursor));
    }

    @Override
    public Observable<ValueScanCursor<V>> sscan(K key) {
        return this.createObservable(() -> this.commandBuilder.sscan(key));
    }

    @Override
    public Observable<ValueScanCursor<V>> sscan(K key, ScanArgs scanArgs) {
        return this.createObservable(() -> this.commandBuilder.sscan(key, scanArgs));
    }

    @Override
    public Observable<ValueScanCursor<V>> sscan(K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.createObservable(() -> this.commandBuilder.sscan(key, scanCursor, scanArgs));
    }

    @Override
    public Observable<ValueScanCursor<V>> sscan(K key, ScanCursor scanCursor) {
        return this.createObservable(() -> this.commandBuilder.sscan(key, scanCursor));
    }

    @Override
    public Observable<StreamScanCursor> sscan(ValueStreamingChannel<V> channel, K key) {
        return this.createObservable(() -> this.commandBuilder.sscanStreaming(channel, key));
    }

    @Override
    public Observable<StreamScanCursor> sscan(ValueStreamingChannel<V> channel, K key, ScanArgs scanArgs) {
        return this.createObservable(() -> this.commandBuilder.sscanStreaming(channel, key, scanArgs));
    }

    @Override
    public Observable<StreamScanCursor> sscan(ValueStreamingChannel<V> channel, K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.createObservable(() -> this.commandBuilder.sscanStreaming(channel, key, scanCursor, scanArgs));
    }

    @Override
    public Observable<StreamScanCursor> sscan(ValueStreamingChannel<V> channel, K key, ScanCursor scanCursor) {
        return this.createObservable(() -> this.commandBuilder.sscanStreaming(channel, key, scanCursor));
    }

    @Override
    public Observable<MapScanCursor<K, V>> hscan(K key) {
        return this.createObservable(() -> this.commandBuilder.hscan(key));
    }

    @Override
    public Observable<MapScanCursor<K, V>> hscan(K key, ScanArgs scanArgs) {
        return this.createObservable(() -> this.commandBuilder.hscan(key, scanArgs));
    }

    @Override
    public Observable<MapScanCursor<K, V>> hscan(K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.createObservable(() -> this.commandBuilder.hscan(key, scanCursor, scanArgs));
    }

    @Override
    public Observable<MapScanCursor<K, V>> hscan(K key, ScanCursor scanCursor) {
        return this.createObservable(() -> this.commandBuilder.hscan(key, scanCursor));
    }

    @Override
    public Observable<StreamScanCursor> hscan(KeyValueStreamingChannel<K, V> channel, K key) {
        return this.createObservable(() -> this.commandBuilder.hscanStreaming(channel, key));
    }

    @Override
    public Observable<StreamScanCursor> hscan(KeyValueStreamingChannel<K, V> channel, K key, ScanArgs scanArgs) {
        return this.createObservable(() -> this.commandBuilder.hscanStreaming(channel, key, scanArgs));
    }

    @Override
    public Observable<StreamScanCursor> hscan(KeyValueStreamingChannel<K, V> channel, K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.createObservable(() -> this.commandBuilder.hscanStreaming(channel, key, scanCursor, scanArgs));
    }

    @Override
    public Observable<StreamScanCursor> hscan(KeyValueStreamingChannel<K, V> channel, K key, ScanCursor scanCursor) {
        return this.createObservable(() -> this.commandBuilder.hscanStreaming(channel, key, scanCursor));
    }

    @Override
    public Observable<ScoredValueScanCursor<V>> zscan(K key) {
        return this.createObservable(() -> this.commandBuilder.zscan(key));
    }

    @Override
    public Observable<ScoredValueScanCursor<V>> zscan(K key, ScanArgs scanArgs) {
        return this.createObservable(() -> this.commandBuilder.zscan(key, scanArgs));
    }

    @Override
    public Observable<ScoredValueScanCursor<V>> zscan(K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.createObservable(() -> this.commandBuilder.zscan(key, scanCursor, scanArgs));
    }

    @Override
    public Observable<ScoredValueScanCursor<V>> zscan(K key, ScanCursor scanCursor) {
        return this.createObservable(() -> this.commandBuilder.zscan(key, scanCursor));
    }

    @Override
    public Observable<StreamScanCursor> zscan(ScoredValueStreamingChannel<V> channel, K key) {
        return this.createObservable(() -> this.commandBuilder.zscanStreaming(channel, key));
    }

    @Override
    public Observable<StreamScanCursor> zscan(ScoredValueStreamingChannel<V> channel, K key, ScanArgs scanArgs) {
        return this.createObservable(() -> this.commandBuilder.zscanStreaming(channel, key, scanArgs));
    }

    @Override
    public Observable<StreamScanCursor> zscan(ScoredValueStreamingChannel<V> channel, K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.createObservable(() -> this.commandBuilder.zscanStreaming(channel, key, scanCursor, scanArgs));
    }

    @Override
    public Observable<StreamScanCursor> zscan(ScoredValueStreamingChannel<V> channel, K key, ScanCursor scanCursor) {
        return this.createObservable(() -> this.commandBuilder.zscanStreaming(channel, key, scanCursor));
    }

    @Override
    public String digest(V script) {
        return LettuceStrings.digest(this.codec.encodeValue(script));
    }

    @Override
    public Observable<V> time() {
        return (Observable)this.createDissolvingObservable(this.commandBuilder::time);
    }

    @Override
    public Observable<Long> waitForReplication(int replicas, long timeout) {
        return this.createObservable(() -> this.commandBuilder.wait(replicas, timeout));
    }

    @Override
    public Observable<Long> pfadd(K key, V ... values) {
        return this.createObservable(() -> this.commandBuilder.pfadd(key, values));
    }

    public Observable<Long> pfadd(K key, V value, V ... values) {
        return this.createObservable(() -> this.commandBuilder.pfadd((Object)key, (Object)value, values));
    }

    @Override
    public Observable<String> pfmerge(K destkey, K ... sourcekeys) {
        return this.createObservable(() -> this.commandBuilder.pfmerge(destkey, sourcekeys));
    }

    public Observable<String> pfmerge(K destkey, K sourceKey, K ... sourcekeys) {
        return this.createObservable(() -> this.commandBuilder.pfmerge((Object)destkey, (Object)sourceKey, sourcekeys));
    }

    @Override
    public Observable<Long> pfcount(K ... keys) {
        return this.createObservable(() -> this.commandBuilder.pfcount(keys));
    }

    public Observable<Long> pfcount(K key, K ... keys) {
        return this.createObservable(() -> this.commandBuilder.pfcount((Object)key, keys));
    }

    @Override
    public Observable<String> clusterBumpepoch() {
        return this.createObservable(() -> this.commandBuilder.clusterBumpepoch());
    }

    @Override
    public Observable<String> clusterMeet(String ip, int port) {
        return this.createObservable(() -> this.commandBuilder.clusterMeet(ip, port));
    }

    @Override
    public Observable<String> clusterForget(String nodeId) {
        return this.createObservable(() -> this.commandBuilder.clusterForget(nodeId));
    }

    @Override
    public Observable<String> clusterAddSlots(int ... slots) {
        return this.createObservable(() -> this.commandBuilder.clusterAddslots(slots));
    }

    @Override
    public Observable<String> clusterDelSlots(int ... slots) {
        return this.createObservable(() -> this.commandBuilder.clusterDelslots(slots));
    }

    @Override
    public Observable<String> clusterInfo() {
        return this.createObservable(this.commandBuilder::clusterInfo);
    }

    @Override
    public Observable<String> clusterMyId() {
        return this.createObservable(this.commandBuilder::clusterMyId);
    }

    @Override
    public Observable<String> clusterNodes() {
        return this.createObservable(this.commandBuilder::clusterNodes);
    }

    @Override
    public Observable<K> clusterGetKeysInSlot(int slot, int count) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.clusterGetKeysInSlot(slot, count));
    }

    @Override
    public Observable<Long> clusterCountKeysInSlot(int slot) {
        return this.createObservable(() -> this.commandBuilder.clusterCountKeysInSlot(slot));
    }

    @Override
    public Observable<Long> clusterCountFailureReports(String nodeId) {
        return this.createObservable(() -> this.commandBuilder.clusterCountFailureReports(nodeId));
    }

    @Override
    public Observable<Long> clusterKeyslot(K key) {
        return this.createObservable(() -> this.commandBuilder.clusterKeyslot(key));
    }

    @Override
    public Observable<String> clusterSaveconfig() {
        return this.createObservable(() -> this.commandBuilder.clusterSaveconfig());
    }

    @Override
    public Observable<String> clusterSetConfigEpoch(long configEpoch) {
        return this.createObservable(() -> this.commandBuilder.clusterSetConfigEpoch(configEpoch));
    }

    @Override
    public Observable<Object> clusterSlots() {
        return (Observable)this.createDissolvingObservable(this.commandBuilder::clusterSlots);
    }

    @Override
    public Observable<String> clusterSetSlotNode(int slot, String nodeId) {
        return this.createObservable(() -> this.commandBuilder.clusterSetSlotNode(slot, nodeId));
    }

    @Override
    public Observable<String> clusterSetSlotStable(int slot) {
        return this.createObservable(() -> this.commandBuilder.clusterSetSlotStable(slot));
    }

    @Override
    public Observable<String> clusterSetSlotMigrating(int slot, String nodeId) {
        return this.createObservable(() -> this.commandBuilder.clusterSetSlotMigrating(slot, nodeId));
    }

    @Override
    public Observable<String> clusterSetSlotImporting(int slot, String nodeId) {
        return this.createObservable(() -> this.commandBuilder.clusterSetSlotImporting(slot, nodeId));
    }

    @Override
    public Observable<String> clusterFailover(boolean force) {
        return this.createObservable(() -> this.commandBuilder.clusterFailover(force));
    }

    @Override
    public Observable<String> clusterReset(boolean hard) {
        return this.createObservable(() -> this.commandBuilder.clusterReset(hard));
    }

    @Override
    public Observable<String> asking() {
        return this.createObservable(this.commandBuilder::asking);
    }

    @Override
    public Observable<String> clusterReplicate(String nodeId) {
        return this.createObservable(() -> this.commandBuilder.clusterReplicate(nodeId));
    }

    @Override
    public Observable<String> clusterFlushslots() {
        return this.createObservable(this.commandBuilder::clusterFlushslots);
    }

    @Override
    public Observable<String> clusterSlaves(String nodeId) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.clusterSlaves(nodeId));
    }

    @Override
    public Observable<Long> zlexcount(K key, String min, String max) {
        return this.createObservable(() -> this.commandBuilder.zlexcount(key, min, max));
    }

    @Override
    public Observable<Long> zlexcount(K key, Range<? extends V> range) {
        return this.createObservable(() -> this.commandBuilder.zlexcount(key, range));
    }

    @Override
    public Observable<Long> zremrangebylex(K key, String min, String max) {
        return this.createObservable(() -> this.commandBuilder.zremrangebylex(key, min, max));
    }

    @Override
    public Observable<Long> zremrangebylex(K key, Range<? extends V> range) {
        return this.createObservable(() -> this.commandBuilder.zremrangebylex(key, range));
    }

    @Override
    public Observable<V> zrangebylex(K key, String min, String max) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrangebylex(key, min, max));
    }

    @Override
    public Observable<V> zrangebylex(K key, Range<? extends V> range) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrangebylex(key, range, Limit.unlimited()));
    }

    @Override
    public Observable<V> zrangebylex(K key, String min, String max, long offset, long count) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrangebylex(key, min, max, offset, count));
    }

    @Override
    public Observable<V> zrangebylex(K key, Range<? extends V> range, Limit limit) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.zrangebylex(key, range, limit));
    }

    @Override
    public Observable<Long> geoadd(K key, double longitude, double latitude, V member) {
        return this.createObservable(() -> this.commandBuilder.geoadd(key, longitude, latitude, member));
    }

    @Override
    public Observable<Long> geoadd(K key, Object ... lngLatMember) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.geoadd(key, lngLatMember));
    }

    @Override
    public Observable<String> geohash(K key, V ... members) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.geohash(key, members));
    }

    @Override
    public Observable<V> georadius(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.georadius(key, longitude, latitude, distance, unit.name()));
    }

    @Override
    public Observable<GeoWithin<V>> georadius(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit, GeoArgs geoArgs) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.georadius(key, longitude, latitude, distance, unit.name(), geoArgs));
    }

    @Override
    public Observable<Long> georadius(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit, GeoRadiusStoreArgs<K> geoRadiusStoreArgs) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.georadius(key, longitude, latitude, distance, unit.name(), geoRadiusStoreArgs));
    }

    @Override
    public Observable<V> georadiusbymember(K key, V member, double distance, GeoArgs.Unit unit) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.georadiusbymember(key, member, distance, unit.name()));
    }

    @Override
    public Observable<GeoWithin<V>> georadiusbymember(K key, V member, double distance, GeoArgs.Unit unit, GeoArgs geoArgs) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.georadiusbymember(key, member, distance, unit.name(), geoArgs));
    }

    @Override
    public Observable<Long> georadiusbymember(K key, V member, double distance, GeoArgs.Unit unit, GeoRadiusStoreArgs<K> geoRadiusStoreArgs) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.georadiusbymember(key, member, distance, unit.name(), geoRadiusStoreArgs));
    }

    @Override
    public Observable<GeoCoordinates> geopos(K key, V ... members) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.geopos(key, members));
    }

    @Override
    public Observable<Double> geodist(K key, V from, V to, GeoArgs.Unit unit) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.geodist(key, from, to, unit));
    }

    @Override
    public <T> Observable<T> dispatch(ProtocolKeyword type, CommandOutput<K, V, ?> output) {
        LettuceAssert.notNull(type, "Command type must not be null");
        LettuceAssert.notNull(output, "CommandOutput type must not be null");
        return (Observable)this.createDissolvingObservable(() -> new Command(type, output));
    }

    @Override
    public <T> Observable<T> dispatch(ProtocolKeyword type, CommandOutput<K, V, ?> output, CommandArgs<K, V> args) {
        LettuceAssert.notNull(type, "Command type must not be null");
        LettuceAssert.notNull(output, "CommandOutput type must not be null");
        LettuceAssert.notNull(args, "CommandArgs type must not be null");
        return (Observable)this.createDissolvingObservable(() -> new Command(type, output, args));
    }

    protected <T> Observable<T> createObservable(CommandType type, CommandOutput<K, V, T> output, CommandArgs<K, V> args) {
        return this.createObservable(() -> new Command(type, output, args));
    }

    public <T> Observable<T> createObservable(Supplier<RedisCommand<K, V, T>> commandSupplier) {
        return Observable.create(new ReactiveCommandDispatcher<K, V, T>(commandSupplier, this.connection, false));
    }

    public <T, R> R createDissolvingObservable(Supplier<RedisCommand<K, V, T>> commandSupplier) {
        return (R)Observable.create(new ReactiveCommandDispatcher<K, V, T>(commandSupplier, this.connection, true));
    }

    public <T, R> R createDissolvingObservable(CommandType type, CommandOutput<K, V, T> output, CommandArgs<K, V> args) {
        return (R)Observable.create(new ReactiveCommandDispatcher(() -> new Command(type, output, args), this.connection, true));
    }

    protected <T> Observable<Success> getSuccessObservable(final Observable<T> observable) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Success>(){

            public void call(final Subscriber<? super Success> subscriber) {
                observable.subscribe((Subscriber)new Subscriber<Object>(){

                    public void onCompleted() {
                        subscriber.onNext((Object)Success.Success);
                        subscriber.onCompleted();
                    }

                    public void onError(Throwable throwable) {
                        subscriber.onError(throwable);
                    }

                    public void onNext(Object k) {
                    }
                });
            }
        });
    }

    @Override
    public void setTimeout(long timeout, TimeUnit unit) {
        this.connection.setTimeout(timeout, unit);
    }

    @Override
    public void close() {
        this.connection.close();
    }

    @Override
    public boolean isOpen() {
        return this.connection.isOpen();
    }

    @Override
    public void reset() {
        this.getConnection().reset();
    }

    public StatefulConnection<K, V> getConnection() {
        return this.connection;
    }
}

