/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.ConnectionEventTrigger;
import com.lambdaworks.redis.ConnectionEvents;
import com.lambdaworks.redis.RedisChannelInitializer;
import com.lambdaworks.redis.RedisChannelInitializerImpl;
import com.lambdaworks.redis.event.EventBus;
import com.lambdaworks.redis.event.connection.ConnectedEvent;
import com.lambdaworks.redis.event.connection.ConnectionActivatedEvent;
import com.lambdaworks.redis.event.connection.DisconnectedEvent;
import com.lambdaworks.redis.protocol.AsyncCommand;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

class PlainChannelInitializer
extends ChannelInitializer<Channel>
implements RedisChannelInitializer {
    static final Supplier<AsyncCommand<?, ?, ?>> NO_PING = () -> null;
    private final List<ChannelHandler> handlers;
    private final Supplier<AsyncCommand<?, ?, ?>> pingCommandSupplier;
    private final EventBus eventBus;
    private volatile CompletableFuture<Boolean> initializedFuture = new CompletableFuture();

    PlainChannelInitializer(Supplier<AsyncCommand<?, ?, ?>> pingCommandSupplier, List<ChannelHandler> handlers, EventBus eventBus) {
        this.pingCommandSupplier = pingCommandSupplier;
        this.handlers = handlers;
        this.eventBus = eventBus;
    }

    protected void initChannel(Channel channel) throws Exception {
        if (channel.pipeline().get("channelActivator") == null) {
            channel.pipeline().addLast("channelActivator", (ChannelHandler)new RedisChannelInitializerImpl(){
                private AsyncCommand<?, ?, ?> pingCommand;

                public CompletableFuture<Boolean> channelInitialized() {
                    return PlainChannelInitializer.this.initializedFuture;
                }

                public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                    PlainChannelInitializer.this.eventBus.publish(new DisconnectedEvent(ConnectionEventTrigger.local(ctx), ConnectionEventTrigger.remote(ctx)));
                    PlainChannelInitializer.this.initializedFuture = new CompletableFuture();
                    this.pingCommand = null;
                    super.channelInactive(ctx);
                }

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    if (evt instanceof ConnectionEvents.Close && ctx.channel().isOpen()) {
                        ctx.channel().close();
                    }
                    if (evt instanceof ConnectionEvents.Activated && !PlainChannelInitializer.this.initializedFuture.isDone()) {
                        PlainChannelInitializer.this.initializedFuture.complete(true);
                        PlainChannelInitializer.this.eventBus.publish(new ConnectionActivatedEvent(ConnectionEventTrigger.local(ctx), ConnectionEventTrigger.remote(ctx)));
                    }
                    super.userEventTriggered(ctx, evt);
                }

                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    PlainChannelInitializer.this.eventBus.publish(new ConnectedEvent(ConnectionEventTrigger.local(ctx), ConnectionEventTrigger.remote(ctx)));
                    if (PlainChannelInitializer.this.pingCommandSupplier != NO_PING) {
                        this.pingCommand = (AsyncCommand)PlainChannelInitializer.this.pingCommandSupplier.get();
                        PlainChannelInitializer.pingBeforeActivate(this.pingCommand, PlainChannelInitializer.this.initializedFuture, ctx, PlainChannelInitializer.this.handlers);
                    } else {
                        super.channelActive(ctx);
                    }
                }

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                    if (!PlainChannelInitializer.this.initializedFuture.isDone()) {
                        PlainChannelInitializer.this.initializedFuture.completeExceptionally(cause);
                    }
                    super.exceptionCaught(ctx, cause);
                }
            });
        }
        for (ChannelHandler handler : this.handlers) {
            PlainChannelInitializer.removeIfExists(channel.pipeline(), handler.getClass());
            channel.pipeline().addLast(new ChannelHandler[]{handler});
        }
    }

    static void pingBeforeActivate(AsyncCommand<?, ?, ?> cmd, CompletableFuture<Boolean> initializedFuture, ChannelHandlerContext ctx, List<ChannelHandler> handlers) throws Exception {
        cmd.handle((o, throwable) -> {
            if (throwable == null) {
                initializedFuture.complete(true);
                ctx.fireChannelActive();
            } else {
                initializedFuture.completeExceptionally((Throwable)throwable);
            }
            return null;
        });
        ctx.channel().writeAndFlush(cmd);
    }

    static void removeIfExists(ChannelPipeline pipeline, Class<? extends ChannelHandler> handlerClass) {
        ChannelHandler channelHandler = pipeline.get(handlerClass);
        if (channelHandler != null) {
            pipeline.remove(channelHandler);
        }
    }

    public CompletableFuture<Boolean> channelInitialized() {
        return this.initializedFuture;
    }
}

