/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.api.sync.RedisCommands;
import com.lambdaworks.redis.cluster.ClusterConnectionProvider;
import com.lambdaworks.redis.cluster.DynamicNodeSelection;
import com.lambdaworks.redis.cluster.api.StatefulRedisClusterConnection;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class DynamicSyncNodeSelection<CMD, K, V>
extends DynamicNodeSelection<RedisCommands<K, V>, CMD, K, V> {
    public DynamicSyncNodeSelection(StatefulRedisClusterConnection<K, V> globalConnection, Predicate<RedisClusterNode> selector, ClusterConnectionProvider.Intent intent) {
        super(globalConnection, selector, intent);
    }

    public Iterator<RedisCommands<K, V>> iterator() {
        List list = this.nodes().stream().collect(Collectors.toList());
        return list.stream().map(node -> this.getConnection((RedisClusterNode)node).sync()).iterator();
    }

    @Override
    public RedisCommands<K, V> commands(int index) {
        return this.statefulMap().get(this.nodes().get(index)).sync();
    }

    @Override
    public Map<RedisClusterNode, RedisCommands<K, V>> asMap() {
        List<RedisClusterNode> list = this.nodes().stream().collect(Collectors.toList());
        HashMap<RedisClusterNode, RedisCommands<K, V>> map = new HashMap<RedisClusterNode, RedisCommands<K, V>>();
        list.forEach(key -> map.put((RedisClusterNode)key, this.getConnection((RedisClusterNode)key).sync()));
        return map;
    }

    @Override
    public CMD commands() {
        return null;
    }
}

