/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseCombinator {
    List<String> combinations(String in) {
        int length = in.length();
        ArrayList<String> permutationsList = new ArrayList<String>();
        int totalCombinations = this.computeTotalNumerOfCombinations(in, length);
        for (int j = 0; j < totalCombinations; ++j) {
            StringBuilder newCombination = new StringBuilder();
            int pos = 0;
            for (int i = 0; i < length; ++i) {
                char c = in.charAt(i);
                if (this.isEnglishLetter(c)) {
                    c = this.permute(c, j, pos);
                    ++pos;
                }
                newCombination.append(c);
            }
            permutationsList.add(newCombination.toString());
        }
        return permutationsList;
    }

    private char permute(char c, int permutation, int position) {
        int mask = 1 << position;
        boolean shouldBeInUpperCase = (permutation & mask) != 0;
        boolean isEffectivelyUpperCase = this.isUpperCase(c);
        if (shouldBeInUpperCase && !isEffectivelyUpperCase) {
            return this.toUpperCase(c);
        }
        if (!shouldBeInUpperCase && isEffectivelyUpperCase) {
            return this.toLowerCase(c);
        }
        return c;
    }

    private int computeTotalNumerOfCombinations(String in, int length) {
        int count = 0;
        for (int i = 0; i < length; ++i) {
            char c = in.charAt(i);
            if (!this.isEnglishLetter(c)) continue;
            ++count;
        }
        return 1 << count;
    }

    private char toUpperCase(char c) {
        if ('A' <= c && c <= 'Z') {
            return c;
        }
        if ('a' <= c && c <= 'z') {
            return (char)(c + 65 - 97);
        }
        return c;
    }

    private char toLowerCase(char c) {
        if ('a' <= c && c <= 'z') {
            return c;
        }
        if ('A' <= c && c <= 'Z') {
            return (char)(c + 97 - 65);
        }
        return c;
    }

    private boolean isEnglishLetter(char c) {
        if ('a' <= c && c <= 'z') {
            return true;
        }
        return 'A' <= c && c <= 'Z';
    }

    private boolean isUpperCase(char c) {
        return 'A' <= c && c <= 'Z';
    }
}

