/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http.ssl;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.http.ssl.SSLSocketFactoryBuilder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class CustomProtocolsSSLFactory
extends SSLSocketFactory {
    private String[] protocols;
    private SSLSocketFactory base;

    public CustomProtocolsSSLFactory(String ... protocols) throws KeyManagementException, NoSuchAlgorithmException {
        this.protocols = protocols;
        this.base = SSLSocketFactoryBuilder.create().build();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.base.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.base.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket() throws IOException {
        SSLSocket sslSocket = (SSLSocket)this.base.createSocket();
        this.resetProtocols(sslSocket);
        return sslSocket;
    }

    @Override
    public SSLSocket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        SSLSocket socket = (SSLSocket)this.base.createSocket(s, host, port, autoClose);
        this.resetProtocols(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        SSLSocket socket = (SSLSocket)this.base.createSocket(host, port);
        this.resetProtocols(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        SSLSocket socket = (SSLSocket)this.base.createSocket(host, port, localHost, localPort);
        this.resetProtocols(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocket socket = (SSLSocket)this.base.createSocket(host, port);
        this.resetProtocols(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocket socket = (SSLSocket)this.base.createSocket(address, port, localAddress, localPort);
        this.resetProtocols(socket);
        return socket;
    }

    private void resetProtocols(SSLSocket socket) {
        if (ArrayUtil.isNotEmpty((Object[])this.protocols)) {
            socket.setEnabledProtocols(this.protocols);
        }
    }
}

