/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.core.query.sqlservice;

import cn.smallbun.screw.core.exception.QueryException;
import cn.smallbun.screw.core.mapping.Mapping;
import cn.smallbun.screw.core.metadata.Column;
import cn.smallbun.screw.core.metadata.Database;
import cn.smallbun.screw.core.metadata.PrimaryKey;
import cn.smallbun.screw.core.query.AbstractDatabaseQuery;
import cn.smallbun.screw.core.query.sqlservice.model.SqlServerColumnModel;
import cn.smallbun.screw.core.query.sqlservice.model.SqlServerDatabaseModel;
import cn.smallbun.screw.core.query.sqlservice.model.SqlServerPrimaryKeyModel;
import cn.smallbun.screw.core.query.sqlservice.model.SqlServerTableModel;
import cn.smallbun.screw.core.util.Assert;
import cn.smallbun.screw.core.util.CollectionUtils;
import cn.smallbun.screw.core.util.ExceptionUtils;
import cn.smallbun.screw.core.util.JdbcUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.sql.DataSource;

public class SqlServerDataBaseQuery
extends AbstractDatabaseQuery {
    private final Map<String, List<Column>> columnsCaching = new ConcurrentHashMap<String, List<Column>>();

    public SqlServerDataBaseQuery(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public Database getDataBase() throws QueryException {
        SqlServerDatabaseModel model = new SqlServerDatabaseModel();
        model.setDatabase(this.getCatalog());
        return model;
    }

    public List<SqlServerTableModel> getTables() {
        List<SqlServerTableModel> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getTables(this.getCatalog(), this.getSchema(), "%", new String[]{"TABLE"});
            List<SqlServerTableModel> list2 = Mapping.convertList(resultSet, SqlServerTableModel.class);
            String sql = "select cast(so.name as varchar(500)) as TABLE_NAME, cast(sep.value as varchar(500)) as REMARKS from sysobjects so left JOIN sys.extended_properties sep on sep.major_id = so.id and sep.minor_id = 0 where (xtype = 'U' or xtype = 'v')";
            resultSet = this.prepareStatement(String.format(sql, this.getCatalog())).executeQuery();
            List<SqlServerTableModel> inquires = Mapping.convertList(resultSet, SqlServerTableModel.class);
            for (SqlServerTableModel model : list2) {
                for (SqlServerTableModel inquire : inquires) {
                    if (!model.getTableName().equals(inquire.getTableName())) continue;
                    model.setRemarks(inquire.getRemarks());
                }
            }
            list = list2;
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet, this.connection);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet, this.connection);
        return list;
    }

    public List<SqlServerColumnModel> getTableColumns(String table) throws QueryException {
        List<SqlServerColumnModel> list;
        Assert.notEmpty(table, "Table name can not be empty!", new Object[0]);
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getColumns(this.getCatalog(), this.getSchema(), table, "%");
            List<SqlServerColumnModel> list2 = Mapping.convertList(resultSet, SqlServerColumnModel.class);
            List<String> tableNames = list2.stream().map(SqlServerColumnModel::getTableName).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(this.columnsCaching)) {
                String sql;
                if (table.equals("%")) {
                    sql = "SELECT cast(a.name AS VARCHAR(500)) AS TABLE_NAME, cast(b.name AS VARCHAR(500)) AS COLUMN_NAME, cast(c.VALUE AS NVARCHAR(500)) AS REMARKS, cast(sys.types.name AS VARCHAR(500)) AS DATA_TYPE FROM (select name, object_id from sys.tables UNION all select name, object_id from sys.views) a INNER JOIN sys.columns b ON b.object_id = a.object_id LEFT JOIN sys.types ON b.user_type_id = sys.types.user_type_id LEFT JOIN sys.extended_properties c ON c.major_id = b.object_id AND c.minor_id = b.column_id";
                    PreparedStatement statement = this.prepareStatement(sql);
                    resultSet = statement.executeQuery();
                    int fetchSize = 4284;
                    if (resultSet.getFetchSize() < fetchSize) {
                        resultSet.setFetchSize(fetchSize);
                    }
                } else {
                    sql = "SELECT cast(a.name AS VARCHAR(500)) AS TABLE_NAME, cast(b.name AS VARCHAR(500)) AS COLUMN_NAME, cast(c.VALUE AS NVARCHAR(500)) AS REMARKS, cast(sys.types.name AS VARCHAR(500)) AS DATA_TYPE FROM (select name, object_id from sys.tables UNION all select name, object_id from sys.views) a INNER JOIN sys.columns b ON b.object_id = a.object_id LEFT JOIN sys.types ON b.user_type_id = sys.types.user_type_id LEFT JOIN sys.extended_properties c ON c.major_id = b.object_id AND c.minor_id = b.column_id where a.name='%s'";
                    resultSet = this.prepareStatement(String.format(sql, table)).executeQuery();
                }
                List<SqlServerColumnModel> inquires = Mapping.convertList(resultSet, SqlServerColumnModel.class);
                tableNames.forEach(name -> this.columnsCaching.put((String)name, inquires.stream().filter(i -> i.getTableName().equals(name)).collect(Collectors.toList())));
            }
            list2.forEach(i -> {
                List<Column> columns = this.columnsCaching.get(i.getTableName());
                columns.forEach(j -> {
                    if (i.getColumnName().equals(j.getColumnName()) && i.getTableName().equals(j.getTableName())) {
                        i.setRemarks(j.getRemarks());
                    }
                });
            });
            list = list2;
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet, this.connection);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet, this.connection);
        return list;
    }

    @Override
    public List<? extends Column> getTableColumns() throws QueryException {
        return this.getTableColumns("%");
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys(String table) throws QueryException {
        List<SqlServerPrimaryKeyModel> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getPrimaryKeys(this.getCatalog(), this.getSchema(), table);
            list = Mapping.convertList(resultSet, SqlServerPrimaryKeyModel.class);
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet, this.connection);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet, this.connection);
        return list;
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys() throws QueryException {
        List<SqlServerPrimaryKeyModel> list;
        ResultSet resultSet = null;
        try {
            String sql = "SELECT TABLE_CATALOG AS 'TABLE_QUALIFIER', TABLE_SCHEMA AS 'TABLE_OWNER', TABLE_NAME AS 'TABLE_NAME', COLUMN_NAME AS 'COLUMN_NAME', ORDINAL_POSITION AS 'KEY_SEQ', CONSTRAINT_NAME AS 'PK_NAME' FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE WHERE TABLE_CATALOG = '%s' AND TABLE_SCHEMA = '%s' ORDER BY KEY_SEQ";
            resultSet = this.prepareStatement(String.format(sql, this.getCatalog(), this.getSchema())).executeQuery();
            list = Mapping.convertList(resultSet, SqlServerPrimaryKeyModel.class);
        }
        catch (SQLException e) {
            try {
                throw new QueryException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet);
        return list;
    }
}

