/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.features;

import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.FeatureExtractor;
import com.aliasi.util.ObjectToDoubleMap;
import com.aliasi.util.Strings;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionFeatureExtractor<E>
implements FeatureExtractor<E>,
Serializable {
    static final long serialVersionUID = -8221138094563655817L;
    private final String mPrefix;
    private final String mSeparator;
    private final FeatureExtractor<E> mExtractor1;
    private final FeatureExtractor<E> mExtractor2;

    public InteractionFeatureExtractor(String prefix, String separator, FeatureExtractor<E> extractor1, FeatureExtractor<E> extractor2) {
        this.mPrefix = prefix;
        this.mSeparator = separator;
        this.mExtractor1 = extractor1;
        this.mExtractor2 = extractor2;
    }

    public InteractionFeatureExtractor(String prefix, String separator, FeatureExtractor<E> extractor) {
        this(prefix, separator, extractor, extractor);
    }

    @Override
    public Map<String, Double> features(E in) {
        return this.mExtractor1 == this.mExtractor2 ? this.features1(in) : this.features2(in);
    }

    Map<String, Double> features1(E in) {
        Map<String, Number> featureMap = this.mExtractor1.features(in);
        Object[] features = featureMap.keySet().toArray(Strings.EMPTY_STRING_ARRAY);
        Arrays.sort(features);
        double[] values = new double[features.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = featureMap.get(features[i]).doubleValue();
        }
        ObjectToDoubleMap<String> featureMapResult = new ObjectToDoubleMap<String>();
        for (int i = 0; i < features.length; ++i) {
            String initial = this.mPrefix + (String)features[i] + this.mSeparator;
            for (int j = i; j < features.length; ++j) {
                String feature = initial + (String)features[j];
                double value = values[i] * values[j];
                featureMapResult.set(feature, value);
            }
        }
        return featureMapResult;
    }

    Map<String, Double> features2(E in) {
        Map<String, Number> features1 = this.mExtractor1.features(in);
        Map<String, Number> features2 = this.mExtractor2.features(in);
        ObjectToDoubleMap<String> features = new ObjectToDoubleMap<String>();
        for (Map.Entry<String, Number> entry1 : features1.entrySet()) {
            String initial = this.mPrefix + entry1.getKey() + this.mSeparator;
            double val1 = entry1.getValue().doubleValue();
            for (Map.Entry<String, Number> entry2 : features2.entrySet()) {
                String feature = initial + entry2.getKey();
                double value = val1 * entry2.getValue().doubleValue();
                features.set(feature, value);
            }
        }
        return features;
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Serializer<F>
    extends AbstractExternalizable {
        static final long serialVersionUID = -2678228697747811841L;
        final InteractionFeatureExtractor<F> mExtractor;

        public Serializer() {
            this(null);
        }

        public Serializer(InteractionFeatureExtractor<F> extractor) {
            this.mExtractor = extractor;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(((InteractionFeatureExtractor)this.mExtractor).mPrefix);
            out.writeUTF(((InteractionFeatureExtractor)this.mExtractor).mSeparator);
            boolean same = ((InteractionFeatureExtractor)this.mExtractor).mExtractor1 == ((InteractionFeatureExtractor)this.mExtractor).mExtractor2;
            out.writeBoolean(same);
            out.writeObject(((InteractionFeatureExtractor)this.mExtractor).mExtractor1);
            if (!same) {
                out.writeObject(((InteractionFeatureExtractor)this.mExtractor).mExtractor2);
            }
        }

        @Override
        public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
            String prefix = in.readUTF();
            String separator = in.readUTF();
            boolean same = in.readBoolean();
            FeatureExtractor featureExtractor = (FeatureExtractor)in.readObject();
            if (same) {
                return new InteractionFeatureExtractor(prefix, separator, featureExtractor);
            }
            FeatureExtractor featureExtractor2 = (FeatureExtractor)in.readObject();
            return new InteractionFeatureExtractor(prefix, separator, featureExtractor, featureExtractor2);
        }
    }
}

