/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.chunk;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.TagChunkCodec;
import com.aliasi.tag.StringTagging;
import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.Strings;
import java.util.Arrays;
import java.util.Set;

abstract class AbstractTagChunkCodec
implements TagChunkCodec {
    final TokenizerFactory mTokenizerFactory;
    final boolean mEnforceConsistency;

    public AbstractTagChunkCodec() {
        this(null, false);
    }

    public AbstractTagChunkCodec(TokenizerFactory tokenizerFactory, boolean enforceConsistency) {
        this.mTokenizerFactory = tokenizerFactory;
        this.mEnforceConsistency = enforceConsistency;
    }

    public boolean enforceConsistency() {
        return this.mEnforceConsistency;
    }

    public TokenizerFactory tokenizerFactory() {
        return this.mTokenizerFactory;
    }

    @Override
    public boolean isEncodable(Chunking chunking) {
        return this.isEncodable(chunking, null);
    }

    @Override
    public boolean isDecodable(StringTagging tagging) {
        return this.isDecodable(tagging, null);
    }

    boolean isEncodable(Chunking chunking, StringBuilder sb) {
        String token;
        if (this.mTokenizerFactory == null) {
            String msg = "Tokenizer factory must be non-null to support encodability test.";
            throw new UnsupportedOperationException(msg);
        }
        Set<Chunk> chunkSet = chunking.chunkSet();
        if (chunkSet.size() == 0) {
            return true;
        }
        Chunk[] chunks = chunkSet.toArray(new Chunk[chunkSet.size()]);
        Arrays.sort(chunks, Chunk.TEXT_ORDER_COMPARATOR);
        int lastEnd = chunks[0].end();
        for (int i = 1; i < chunks.length; ++i) {
            if (chunks[i].start() < lastEnd) {
                if (sb != null) {
                    sb.append("Chunks must not overlap. chunk=" + chunks[i - 1] + " chunk=" + chunks[i]);
                }
                return false;
            }
            lastEnd = chunks[i].end();
        }
        char[] cs = Strings.toCharArray(chunking.charSequence());
        Tokenizer tokenizer = this.mTokenizerFactory.tokenizer(cs, 0, cs.length);
        int chunkPos = 0;
        boolean chunkStarted = false;
        while (chunkPos < chunks.length && (token = tokenizer.nextToken()) != null) {
            int tokenEnd;
            int tokenStart = tokenizer.lastTokenStartPosition();
            if (tokenStart == chunks[chunkPos].start()) {
                chunkStarted = true;
            }
            if ((tokenEnd = tokenizer.lastTokenEndPosition()) != chunks[chunkPos].end()) continue;
            if (!chunkStarted) {
                if (sb != null) {
                    sb.append("Chunks must start on token boundaries. Illegal chunk=" + chunks[chunkPos]);
                }
                return false;
            }
            ++chunkPos;
            chunkStarted = false;
        }
        if (chunkPos < chunks.length) {
            if (sb != null) {
                sb.append("Chunk beyond last token. chunk=" + chunks[chunkPos]);
            }
            return false;
        }
        return true;
    }

    boolean isDecodable(StringTagging tagging, StringBuilder sb) {
        if (this.mTokenizerFactory == null) {
            String msg = "Tokenizer factory must be non-null to support decodability test.";
            throw new UnsupportedOperationException(msg);
        }
        if (!this.legalTags(tagging.tags().toArray(Strings.EMPTY_STRING_ARRAY))) {
            sb.append("Illegal tags=" + tagging.tags());
            return false;
        }
        char[] cs = Strings.toCharArray(tagging.characters());
        Tokenizer tokenizer = this.mTokenizerFactory.tokenizer(cs, 0, cs.length);
        for (int n = 0; n < tagging.size(); ++n) {
            String nextToken = tokenizer.nextToken();
            if (nextToken == null) {
                if (sb != null) {
                    sb.append("More tags than tokens.");
                }
                return false;
            }
            if (tagging.tokenStart(n) != tokenizer.lastTokenStartPosition()) {
                if (sb != null) {
                    sb.append("Tokens must start/end in tagging to match tokenizer. Found token " + n + " from tokenizer=" + nextToken + " tokenizer.lastTokenStartPosition()=" + tokenizer.lastTokenStartPosition() + " tagging.tokenStart(" + n + ")=" + tagging.tokenStart(n));
                }
                return false;
            }
            if (tagging.tokenEnd(n) == tokenizer.lastTokenEndPosition()) continue;
            if (sb != null) {
                sb.append("Tokens must start/end in tagging to match tokenizer. Found token " + n + " from tokenizer=" + nextToken + " tokenizer.lastTokenEndPosition()=" + tokenizer.lastTokenEndPosition() + " tagging.tokenEnd(" + n + ")=" + tagging.tokenEnd(n));
            }
            return false;
        }
        String excessToken = tokenizer.nextToken();
        if (excessToken != null && sb != null) {
            sb.append("Extra token from tokenizer beyond tagging. token=" + excessToken + " startPosition=" + tokenizer.lastTokenStartPosition() + " endPosition=" + tokenizer.lastTokenEndPosition());
        }
        return true;
    }

    void enforceConsistency(StringTagging tagging) {
        if (!this.mEnforceConsistency) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (this.isDecodable(tagging, sb)) {
            return;
        }
        throw new IllegalArgumentException(sb.toString());
    }

    void enforceConsistency(Chunking chunking) {
        if (!this.mEnforceConsistency) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (this.isEncodable(chunking, sb)) {
            return;
        }
        throw new IllegalArgumentException(sb.toString());
    }
}

