/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.dict;

import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Compilable;
import com.aliasi.util.Scored;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class DictionaryEntry<C>
implements Compilable,
Scored {
    private final String mPhrase;
    private final C mCategory;
    private final double mScore;
    private final int mCount;

    public DictionaryEntry(String phrase, C category, int count, double score) {
        this.mPhrase = phrase;
        this.mCategory = category;
        this.mCount = count;
        this.mScore = score;
    }

    public DictionaryEntry(String phrase, C category, double score) {
        this(phrase, category, 0, score);
    }

    public DictionaryEntry(String phrase, C category, int count) {
        this(phrase, category, count, count);
    }

    public DictionaryEntry(String phrase, C category) {
        this(phrase, category, 1);
    }

    public String phrase() {
        return this.mPhrase;
    }

    public C category() {
        return this.mCategory;
    }

    @Override
    public double score() {
        return this.mScore;
    }

    public int count() {
        return this.mCount;
    }

    public String toString() {
        return this.phrase() + ":" + this.category() + " " + this.score();
    }

    public boolean equals(Object that) {
        if (!(that instanceof DictionaryEntry)) {
            return false;
        }
        DictionaryEntry thatEntry = (DictionaryEntry)that;
        return this.mPhrase.equals(thatEntry.mPhrase) && this.mCategory.equals(thatEntry.mCategory) && this.mScore == thatEntry.mScore && this.mCount == thatEntry.mCount;
    }

    public int hashCode() {
        return this.mPhrase.hashCode() + 31 * this.mCategory.hashCode();
    }

    @Override
    public void compileTo(ObjectOutput objOut) throws IOException {
        objOut.writeObject(new Externalizer(this));
    }

    private static class Externalizer<C2>
    extends AbstractExternalizable {
        private static final long serialVersionUID = -863015530144283246L;
        private final DictionaryEntry<C2> mEntry;

        public Externalizer() {
            this(null);
        }

        public Externalizer(DictionaryEntry<C2> entry) {
            this.mEntry = entry;
        }

        @Override
        public Object read(ObjectInput in) throws ClassNotFoundException, IOException {
            String phrase = in.readUTF();
            Object category = in.readObject();
            int count = in.readInt();
            double score = in.readDouble();
            return new DictionaryEntry<Object>(phrase, category, count, score);
        }

        @Override
        public void writeExternal(ObjectOutput objOut) throws IOException {
            objOut.writeUTF(this.mEntry.phrase());
            C2 category = this.mEntry.category();
            AbstractExternalizable.compileOrSerialize(category, objOut);
            objOut.writeInt(this.mEntry.count());
            objOut.writeDouble(this.mEntry.score());
        }
    }
}

