/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.lm;

import com.aliasi.lm.AbstractNode;
import com.aliasi.lm.NBestCounter;
import com.aliasi.lm.Node;
import com.aliasi.lm.NodeFactory;
import com.aliasi.util.ObjectToCounterMap;
import com.aliasi.util.Strings;
import java.util.LinkedList;
import java.util.List;

abstract class AbstractPATNode
extends AbstractNode {
    AbstractPATNode() {
    }

    abstract char[] chars();

    abstract int length();

    @Override
    public Node prune(long minCount) {
        return this.count() < minCount ? null : this;
    }

    @Override
    public long count(char[] cs, int start, int end) {
        return this.match(cs, start, end) ? this.count() : 0L;
    }

    @Override
    public long contextCount(char[] cs, int start, int end) {
        return this.properSubMatch(cs, start, end) ? this.count() : 0L;
    }

    boolean match(char[] cs, int start, int end) {
        if (end - start > this.length()) {
            return false;
        }
        return this.stringMatch(cs, start, end);
    }

    boolean properSubMatch(char[] cs, int start, int end) {
        if (end - start >= this.length()) {
            return false;
        }
        return this.stringMatch(cs, start, end);
    }

    abstract boolean stringMatch(char[] var1, int var2, int var3);

    @Override
    public void addDtrNGramCounts(long[][] uniqueTotalCounts, int depth) {
        int patDepth = this.chars().length;
        long count = this.count();
        for (int i = 0; i < patDepth; ++i) {
            long[] lArray = uniqueTotalCounts[depth + i];
            lArray[0] = lArray[0] + 1L;
            long[] lArray2 = uniqueTotalCounts[depth + i];
            lArray2[1] = lArray2[1] + count;
        }
    }

    @Override
    public void topNGramsDtrs(NBestCounter counter, char[] csAccum, int level, int dtrLevel) {
        char[] patCs = this.chars();
        if (dtrLevel > patCs.length) {
            return;
        }
        for (int i = 0; i < dtrLevel; ++i) {
            csAccum[level + i] = patCs[i];
        }
        counter.put(csAccum, level + dtrLevel, this.count());
    }

    @Override
    public void addDtrCounts(List<Long> accum, int nGramOrder) {
        char[] patCs = this.chars();
        if (nGramOrder < patCs.length) {
            accum.add(this.count());
        }
    }

    @Override
    public int numOutcomes(char[] cs, int start, int end) {
        return this.properSubMatch(cs, start, end) ? 1 : 0;
    }

    @Override
    public Node increment(char[] cs, int start, int end) {
        return this.increment(cs, start, end, 1);
    }

    @Override
    public Node increment(char[] cs, int start, int end, int incr) {
        char[] patCs = this.chars();
        long count = this.count();
        if (patCs.length == end - start && this.match(cs, start, end)) {
            return NodeFactory.createNode(patCs, 0, patCs.length, count + (long)incr);
        }
        Node tailNode = NodeFactory.createNode(patCs, 1, patCs.length, count);
        Node newNode = NodeFactory.createNode(patCs[0], tailNode, count);
        return newNode.increment(cs, start, end, incr);
    }

    @Override
    public Node decrement(char[] cs, int start, int end) {
        if (end == start) {
            return this.decrement();
        }
        char[] patCs = this.chars();
        long count = this.count();
        Node tailNode = NodeFactory.createNode(patCs, 1, patCs.length, count);
        Node newNode = NodeFactory.createNode(patCs[0], tailNode, count);
        return newNode.decrement(cs, start, end);
    }

    @Override
    public Node decrement(char[] cs, int start, int end, int decr) {
        if (end == start) {
            return this.decrement(decr);
        }
        char[] patCs = this.chars();
        long count = this.count();
        Node tailNode = NodeFactory.createNode(patCs, 1, patCs.length, count);
        Node newNode = NodeFactory.createNode(patCs[0], tailNode, count);
        return newNode.decrement(cs, start, end, decr);
    }

    @Override
    public Node decrement() {
        long count = this.count();
        if (count == 0L) {
            return this;
        }
        char[] patCs = this.chars();
        Node tailNode = NodeFactory.createNode(patCs, 1, patCs.length, count);
        return NodeFactory.createNode(patCs[0], tailNode, count - 1L);
    }

    @Override
    public Node decrement(int decr) {
        long count = this.count();
        long decrL = Math.min(count, (long)decr);
        char[] patCs = this.chars();
        Node tailNode = NodeFactory.createNode(patCs, 1, patCs.length, count - decrL);
        return NodeFactory.createNode(patCs[0], tailNode, count - decrL);
    }

    @Override
    public long size() {
        return this.chars().length + 1;
    }

    @Override
    public char[] outcomes(char[] cs, int start, int end) {
        char[] patCs = this.chars();
        for (int i = 0; i < patCs.length; ++i) {
            if (start + i == end) {
                return new char[]{patCs[i]};
            }
            if (patCs[i] == cs[start + i]) continue;
            return Strings.EMPTY_CHAR_ARRAY;
        }
        return Strings.EMPTY_CHAR_ARRAY;
    }

    @Override
    public long dtrUniqueNGramCount(int dtrLevel) {
        return dtrLevel < this.chars().length ? 1L : 0L;
    }

    @Override
    public long dtrTotalNGramCount(int dtrLevel) {
        return dtrLevel < this.chars().length ? this.count() : 0L;
    }

    @Override
    public void addDaughters(LinkedList<Node> queue) {
        char[] patCs = this.chars();
        Node tailNode = NodeFactory.createNode(patCs, 1, patCs.length, this.count());
        queue.add(tailNode);
    }

    @Override
    public void toString(StringBuilder sb, int depth) {
        sb.append(new String(this.chars()));
        sb.append(' ');
        sb.append(this.count());
    }

    @Override
    public void countNodeTypes(ObjectToCounterMap<String> counter) {
        counter.increment(this.getClass().toString());
    }
}

