/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.lm;

import com.aliasi.lm.CompiledNGramProcessLM;
import com.aliasi.lm.LanguageModel;
import com.aliasi.lm.NGramBoundaryLM;
import com.aliasi.stats.Model;
import com.aliasi.util.Exceptions;
import java.io.IOException;
import java.io.ObjectInput;

public class CompiledNGramBoundaryLM
implements LanguageModel.Sequence,
LanguageModel.Conditional,
Model<CharSequence> {
    private final char mBoundaryChar;
    private final char[] mBoundaryArray;
    private final CompiledNGramProcessLM mProcessLM;

    CompiledNGramBoundaryLM(ObjectInput objIn) throws IOException {
        this.mBoundaryChar = objIn.readChar();
        this.mBoundaryArray = new char[]{this.mBoundaryChar};
        try {
            this.mProcessLM = (CompiledNGramProcessLM)objIn.readObject();
        }
        catch (ClassNotFoundException e) {
            throw Exceptions.toIO("CompiledNGramBoundarLM(ObjectOutput)", e);
        }
    }

    @Override
    public char[] observedCharacters() {
        return this.mProcessLM.observedCharacters();
    }

    @Override
    public double log2ConditionalEstimate(CharSequence cs) {
        if (cs.length() < 1) {
            String msg = "Conditional estimates require at least one character.";
            throw new IllegalArgumentException(msg);
        }
        char[] csBounded = NGramBoundaryLM.addBoundaries(cs, this.mBoundaryChar);
        return this.mProcessLM.log2ConditionalEstimate(csBounded, 0, csBounded.length - 1);
    }

    @Override
    public double log2ConditionalEstimate(char[] cs, int start, int end) {
        if (end <= start) {
            String msg = "Conditional estimates require at least one character.";
            throw new IllegalArgumentException(msg);
        }
        char[] csBounded = NGramBoundaryLM.addBoundaries(cs, start, end, this.mBoundaryChar);
        return this.mProcessLM.log2ConditionalEstimate(csBounded, 0, csBounded.length - 1);
    }

    @Override
    public double log2Estimate(CharSequence cs) {
        char[] csBounded = NGramBoundaryLM.addBoundaries(cs, this.mBoundaryChar);
        return this.mProcessLM.log2Estimate(csBounded, 0, csBounded.length) - this.mProcessLM.log2Estimate(this.mBoundaryArray, 0, 1);
    }

    @Override
    public double log2Estimate(char[] cs, int start, int end) {
        char[] csBounded = NGramBoundaryLM.addBoundaries(cs, start, end, this.mBoundaryChar);
        return this.mProcessLM.log2Estimate(csBounded, 0, csBounded.length) - this.mProcessLM.log2Estimate(this.mBoundaryArray, 0, 1);
    }

    @Override
    public double log2Prob(CharSequence cSeq) {
        return this.log2Estimate(cSeq);
    }

    @Override
    public double prob(CharSequence cSeq) {
        return Math.pow(2.0, this.log2Estimate(cSeq));
    }
}

