/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.matrix;

import com.aliasi.matrix.AbstractVector;
import com.aliasi.matrix.Matrices;
import com.aliasi.matrix.SparseFloatVector;
import com.aliasi.matrix.Vector;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;

public class DenseVector
extends AbstractVector
implements Serializable {
    static final long serialVersionUID = -4587660322610782962L;
    static final boolean IGNORE = true;
    final double[] mValues;

    public DenseVector(int numDimensions) {
        this(DenseVector.zeroValues(numDimensions), true);
        if (numDimensions < 1) {
            String msg = "Require positive number of dimensions. Found numDimensions=" + numDimensions;
            throw new IllegalArgumentException(msg);
        }
    }

    public DenseVector(double[] values) {
        this(DenseVector.copyValues(values), true);
        if (values.length < 1) {
            String msg = "Vectors must have positive length. Found length=" + values.length;
            throw new IllegalArgumentException(msg);
        }
    }

    public DenseVector(DenseVector v) {
        this(v.mValues);
    }

    public DenseVector(Vector v) {
        this.mValues = new double[v.numDimensions()];
        for (int d = 0; d < this.mValues.length; ++d) {
            this.mValues[d] = v.value(d);
        }
    }

    DenseVector(double[] values, boolean ignore) {
        this.mValues = values;
    }

    @Override
    public double dotProduct(Vector v) {
        if (v instanceof SparseFloatVector) {
            return v.dotProduct(this);
        }
        return super.dotProduct(v);
    }

    @Override
    public void setValue(int dimension, double value) {
        this.mValues[dimension] = value;
    }

    @Override
    public int numDimensions() {
        return this.mValues.length;
    }

    @Override
    public void increment(double scale, Vector v) {
        if (v.numDimensions() != this.numDimensions()) {
            String msg = "Require dimensionality match. Found this.numDimensions()=" + this.numDimensions() + " v.numDimensions()=" + v.numDimensions();
            throw new IllegalArgumentException(msg);
        }
        if (v instanceof SparseFloatVector) {
            int[] nonZeroDims = v.nonZeroDimensions();
            float[] vals = ((SparseFloatVector)v).mValues;
            for (int i = 0; i < nonZeroDims.length; ++i) {
                int dim;
                int n = dim = nonZeroDims[i];
                this.mValues[n] = this.mValues[n] + scale * (double)vals[i];
            }
        } else {
            for (int i = 0; i < this.mValues.length; ++i) {
                int n = i;
                this.mValues[n] = this.mValues[n] + scale * v.value(i);
            }
        }
    }

    @Override
    public Vector add(Vector v) {
        return Matrices.add(this, v);
    }

    @Override
    public double value(int dimension) {
        return this.mValues[dimension];
    }

    private static double[] zeroValues(int n) {
        double[] xs = new double[n];
        Arrays.fill(xs, 0.0);
        return xs;
    }

    private static double[] copyValues(double[] values) {
        double[] xs = new double[values.length];
        System.arraycopy(values, 0, xs, 0, xs.length);
        return xs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.mValues.length; ++i) {
            sb.append(" " + i + "=" + this.mValues[i]);
        }
        return sb.toString();
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    static class Serializer
    extends AbstractExternalizable {
        static final long serialVersionUID = 3997370009258027321L;
        private final DenseVector mVector;

        public Serializer(DenseVector vector) {
            this.mVector = vector;
        }

        public Serializer() {
            this(null);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.mVector.numDimensions());
            for (int i = 0; i < this.mVector.numDimensions(); ++i) {
                out.writeDouble(this.mVector.value(i));
            }
        }

        @Override
        public Object read(ObjectInput in) throws ClassNotFoundException, IOException {
            int numDimensions = in.readInt();
            double[] vals = new double[numDimensions];
            for (int i = 0; i < numDimensions; ++i) {
                vals[i] = in.readDouble();
            }
            return new DenseVector(vals, true);
        }
    }
}

