/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.sentences;

import com.aliasi.sentences.SentenceModel;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractSentenceModel
implements SentenceModel {
    protected AbstractSentenceModel() {
    }

    @Override
    public int[] boundaryIndices(String[] tokens, String[] whitespaces) {
        AbstractSentenceModel.verifyTokensWhitespaces(tokens, whitespaces);
        return this.boundaryIndices(tokens, whitespaces, 0, tokens.length);
    }

    public int[] boundaryIndices(String[] tokens, String[] whitespaces, int start, int length) {
        AbstractSentenceModel.verifyBounds(tokens, whitespaces, start, length);
        ArrayList<Integer> boundaries = new ArrayList<Integer>();
        this.boundaryIndices(tokens, whitespaces, start, length, boundaries);
        int[] result = new int[boundaries.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)boundaries.get(i);
        }
        return result;
    }

    @Override
    public abstract void boundaryIndices(String[] var1, String[] var2, int var3, int var4, Collection<Integer> var5);

    protected static void verifyBounds(String[] tokens, String[] whitespaces, int start, int length) {
        if (tokens.length < start + length) {
            String msg = "Token array must be at least as long as start+length. tokens.length=" + tokens.length + " start=" + start + " length=" + length;
            throw new IllegalArgumentException(msg);
        }
        if (whitespaces.length <= start + length) {
            String msg = "Whitespace array must be longer than start+length. whitespaces.length=" + whitespaces.length + " start=" + start + " length=" + length;
            throw new IllegalArgumentException(msg);
        }
    }

    protected static void verifyTokensWhitespaces(String[] tokens, String[] whitespaces) {
        if (whitespaces.length == tokens.length + 1) {
            return;
        }
        String msg = "Whitespaces array must be one longer than tokens. Found tokens.length=" + tokens.length + " whitespaces.length=" + whitespaces.length;
        throw new IllegalArgumentException(msg);
    }
}

