/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.spell;

import com.aliasi.spell.WeightedEditDistance;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.BoundedPriorityQueue;
import com.aliasi.util.Math;
import com.aliasi.util.Scored;
import com.aliasi.util.ScoredObject;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public class AutoCompleter
implements Serializable {
    static final long serialVersionUID = -6846604550231066369L;
    final double mTotalCount;
    final String[] mPhrases;
    final float[] mPhraseLog2Probs;
    final char[] mLabels;
    final int[] mFirstDtr;
    final int[] mFirstOutcome;
    final int[] mOutcomes;
    int mMaxSearchQueueSize;
    final int mMaxResultsPerPrefix;
    final WeightedEditDistance mEditDistance;
    final double mMinScore;

    public AutoCompleter(Map<String, ? extends Number> phraseCounts, WeightedEditDistance editDistance, int maxResultsPerPrefix, int maxSearchQueueSize, double minScore) {
        int i;
        if (Double.isInfinite(minScore) || Double.isNaN(minScore) || minScore >= 0.0) {
            String msg = "Minimum score must be finite and negative. Found minScore=" + minScore;
            throw new IllegalArgumentException(msg);
        }
        this.mMinScore = minScore;
        String[] phrases = new String[phraseCounts.size()];
        float[] counts = new float[phraseCounts.size()];
        this.mPhrases = phrases;
        int idx = 0;
        for (Map.Entry<String, ? extends Number> entry : phraseCounts.entrySet()) {
            this.mPhrases[idx] = entry.getKey();
            counts[idx] = entry.getValue().floatValue();
            if (Float.isNaN(counts[idx]) || Float.isInfinite(counts[idx]) || counts[idx] < 0.0f) {
                String msg = "Counts must be finite and non-negative. Found phrase=" + entry.getKey() + " count=" + entry.getValue();
                throw new IllegalArgumentException(msg);
            }
            ++idx;
        }
        this.setMaxSearchQueueSize(maxSearchQueueSize);
        if (maxResultsPerPrefix <= 0) {
            String msg = "Max results per prefix must be positive. Found maxResultsPerPrefix=" + maxResultsPerPrefix;
            throw new IllegalArgumentException(msg);
        }
        this.mMaxResultsPerPrefix = maxResultsPerPrefix;
        this.mEditDistance = editDistance;
        float[] phraseLog2Probs = new float[counts.length];
        this.mPhraseLog2Probs = phraseLog2Probs;
        double totalCount = 0.0;
        for (i = 0; i < counts.length; ++i) {
            totalCount += (double)counts[i];
        }
        this.mTotalCount = totalCount;
        for (i = 0; i < counts.length; ++i) {
            phraseLog2Probs[i] = (float)Math.log2((double)counts[i] / totalCount);
        }
        int maxLength = AutoCompleter.maxLength(phrases);
        int[] numNodes = new int[maxLength];
        String last = "";
        for (String phrase : phrases) {
            int pos = AutoCompleter.prefixMatchLength(phrase, last);
            while (pos < phrase.length()) {
                int n = pos++;
                numNodes[n] = numNodes[n] + 1;
            }
            last = phrase;
        }
        int totalNumNodes = 1;
        for (int pos = 0; pos < maxLength; ++pos) {
            totalNumNodes += numNodes[pos];
        }
        int[] nextIndex = new int[maxLength];
        nextIndex[0] = 1;
        for (int pos = 1; pos < maxLength; ++pos) {
            nextIndex[pos] = nextIndex[pos - 1] + numNodes[pos - 1];
        }
        this.mLabels = new char[totalNumNodes];
        this.mFirstDtr = new int[totalNumNodes + 1];
        this.mFirstOutcome = new int[totalNumNodes + 1];
        last = "";
        for (String phrase : phrases) {
            int pos = AutoCompleter.prefixMatchLength(phrase, last);
            while (pos < phrase.length()) {
                this.mLabels[nextIndex[pos]] = phrase.charAt(pos);
                this.mFirstDtr[nextIndex[pos]] = pos + 1 < nextIndex.length ? nextIndex[pos + 1] : totalNumNodes;
                int n = pos++;
                nextIndex[n] = nextIndex[n] + 1;
            }
            last = phrase;
        }
        int outcomesLength = 0;
        int prefixCount = 0;
        block9: for (int length = 0; length <= maxLength; ++length) {
            int i2 = 0;
            while (i2 < phrases.length) {
                while (i2 < phrases.length && phrases[i2].length() < length) {
                    ++i2;
                }
                if (i2 >= phrases.length) continue block9;
                String currentPrefix = phrases[i2].substring(0, length);
                while (i2 < phrases.length && phrases[i2].startsWith(currentPrefix)) {
                    ++prefixCount;
                    ++i2;
                }
                outcomesLength += java.lang.Math.min(prefixCount, maxResultsPerPrefix);
                prefixCount = 0;
            }
        }
        this.mOutcomes = new int[outcomesLength];
        BoundedPriorityQueue<ScoredObject<Integer>> queue = new BoundedPriorityQueue<ScoredObject<Integer>>(ScoredObject.comparator(), maxResultsPerPrefix);
        int prefixIdx = 0;
        int id = 0;
        block13: for (int length = 0; length <= maxLength; ++length) {
            int i3 = 0;
            while (i3 < phrases.length) {
                while (i3 < phrases.length && phrases[i3].length() < length) {
                    ++i3;
                }
                if (i3 >= phrases.length) continue block13;
                String currentPrefix = phrases[i3].substring(0, length);
                while (i3 < phrases.length && phrases[i3].startsWith(currentPrefix)) {
                    queue.offer(new ScoredObject<Integer>(i3, phraseLog2Probs[i3]));
                    ++i3;
                }
                this.mFirstOutcome[prefixIdx++] = id;
                for (ScoredObject scoredObject : queue) {
                    this.mOutcomes[id++] = (Integer)scoredObject.getObject();
                }
                queue.clear();
            }
        }
        this.mFirstDtr[this.mFirstDtr.length - 1] = this.mFirstDtr.length - 1;
        this.mFirstOutcome[this.mFirstOutcome.length - 1] = this.mOutcomes.length;
    }

    public int maxResultsPerPrefix() {
        return this.mMaxResultsPerPrefix;
    }

    public WeightedEditDistance editDistance() {
        return this.mEditDistance;
    }

    public Map<String, Float> phraseCountMap() {
        HashMap<String, Float> counter = new HashMap<String, Float>(this.mPhrases.length * 3 / 2);
        for (int i = 0; i < this.mPhrases.length; ++i) {
            counter.put(this.mPhrases[i], Float.valueOf((float)(this.mTotalCount * java.lang.Math.pow(2.0, this.mPhraseLog2Probs[i]))));
        }
        return counter;
    }

    public int maxSearchQueueSize() {
        return this.mMaxSearchQueueSize;
    }

    public void setMaxSearchQueueSize(int size) {
        if (size <= 0) {
            String msg = "Max queue size must be positive. Found maxSearchQueueSize=" + size;
            throw new IllegalArgumentException(msg);
        }
        this.mMaxSearchQueueSize = size;
    }

    public SortedSet<ScoredObject<String>> complete(String in) {
        Results results = new Results(this.mMaxResultsPerPrefix);
        BoundedPriorityQueue<SearchState> queue = new BoundedPriorityQueue<SearchState>(ScoredObject.comparator(), this.mMaxSearchQueueSize);
        queue.offer(new SearchState(0, 0, 0.0, this.mPhraseLog2Probs[0]));
        while (!queue.isEmpty()) {
            double bestCompletionCost;
            SearchState state = (SearchState)queue.poll();
            if (results.dominate(state.mEditCost)) {
                return results;
            }
            if (state.mInputPosition == in.length()) {
                for (int k = this.mFirstOutcome[state.mTrieNode]; k < this.mFirstOutcome[state.mTrieNode + 1]; ++k) {
                    double score = (double)this.mPhraseLog2Probs[this.mOutcomes[k]] + state.mEditCost;
                    if (score < this.mMinScore) continue;
                    results.add(this.mPhrases[this.mOutcomes[k]], score);
                }
                continue;
            }
            char c = in.charAt(state.mInputPosition);
            for (int i = this.mFirstDtr[state.mTrieNode]; i < this.mFirstDtr[state.mTrieNode + 1]; ++i) {
                char d = this.mLabels[i];
                double editCost = c == d ? state.mEditCost : state.mEditCost + this.mEditDistance.substituteWeight(c, d);
                double score = editCost + (bestCompletionCost = (double)this.mPhraseLog2Probs[this.mOutcomes[this.mFirstOutcome[i]]]);
                if (score >= this.mMinScore && !results.dominate(score)) {
                    queue.offer(new SearchState(state.mInputPosition + 1, i, editCost, bestCompletionCost));
                }
                if (!((score = (editCost = state.mEditCost + this.mEditDistance.insertWeight(d)) + bestCompletionCost) >= this.mMinScore) || results.dominate(score)) continue;
                queue.offer(new SearchState(state.mInputPosition, i, editCost, bestCompletionCost));
            }
            double editCost = state.mEditCost + this.mEditDistance.deleteWeight(c);
            double score = editCost + (bestCompletionCost = (double)this.mPhraseLog2Probs[this.mOutcomes[this.mFirstOutcome[state.mTrieNode]]]);
            if (!(score >= this.mMinScore) || results.dominate(score)) continue;
            queue.offer(new SearchState(state.mInputPosition + 1, state.mTrieNode, editCost, bestCompletionCost));
        }
        return results;
    }

    boolean dominated(double score, SortedSet<ScoredObject<String>> results) {
        return score < this.mMinScore || results.size() == this.mMaxResultsPerPrefix && results.last().score() >= score;
    }

    private Object writeReplace() {
        return new Serializer(this);
    }

    static int prefixMatchLength(String x, String y) {
        int len = java.lang.Math.min(x.length(), y.length());
        for (int i = 0; i < len; ++i) {
            if (x.charAt(i) == y.charAt(i)) continue;
            return i;
        }
        return len;
    }

    static int maxLength(String[] xs) {
        int max = -1;
        for (String x : xs) {
            if (x.length() <= max) continue;
            max = x.length();
        }
        return max;
    }

    static class SearchState
    implements Scored {
        final int mInputPosition;
        final int mTrieNode;
        final double mEditCost;
        final double mScore;

        SearchState(int inputPosition, int trieNode, double editCost, double bestCompletionCost) {
            this.mInputPosition = inputPosition;
            this.mTrieNode = trieNode;
            this.mEditCost = editCost;
            this.mScore = editCost + bestCompletionCost;
        }

        @Override
        public double score() {
            return this.mScore;
        }
    }

    static class Serializer
    extends AbstractExternalizable {
        static final long serialVersionUID = 2403836255870648306L;
        final AutoCompleter mAutoCompleter;

        public Serializer() {
            this(null);
        }

        public Serializer(AutoCompleter autoCompleter) {
            this.mAutoCompleter = autoCompleter;
        }

        @Override
        public void writeExternal(ObjectOutput objOut) throws IOException {
            objOut.writeObject(this.mAutoCompleter.mEditDistance);
            objOut.writeInt(this.mAutoCompleter.mMaxResultsPerPrefix);
            objOut.writeInt(this.mAutoCompleter.mMaxSearchQueueSize);
            objOut.writeInt(this.mAutoCompleter.mPhrases.length);
            for (int i = 0; i < this.mAutoCompleter.mPhrases.length; ++i) {
                objOut.writeUTF(this.mAutoCompleter.mPhrases[i]);
                objOut.writeFloat((float)(this.mAutoCompleter.mTotalCount * java.lang.Math.pow(2.0, this.mAutoCompleter.mPhraseLog2Probs[i])));
            }
            objOut.writeDouble(this.mAutoCompleter.mMinScore);
        }

        @Override
        public Object read(ObjectInput objIn) throws ClassNotFoundException, IOException {
            WeightedEditDistance editDistance = (WeightedEditDistance)objIn.readObject();
            int maxResultsPerPrefix = objIn.readInt();
            int maxSearchQueueSize = objIn.readInt();
            int numPhrases = objIn.readInt();
            HashMap<String, Float> phraseCountMap = new HashMap<String, Float>(numPhrases * 3 / 2);
            for (int i = 0; i < numPhrases; ++i) {
                String phrase = objIn.readUTF();
                float count = objIn.readFloat();
                phraseCountMap.put(phrase, Float.valueOf(count));
            }
            double minScore = objIn.readDouble();
            return new AutoCompleter(phraseCountMap, editDistance, maxResultsPerPrefix, maxSearchQueueSize, minScore);
        }
    }

    static class Results
    extends AbstractSet<ScoredObject<String>>
    implements SortedSet<ScoredObject<String>> {
        private final String[] mResults;
        private final double[] mScores;
        private int mSize = 0;

        Results(int maxSize) {
            this.mResults = new String[maxSize];
            this.mScores = new double[maxSize];
        }

        public boolean dominate(double score) {
            return this.full() && this.mScores[this.mSize - 1] >= score;
        }

        public void add(String s, double score) {
            for (int i = 0; i < this.mSize; ++i) {
                if (score > this.mScores[i]) {
                    this.tamp(i, s);
                    this.mScores[i] = score;
                    this.mResults[i] = s;
                    return;
                }
                if (!this.mResults[i].equals(s)) continue;
                return;
            }
            if (this.mSize < this.mResults.length) {
                this.mResults[this.mSize] = s;
                this.mScores[this.mSize] = score;
                ++this.mSize;
            }
        }

        void tamp(int i, String s) {
            int n;
            int pos;
            for (pos = i; pos < this.mSize; ++pos) {
                if (!this.mResults[pos].equals(s)) continue;
                while (++pos < this.mSize) {
                    this.mResults[pos - 1] = this.mResults[pos];
                    this.mScores[pos - 1] = this.mScores[pos];
                }
                return;
            }
            if (this.mSize < this.mResults.length) {
                int n2 = this.mSize;
                n = n2;
                this.mSize = n2 + 1;
            } else {
                n = pos = this.mSize - 1;
            }
            while (--pos >= i) {
                this.mResults[pos + 1] = this.mResults[pos];
                this.mScores[pos + 1] = this.mScores[pos];
            }
        }

        public boolean full() {
            return this.mSize == this.mResults.length;
        }

        @Override
        public int size() {
            return this.mSize;
        }

        @Override
        public ScoredObject<String> first() {
            if (this.mSize == 0) {
                throw new NoSuchElementException();
            }
            return new ScoredObject<String>(this.mResults[0], this.mScores[0]);
        }

        @Override
        public ScoredObject<String> last() {
            if (this.mSize == 0) {
                throw new NoSuchElementException();
            }
            return new ScoredObject<String>(this.mResults[this.mSize - 1], this.mScores[this.mSize - 1]);
        }

        @Override
        public SortedSet<ScoredObject<String>> headSet(ScoredObject<String> from) {
            return null;
        }

        @Override
        public SortedSet<ScoredObject<String>> tailSet(ScoredObject<String> from) {
            return null;
        }

        @Override
        public SortedSet<ScoredObject<String>> subSet(ScoredObject<String> from, ScoredObject<String> to) {
            return null;
        }

        @Override
        public Comparator<ScoredObject<String>> comparator() {
            return ScoredObject.reverseComparator();
        }

        @Override
        public Iterator<ScoredObject<String>> iterator() {
            return new ResultsIterator();
        }

        class ResultsIterator
        implements Iterator<ScoredObject<String>> {
            int mPosition = 0;

            ResultsIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.mPosition < Results.this.mSize;
            }

            @Override
            public ScoredObject<String> next() {
                ++this.mPosition;
                return new ScoredObject<String>(Results.this.mResults[this.mPosition - 1], Results.this.mScores[this.mPosition - 1]);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

