/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.spell;

import com.aliasi.corpus.ObjectHandler;
import com.aliasi.lm.CompiledNGramProcessLM;
import com.aliasi.lm.NGramProcessLM;
import com.aliasi.spell.CompiledSpellChecker;
import com.aliasi.spell.WeightedEditDistance;
import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Compilable;
import com.aliasi.util.ObjectToCounterMap;
import com.aliasi.util.Strings;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class TrainSpellChecker
implements ObjectHandler<CharSequence>,
Compilable,
Serializable {
    static final long serialVersionUID = -3599682964675009111L;
    private final WeightedEditDistance mEditDistance;
    private final NGramProcessLM mLM;
    private final TokenizerFactory mTokenizerFactory;
    private final ObjectToCounterMap<String> mTokenCounter;
    private long mNumTrainingChars = 0L;

    private TrainSpellChecker(long numTrainingChars, WeightedEditDistance editDistance, NGramProcessLM lm, TokenizerFactory tokenizerFactory, ObjectToCounterMap<String> tokenCounter) {
        this.mNumTrainingChars = numTrainingChars;
        this.mEditDistance = editDistance;
        this.mLM = lm;
        this.mTokenizerFactory = tokenizerFactory;
        this.mTokenCounter = tokenCounter;
    }

    public TrainSpellChecker(NGramProcessLM lm, WeightedEditDistance editDistance) {
        this(lm, editDistance, null);
    }

    public TrainSpellChecker(NGramProcessLM lm, WeightedEditDistance editDistance, TokenizerFactory tokenizerFactory) {
        this.mLM = lm;
        this.mTokenizerFactory = tokenizerFactory;
        this.mEditDistance = editDistance;
        this.mTokenCounter = new ObjectToCounterMap();
    }

    public NGramProcessLM languageModel() {
        return this.mLM;
    }

    public WeightedEditDistance editDistance() {
        return this.mEditDistance;
    }

    public ObjectToCounterMap<String> tokenCounter() {
        return this.mTokenCounter;
    }

    public void train(CharSequence cSeq, int count) {
        if (count < 0) {
            String msg = "Training counts must be non-negative. Found count=" + count;
            throw new IllegalArgumentException(msg);
        }
        if (count == 0) {
            return;
        }
        this.mLM.train(this.normalizeQuery(cSeq), count);
        this.mNumTrainingChars += (long)(count * cSeq.length());
    }

    public long numTrainingChars() {
        return this.mNumTrainingChars;
    }

    @Override
    public void handle(CharSequence cSeq) {
        this.mLM.train(this.normalizeQuery(cSeq));
        this.mNumTrainingChars += (long)cSeq.length();
    }

    public void pruneTokens(int minCount) {
        this.mTokenCounter.prune(minCount);
    }

    public void pruneLM(int minCount) {
        this.mLM.substringCounter().prune(minCount);
    }

    @Override
    public void compileTo(ObjectOutput objOut) throws IOException {
        objOut.writeObject(new Externalizer(this));
    }

    private Object writeReplace() {
        return new Serializer(this);
    }

    StringBuilder normalizeQuery(CharSequence cSeq) {
        StringBuilder sb = new StringBuilder();
        sb.append(' ');
        if (this.mTokenizerFactory == null) {
            Strings.normalizeWhitespace(cSeq, sb);
            sb.append(' ');
        } else {
            String nextToken;
            char[] cs = Strings.toCharArray(cSeq);
            Tokenizer tokenizer = this.mTokenizerFactory.tokenizer(cs, 0, cs.length);
            while ((nextToken = tokenizer.nextToken()) != null) {
                this.mTokenCounter.increment(nextToken);
                sb.append(nextToken);
                sb.append(' ');
            }
        }
        return sb;
    }

    static class Serializer
    extends AbstractExternalizable {
        static final long serialVersionUID = -8575906929649837646L;
        private TrainSpellChecker mTrainer;

        public Serializer() {
            this(null);
        }

        public Serializer(TrainSpellChecker trainer) {
            this.mTrainer = trainer;
        }

        @Override
        public void writeExternal(ObjectOutput objOut) throws IOException {
            objOut.writeLong(this.mTrainer.mNumTrainingChars);
            objOut.writeObject(this.mTrainer.mLM);
            boolean tokenizing = this.mTrainer.mTokenizerFactory != null;
            objOut.writeBoolean(tokenizing);
            if (tokenizing) {
                AbstractExternalizable.serializeOrCompile(this.mTrainer.mTokenizerFactory, objOut);
                objOut.writeObject(this.mTrainer.mTokenCounter);
            }
            AbstractExternalizable.serializeOrCompile(this.mTrainer.mEditDistance, objOut);
        }

        @Override
        public Object read(ObjectInput objIn) throws ClassNotFoundException, IOException {
            long numTrainingChars = objIn.readLong();
            NGramProcessLM lm = (NGramProcessLM)objIn.readObject();
            boolean tokenizing = objIn.readBoolean();
            TokenizerFactory tokenizerFactory = null;
            ObjectToCounterMap tokenCounter = null;
            if (tokenizing) {
                ObjectToCounterMap tempTokenCounter;
                tokenizerFactory = (TokenizerFactory)objIn.readObject();
                tokenCounter = tempTokenCounter = (ObjectToCounterMap)objIn.readObject();
            }
            WeightedEditDistance editDistance = (WeightedEditDistance)objIn.readObject();
            return new TrainSpellChecker(numTrainingChars, editDistance, lm, tokenizerFactory, tokenCounter);
        }
    }

    static class Externalizer
    extends AbstractExternalizable {
        private static final long serialVersionUID = 4907338741905144267L;
        private final TrainSpellChecker mTrainer;

        public Externalizer() {
            this(null);
        }

        public Externalizer(TrainSpellChecker trainer) {
            this.mTrainer = trainer;
        }

        @Override
        public void writeExternal(ObjectOutput objOut) throws IOException {
            this.mTrainer.mLM.compileTo(objOut);
            boolean tokenizing = this.mTrainer.mTokenizerFactory != null;
            objOut.writeBoolean(tokenizing);
            if (tokenizing) {
                Set keySet = this.mTrainer.mTokenCounter.keySet();
                objOut.writeObject(new HashSet(keySet));
            }
            AbstractExternalizable.compileOrSerialize(this.mTrainer.mEditDistance, objOut);
        }

        @Override
        public Object read(ObjectInput objIn) throws ClassNotFoundException, IOException {
            CompiledNGramProcessLM lm = (CompiledNGramProcessLM)objIn.readObject();
            boolean tokenizing = objIn.readBoolean();
            Set tokenSet = null;
            if (tokenizing) {
                Set tempTokenSet;
                tokenSet = tempTokenSet = (Set)objIn.readObject();
            }
            WeightedEditDistance editDistance = (WeightedEditDistance)objIn.readObject();
            return new CompiledSpellChecker(lm, editDistance, tokenSet);
        }
    }
}

