/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.suffixarray;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class CharSuffixArray {
    private final String mText;
    private final int[] mSuffixArray;
    private final int mMaxSuffixLength;
    public static char SEPARATOR = (char)65535;

    public CharSuffixArray(String text) {
        this(text, Integer.MAX_VALUE);
    }

    public CharSuffixArray(String text, int maxSuffixLength) {
        this.mText = text;
        this.mMaxSuffixLength = maxSuffixLength;
        Integer[] is = new Integer[text.length()];
        for (int i = 0; i < text.length(); ++i) {
            is[i] = i;
        }
        Arrays.sort(is, new IndexComparator());
        int[] suffixArray = new int[is.length];
        for (int i = 0; i < is.length; ++i) {
            suffixArray[i] = is[i];
        }
        this.mSuffixArray = suffixArray;
    }

    public String text() {
        return this.mText;
    }

    public int maxSuffixLength() {
        return this.mMaxSuffixLength;
    }

    public int suffixArray(int idx) {
        return this.mSuffixArray[idx];
    }

    public int suffixArrayLength() {
        return this.mText.length();
    }

    public String suffix(int csIndex, int maxLength) {
        return this.mText.substring(csIndex, CharSuffixArray.end(csIndex, this.mText.length(), maxLength));
    }

    static int end(int csIndex, int textLength, int maxLength) {
        return (long)csIndex + (long)maxLength >= (long)textLength ? textLength : csIndex + maxLength;
    }

    public List<int[]> prefixMatches(int minMatchLength) {
        ArrayList<int[]> matches = new ArrayList<int[]>();
        int i = 0;
        while (i < this.mSuffixArray.length) {
            int j = this.suffixesMatchTo(i, minMatchLength);
            if (i + 1 != j) {
                matches.add(new int[]{i, j});
                i = j;
                continue;
            }
            ++i;
        }
        return matches;
    }

    private int suffixesMatchTo(int i, int minMatchLength) {
        int index2;
        int j;
        int index1 = this.mSuffixArray[i];
        for (j = i + 1; j < this.mSuffixArray.length && this.matchChars(index1, index2 = this.mSuffixArray[j], minMatchLength); ++j) {
        }
        return j;
    }

    private boolean matchChars(int index1, int index2, int minMatches) {
        if (index1 + minMatches > this.mSuffixArray.length) {
            return false;
        }
        if (index2 + minMatches > this.mSuffixArray.length) {
            return false;
        }
        for (int k = 0; k < minMatches; ++k) {
            if (this.mText.charAt(index1 + k) == this.mText.charAt(index2 + k)) continue;
            return false;
        }
        return true;
    }

    class IndexComparator
    implements Comparator<Integer> {
        IndexComparator() {
        }

        @Override
        public int compare(Integer i, Integer j) {
            String cs = CharSuffixArray.this.mText;
            int m = i;
            int n = j;
            for (int k = 0; k < CharSuffixArray.this.mMaxSuffixLength; ++k) {
                if (m == cs.length() || cs.charAt(m) == SEPARATOR) {
                    if (n == cs.length() || cs.charAt(n) == SEPARATOR) {
                        return 0;
                    }
                    return -1;
                }
                if (n == cs.length() || cs.charAt(n) == SEPARATOR) {
                    return 1;
                }
                if (cs.charAt(m) < cs.charAt(n)) {
                    return -1;
                }
                if (cs.charAt(m) > cs.charAt(n)) {
                    return 1;
                }
                ++m;
                ++n;
            }
            return 0;
        }
    }
}

