/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tag;

import com.aliasi.corpus.ObjectHandler;
import com.aliasi.corpus.StringParser;
import com.aliasi.tag.Tagging;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LineTaggingParser
extends StringParser<ObjectHandler<Tagging<String>>> {
    private final Pattern mTokenTagPattern;
    private final Pattern mIgnoreLinePattern;
    private final Pattern mEosPattern;
    private final int mTokenGroup;
    private final int mTagGroup;

    public LineTaggingParser(String matchRegex, int tokenGroup, int tagGroup, String ignoreRegex, String eosRegex) {
        super(null);
        this.mTokenTagPattern = Pattern.compile(matchRegex);
        this.mTokenGroup = tokenGroup;
        this.mTagGroup = tagGroup;
        this.mIgnoreLinePattern = Pattern.compile(ignoreRegex);
        this.mEosPattern = Pattern.compile(eosRegex);
    }

    @Override
    public void parseString(char[] cs, int start, int end) {
        int i = -1;
        String line = null;
        try {
            String in = new String(cs, start, end - start);
            String[] lines = in.split("\r\n|\n|\r");
            ArrayList<String> tokenList = new ArrayList<String>();
            ArrayList<String> tagList = new ArrayList<String>();
            for (i = 0; i < lines.length; ++i) {
                line = lines[i];
                Matcher lineIgnorer = this.mIgnoreLinePattern.matcher(lines[i]);
                if (lineIgnorer.matches()) continue;
                Matcher eosMatcher = this.mEosPattern.matcher(lines[i]);
                if (eosMatcher.matches()) {
                    this.handle(tokenList, tagList);
                    continue;
                }
                Matcher matcher = this.mTokenTagPattern.matcher(lines[i]);
                if (!matcher.matches()) {
                    String msg = "Illegal frmat around line=" + i + " line=|" + lines[i] + "|" + in;
                    throw new IllegalArgumentException(msg);
                }
                String token = matcher.group(this.mTokenGroup);
                String tag = matcher.group(this.mTagGroup);
                tokenList.add(token);
                tagList.add(tag);
            }
            this.handle(tokenList, tagList);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Parsing exception around line=" + i + " line=|" + line + "|", e);
        }
    }

    void handle(List<String> tokenList, List<String> tagList) {
        Tagging<String> tagging = new Tagging<String>(tokenList, tagList);
        ((ObjectHandler)this.getHandler()).handle(tagging);
        tokenList.clear();
        tagList.clear();
    }
}

