/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tag;

import com.aliasi.classify.BaseClassifierEvaluator;
import com.aliasi.classify.Classification;
import com.aliasi.corpus.ObjectHandler;
import com.aliasi.tag.Tagger;
import com.aliasi.tag.Tagging;
import com.aliasi.util.ObjectToCounterMap;
import com.aliasi.util.Strings;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class TaggerEvaluator<E>
implements ObjectHandler<Tagging<E>> {
    private Tagger<E> mTagger;
    private final List<List<String>> mReferenceTagss = new ArrayList<List<String>>();
    private final List<List<String>> mResponseTagss = new ArrayList<List<String>>();
    private final List<List<E>> mTokenss;

    public TaggerEvaluator(Tagger<E> tagger, boolean storeTokens) {
        this.mTagger = tagger;
        this.mTokenss = storeTokens ? new ArrayList() : null;
    }

    public Tagger<E> tagger() {
        return this.mTagger;
    }

    public void setTagger(Tagger<E> tagger) {
        this.mTagger = tagger;
    }

    public boolean storeTokens() {
        return this.mTokenss != null;
    }

    @Override
    public void handle(Tagging<E> referenceTagging) {
        List<E> tokens = referenceTagging.tokens();
        Tagging<E> responseTagging = this.mTagger.tag(tokens);
        this.addCase(referenceTagging, responseTagging);
    }

    public void addCase(Tagging<E> referenceTagging, Tagging<E> responseTagging) {
        if (!((Object)referenceTagging.tokens()).equals(responseTagging.tokens())) {
            String msg = "Require taggings to have same tokens. Found referenceTagging.tokens() = " + referenceTagging.tokens() + " responseTagging.tokens()=" + responseTagging.tokens();
            throw new IllegalArgumentException(msg);
        }
        this.mReferenceTagss.add(referenceTagging.tags());
        this.mResponseTagss.add(responseTagging.tags());
        if (this.storeTokens()) {
            this.mTokenss.add(referenceTagging.tokens());
        }
    }

    public int numCases() {
        return this.mReferenceTagss.size();
    }

    public long numTokens() {
        long count = 0L;
        for (List<String> tags : this.mReferenceTagss) {
            count += (long)tags.size();
        }
        return count;
    }

    public List<String> tags() {
        HashSet tagSet = new HashSet();
        for (int i = 0; i < this.mReferenceTagss.size(); ++i) {
            tagSet.addAll(this.mReferenceTagss.get(i));
            tagSet.addAll(this.mResponseTagss.get(i));
        }
        return new ArrayList<String>(tagSet);
    }

    public ObjectToCounterMap<Integer> inputSizeHistogram() {
        ObjectToCounterMap<Integer> hist = new ObjectToCounterMap<Integer>();
        for (List<String> tags : this.mReferenceTagss) {
            hist.increment(tags.size());
        }
        return hist;
    }

    public double caseAccuracy() {
        int correct = 0;
        for (int i = 0; i < this.mReferenceTagss.size(); ++i) {
            if (!((Object)this.mReferenceTagss.get(i)).equals(this.mResponseTagss.get(i))) continue;
            ++correct;
        }
        return (double)correct / (double)this.mReferenceTagss.size();
    }

    public BaseClassifierEvaluator<E> unknownTokenEval(Set<E> knownTokenSet) {
        if (!this.storeTokens()) {
            String msg = "Must store inputs to compute unknown token accuracy.";
            throw new UnsupportedOperationException(msg);
        }
        return this.eval(knownTokenSet);
    }

    public BaseClassifierEvaluator<E> tokenEval() {
        return this.eval(null);
    }

    public String lastCaseToString(Set<E> knownTokenSet) {
        if (this.mTokenss.isEmpty()) {
            return "No cases handled yet.";
        }
        List<E> lastTokens = this.mTokenss.get(this.mTokenss.size() - 1);
        List<String> refTags = this.mReferenceTagss.get(this.mReferenceTagss.size() - 1);
        List<String> respTags = this.mResponseTagss.get(this.mResponseTagss.size() - 1);
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        sb.append("Known  Token     Reference | Response  ?correct\n");
        for (int tokenIndex = 0; tokenIndex < lastTokens.size(); ++tokenIndex) {
            sb.append(knownTokenSet == null || knownTokenSet.contains(lastTokens.get(tokenIndex)) ? "    " : "  ? ");
            sb.append(TaggerEvaluator.pad(lastTokens.get(tokenIndex), 20));
            sb.append(TaggerEvaluator.pad(refTags.get(tokenIndex), 4));
            sb.append("  |  ");
            sb.append(TaggerEvaluator.pad(respTags.get(tokenIndex), 6));
            if (refTags.get(tokenIndex).equals(respTags.get(tokenIndex))) {
                sb.append("\n");
                continue;
            }
            sb.append(" XX\n");
        }
        return sb.toString();
    }

    static String pad(Object obj, int length) {
        String in = obj.toString();
        if (in.length() > length) {
            return in.substring(0, length - 4) + "... ";
        }
        if (in.length() == length) {
            return in;
        }
        StringBuilder sb = new StringBuilder(length);
        sb.append(in);
        while (sb.length() < length) {
            sb.append(' ');
        }
        return sb.toString();
    }

    BaseClassifierEvaluator<E> eval(Set<E> knownTokenSet) {
        String[] tags = this.tags().toArray(Strings.EMPTY_STRING_ARRAY);
        BaseClassifierEvaluator<E> evaluator = new BaseClassifierEvaluator<E>(null, tags, this.storeTokens());
        for (int i = 0; i < this.mReferenceTagss.size(); ++i) {
            List<String> referenceTags = this.mReferenceTagss.get(i);
            List<String> responseTags = this.mResponseTagss.get(i);
            List<E> tokens = this.mTokenss.get(i);
            for (int j = 0; j < tokens.size(); ++j) {
                String referenceTag = referenceTags.get(j);
                Classification responseClassification = new Classification(responseTags.get(j));
                if (knownTokenSet != null && knownTokenSet.contains(tokens.get(j))) continue;
                evaluator.addClassification(referenceTag, responseClassification, tokens.get(j));
            }
        }
        return evaluator;
    }
}

