/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Tagging<E> {
    private final List<E> mTokens;
    private final List<String> mTags;

    public Tagging(List<E> tokens, List<String> tags) {
        this(new ArrayList<E>(tokens), new ArrayList<String>(tags), true);
        if (tokens.size() != tags.size()) {
            String msg = "Tokens and tags must be same size. Found tokens.size()=" + tokens.size() + " tags.size()=" + tags.size();
            throw new IllegalArgumentException(msg);
        }
    }

    Tagging(List<E> tokens, List<String> tags, boolean ignore) {
        this.mTokens = tokens;
        this.mTags = tags;
    }

    public int size() {
        return this.mTokens.size();
    }

    public E token(int n) {
        return this.mTokens.get(n);
    }

    public String tag(int n) {
        return this.mTags.get(n);
    }

    public List<E> tokens() {
        return Collections.unmodifiableList(this.mTokens);
    }

    public List<String> tags() {
        return Collections.unmodifiableList(this.mTags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(this.token(i) + "/" + this.tag(i));
        }
        return sb.toString();
    }
}

