/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import com.aliasi.util.Scored;
import java.util.Comparator;

public class ScoredObject<E>
implements Scored {
    private final E mObj;
    private final double mScore;
    static final Comparator<Scored> REVERSE_SCORE_COMPARATOR = new ReverseScoredComparator();
    static final Comparator<Scored> SCORE_COMPARATOR = new ScoredComparator();

    public ScoredObject(E obj, double score) {
        this.mObj = obj;
        this.mScore = score;
    }

    public E getObject() {
        return this.mObj;
    }

    @Override
    public double score() {
        return this.mScore;
    }

    public String toString() {
        return this.mScore + ":" + this.getObject();
    }

    public boolean equals(Object that) {
        if (!(that instanceof ScoredObject)) {
            return false;
        }
        ScoredObject thatSo = (ScoredObject)that;
        return this.mObj.equals(thatSo.mObj) && this.mScore == thatSo.mScore;
    }

    public static <E extends Scored> Comparator<E> comparator() {
        Comparator<Scored> result = SCORE_COMPARATOR;
        return result;
    }

    public static <E extends Scored> Comparator<E> reverseComparator() {
        Comparator<Scored> result = REVERSE_SCORE_COMPARATOR;
        return result;
    }

    static class ReverseScoredComparator
    implements Comparator<Scored> {
        ReverseScoredComparator() {
        }

        @Override
        public int compare(Scored obj1, Scored obj2) {
            return obj1.score() > obj2.score() ? -1 : (obj1.score() < obj2.score() ? 1 : 0);
        }
    }

    static class ScoredComparator
    implements Comparator<Scored> {
        ScoredComparator() {
        }

        @Override
        public int compare(Scored obj1, Scored obj2) {
            return obj1.score() > obj2.score() ? 1 : (obj1.score() < obj2.score() ? -1 : 0);
        }
    }
}

