/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.credentials.http;

import com.aliyun.credentials.http.FormatType;
import com.aliyun.credentials.http.HttpRequest;
import com.aliyun.credentials.http.HttpResponse;
import com.aliyun.credentials.http.TrueHostnameVerifier;
import com.aliyun.credentials.http.X509TrustManagerImp;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class CompatibleUrlConnClient
implements Closeable {
    protected static final String ACCEPT_ENCODING = "Accept-Encoding";

    public static HttpResponse compatibleGetResponse(HttpRequest request) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        CompatibleUrlConnClient client = new CompatibleUrlConnClient();
        HttpResponse response = client.syncInvoke(request);
        client.close();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse syncInvoke(HttpRequest request) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        InputStream content = null;
        HttpResponse response = null;
        HttpURLConnection httpConn = this.buildHttpConnection(request);
        try {
            httpConn.connect();
            content = httpConn.getInputStream();
            response = new HttpResponse(httpConn.getURL().toString());
            this.parseHttpConn(response, httpConn, content, null);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        catch (IOException e) {
            content = httpConn.getErrorStream();
            response = new HttpResponse(httpConn.getURL().toString());
            this.parseHttpConn(response, httpConn, content, e);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        finally {
            if (content != null) {
                content.close();
            }
            httpConn.disconnect();
        }
    }

    public SSLSocketFactory createSSLSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        X509TrustManagerImp compositeX509TrustManager = new X509TrustManagerImp();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{compositeX509TrustManager}, new SecureRandom());
        return sslContext.getSocketFactory();
    }

    public void checkHttpRequest(HttpRequest request) {
        String strUrl = request.getSysUrl();
        if (null == strUrl) {
            throw new IllegalArgumentException("URL is null for HttpRequest.");
        }
        if (null == request.getSysMethod()) {
            throw new IllegalArgumentException("Method is not set for HttpRequest.");
        }
    }

    public HttpURLConnection initHttpConnection(URL url, HttpRequest request) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        HttpURLConnection httpConn;
        SSLSocketFactory sslSocketFactory = this.createSSLSocketFactory();
        if ("https".equalsIgnoreCase(url.getProtocol())) {
            HttpsURLConnection httpsConn = (HttpsURLConnection)url.openConnection();
            httpsConn.setSSLSocketFactory(sslSocketFactory);
            httpsConn.setHostnameVerifier(new TrueHostnameVerifier());
            httpConn = httpsConn;
        } else {
            httpConn = (HttpURLConnection)url.openConnection();
        }
        httpConn.setRequestMethod(request.getSysMethod().toString());
        httpConn.setInstanceFollowRedirects(false);
        httpConn.setDoOutput(true);
        httpConn.setDoInput(true);
        httpConn.setUseCaches(false);
        this.setConnectionTimeout(httpConn, request);
        httpConn.setRequestProperty(ACCEPT_ENCODING, "identity");
        return httpConn;
    }

    public void setConnectionTimeout(HttpURLConnection httpConn, HttpRequest request) {
        httpConn.setConnectTimeout(request.getSysConnectTimeout());
        httpConn.setReadTimeout(request.getSysReadTimeout());
    }

    public HttpURLConnection buildHttpConnection(HttpRequest request) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        this.checkHttpRequest(request);
        String strUrl = request.getSysUrl();
        URL url = new URL(strUrl);
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        HttpURLConnection httpConn = this.initHttpConnection(url, request);
        return httpConn;
    }

    public void parseHttpConn(HttpResponse response, HttpURLConnection httpConn, InputStream content, Exception e) throws IOException, NoSuchAlgorithmException {
        if (null == content) {
            response.setResponseMessage(e.getMessage());
            return;
        }
        byte[] buff = this.readContent(content);
        response.setResponseCode(httpConn.getResponseCode());
        response.setResponseMessage(httpConn.getResponseMessage());
        Map<String, List<String>> headers = httpConn.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (null == key) continue;
            List<String> values = entry.getValue();
            StringBuilder builder = new StringBuilder(values.get(0));
            for (int i = 1; i < values.size(); ++i) {
                builder.append(",");
                builder.append(values.get(i));
            }
            response.putHeaderParameter(key, builder.toString());
        }
        String type = response.getHeaderValue("Content-Type");
        response.setSysEncoding("UTF-8");
        String[] split = type.split(";");
        response.setHttpContentType(FormatType.mapAcceptToFormat(split[0].trim()));
        String[] codings = split[1].split("=");
        response.setSysEncoding(codings[1].trim().toUpperCase());
        response.setHttpContent(buff, response.getSysEncoding(), response.getHttpContentType());
    }

    public byte[] readContent(InputStream content) throws IOException {
        int read;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        while ((read = content.read(buff)) != -1) {
            outputStream.write(buff, 0, read);
        }
        return outputStream.toByteArray();
    }

    @Override
    public void close() {
    }
}

