/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal;

import com.android.annotations.NonNull;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.ClassField;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class BaseConfigImpl
implements Serializable,
BaseConfig {
    private static final long serialVersionUID = 1L;
    private final List<ClassField> mBuildConfigFields = Lists.newArrayList();
    private final List<File> mProguardFiles = Lists.newArrayList();
    private final List<File> mConsumerProguardFiles = Lists.newArrayList();

    public void setBuildConfigFields(ClassField ... fields) {
        this.mBuildConfigFields.clear();
        this.mBuildConfigFields.addAll(Arrays.asList(fields));
    }

    public void setBuildConfigFields(@NonNull Collection<ClassField> fields) {
        this.mBuildConfigFields.clear();
        this.mBuildConfigFields.addAll(fields);
    }

    public void addBuildConfigField(@NonNull ClassField field) {
        this.mBuildConfigFields.add(field);
    }

    @NonNull
    public List<ClassField> getBuildConfigFields() {
        return this.mBuildConfigFields;
    }

    @NonNull
    public List<File> getProguardFiles() {
        return this.mProguardFiles;
    }

    @NonNull
    public List<File> getConsumerProguardFiles() {
        return this.mConsumerProguardFiles;
    }

    protected void _initWith(BaseConfig that) {
        this.setBuildConfigFields(that.getBuildConfigFields());
        this.mProguardFiles.clear();
        this.mProguardFiles.addAll(that.getProguardFiles());
        this.mConsumerProguardFiles.clear();
        this.mConsumerProguardFiles.addAll(that.getConsumerProguardFiles());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseConfigImpl that = (BaseConfigImpl)o;
        if (!((Object)this.mBuildConfigFields).equals(that.mBuildConfigFields)) {
            return false;
        }
        if (!((Object)this.mProguardFiles).equals(that.mProguardFiles)) {
            return false;
        }
        return ((Object)this.mConsumerProguardFiles).equals(that.mConsumerProguardFiles);
    }

    public int hashCode() {
        int result = ((Object)this.mBuildConfigFields).hashCode();
        result = 31 * result + ((Object)this.mProguardFiles).hashCode();
        result = 31 * result + ((Object)this.mConsumerProguardFiles).hashCode();
        return result;
    }
}

