/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractDoubleCollection;
import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.DoubleContainer;
import com.carrotsearch.hppc.DoubleIntAssociativeContainer;
import com.carrotsearch.hppc.DoubleIntMap;
import com.carrotsearch.hppc.DoubleLookupContainer;
import com.carrotsearch.hppc.HashContainerUtils;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.cursors.DoubleCursor;
import com.carrotsearch.hppc.cursors.DoubleIntCursor;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.predicates.DoublePredicate;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.procedures.DoubleIntProcedure;
import com.carrotsearch.hppc.procedures.DoubleProcedure;
import com.carrotsearch.hppc.procedures.IntProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class DoubleIntOpenHashMap
implements DoubleIntMap,
Cloneable {
    public static final int MIN_CAPACITY = 4;
    public static final int DEFAULT_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public double[] keys;
    public int[] values;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    protected int resizeAt;
    protected int lastSlot;
    protected int perturbation;

    public DoubleIntOpenHashMap() {
        this(16);
    }

    public DoubleIntOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public DoubleIntOpenHashMap(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainerUtils.roundCapacity(initialCapacity));
    }

    public DoubleIntOpenHashMap(DoubleIntAssociativeContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public int put(double key, int value) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(this.keys[slot])) {
                int oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = value;
        }
        return 0;
    }

    @Override
    public int putAll(DoubleIntAssociativeContainer container) {
        int count = this.assigned;
        for (DoubleIntCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.assigned - count;
    }

    @Override
    public int putAll(Iterable<? extends DoubleIntCursor> iterable) {
        int count = this.assigned;
        for (DoubleIntCursor doubleIntCursor : iterable) {
            this.put(doubleIntCursor.key, doubleIntCursor.value);
        }
        return this.assigned - count;
    }

    public boolean putIfAbsent(double key, int value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public int putOrAdd(double key, int putValue, int additionValue) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(this.keys[slot])) {
                this.values[slot] = this.values[slot] + additionValue;
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, putValue, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = putValue;
        }
        return putValue;
    }

    @Override
    public int addTo(double key, int additionValue) {
        return this.putOrAdd(key, additionValue, additionValue);
    }

    private void expandAndPut(double pendingKey, int pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (!this.allocated[freeSlot]);
        double[] oldKeys = this.keys;
        int[] oldValues = this.values;
        boolean[] oldAllocated = this.allocated;
        this.allocateBuffers(HashContainerUtils.nextCapacity(this.keys.length));
        this.lastSlot = -1;
        ++this.assigned;
        oldAllocated[freeSlot] = true;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        double[] keys = this.keys;
        int[] values = this.values;
        boolean[] allocated = this.allocated;
        int mask = allocated.length - 1;
        int i = oldAllocated.length;
        while (--i >= 0) {
            if (!oldAllocated[i]) continue;
            double k = oldKeys[i];
            int v = oldValues[i];
            int slot = Internals.rehash(k, this.perturbation) & mask;
            while (allocated[slot]) {
                slot = slot + 1 & mask;
            }
            allocated[slot] = true;
            keys[slot] = k;
            values[slot] = v;
        }
    }

    private void allocateBuffers(int capacity) {
        double[] keys = new double[capacity];
        int[] values = new int[capacity];
        boolean[] allocated = new boolean[capacity];
        this.keys = keys;
        this.values = values;
        this.allocated = allocated;
        this.resizeAt = Math.max(2, (int)Math.ceil((float)capacity * this.loadFactor)) - 1;
        this.perturbation = this.computePerturbationValue(capacity);
    }

    protected int computePerturbationValue(int capacity) {
        return HashContainerUtils.PERTURBATIONS[Integer.numberOfLeadingZeros(capacity)];
    }

    @Override
    public int remove(double key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(this.keys[slot])) {
                --this.assigned;
                int v = this.values[slot];
                this.shiftConflictingKeys(slot);
                return v;
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return 0;
    }

    protected void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr], this.perturbation) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
            this.values[slotPrev] = this.values[slotCurr];
        }
        this.allocated[slotPrev] = false;
    }

    @Override
    public int removeAll(DoubleContainer container) {
        int before = this.assigned;
        for (DoubleCursor cursor : container) {
            this.remove(cursor.value);
        }
        return before - this.assigned;
    }

    @Override
    public int removeAll(DoublePredicate predicate) {
        int before = this.assigned;
        double[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = 0;
        while (i < states.length) {
            if (states[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    @Override
    public int get(double key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(this.keys[slot])) {
                return this.values[slot];
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return 0;
    }

    @Override
    public int getOrDefault(double key, int defaultValue) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(this.keys[slot])) {
                return this.values[slot];
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return defaultValue;
    }

    public int lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this.values[this.lastSlot];
    }

    public int lset(int key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        int previous = this.values[this.lastSlot];
        this.values[this.lastSlot] = key;
        return previous;
    }

    public int lslot() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        return this.lastSlot;
    }

    @Override
    public boolean containsKey(double key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(this.keys[slot])) {
                this.lastSlot = slot;
                return true;
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
        }
        this.lastSlot = -1;
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (DoubleIntCursor c : this) {
            h += Internals.rehash(c.key) + Internals.rehash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            DoubleIntMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof DoubleIntMap && (other = (DoubleIntMap)obj).size() == this.size()) {
                for (DoubleIntCursor c : this) {
                    int v;
                    if (other.containsKey(c.key) && c.value == (v = other.get(c.key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<DoubleIntCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends DoubleIntProcedure> T forEach(T procedure) {
        double[] keys = this.keys;
        int[] values = this.values;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i], values[i]);
        }
        return procedure;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public IntContainer values() {
        return new ValuesContainer();
    }

    public DoubleIntOpenHashMap clone() {
        try {
            DoubleIntOpenHashMap cloned = (DoubleIntOpenHashMap)super.clone();
            cloned.keys = (double[])this.keys.clone();
            cloned.values = (int[])this.values.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (DoubleIntCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static DoubleIntOpenHashMap from(double[] keys, int[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        DoubleIntOpenHashMap map = new DoubleIntOpenHashMap();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static DoubleIntOpenHashMap from(DoubleIntAssociativeContainer container) {
        return new DoubleIntOpenHashMap(container);
    }

    public static DoubleIntOpenHashMap newInstance() {
        return new DoubleIntOpenHashMap();
    }

    public static DoubleIntOpenHashMap newInstanceWithoutPerturbations() {
        return new DoubleIntOpenHashMap(){

            @Override
            protected int computePerturbationValue(int capacity) {
                return 0;
            }
        };
    }

    public static DoubleIntOpenHashMap newInstance(int initialCapacity, float loadFactor) {
        return new DoubleIntOpenHashMap(initialCapacity, loadFactor);
    }

    public static DoubleIntOpenHashMap newInstanceWithExpectedSize(int expectedSize) {
        return DoubleIntOpenHashMap.newInstanceWithExpectedSize(expectedSize, 0.75f);
    }

    public static DoubleIntOpenHashMap newInstanceWithExpectedSize(int expectedSize, float loadFactor) {
        return DoubleIntOpenHashMap.newInstance((int)((float)expectedSize / loadFactor) + 1, loadFactor);
    }

    private final class ValuesIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();

        public ValuesIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected IntCursor fetch() {
            int i;
            int max = DoubleIntOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !DoubleIntOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (IntCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = DoubleIntOpenHashMap.this.values[i];
            return this.cursor;
        }
    }

    private final class ValuesContainer
    extends AbstractIntCollection {
        private ValuesContainer() {
        }

        @Override
        public int size() {
            return DoubleIntOpenHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return DoubleIntOpenHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(int value) {
            boolean[] allocated = DoubleIntOpenHashMap.this.allocated;
            int[] values = DoubleIntOpenHashMap.this.values;
            for (int slot = 0; slot < allocated.length; ++slot) {
                if (!allocated[slot] || value != values[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            boolean[] allocated = DoubleIntOpenHashMap.this.allocated;
            int[] values = DoubleIntOpenHashMap.this.values;
            for (int i = 0; i < allocated.length; ++i) {
                if (!allocated[i]) continue;
                procedure.apply(values[i]);
            }
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            boolean[] allocated = DoubleIntOpenHashMap.this.allocated;
            int[] values = DoubleIntOpenHashMap.this.values;
            for (int i = 0; i < allocated.length && (!allocated[i] || predicate.apply(values[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAllOccurrences(int e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor = new DoubleCursor();

        public KeysIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected DoubleCursor fetch() {
            int i;
            int max = DoubleIntOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !DoubleIntOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (DoubleCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = DoubleIntOpenHashMap.this.keys[i];
            return this.cursor;
        }
    }

    public final class KeysContainer
    extends AbstractDoubleCollection
    implements DoubleLookupContainer {
        private final DoubleIntOpenHashMap owner;

        public KeysContainer() {
            this.owner = DoubleIntOpenHashMap.this;
        }

        @Override
        public boolean contains(double e) {
            return DoubleIntOpenHashMap.this.containsKey(e);
        }

        @Override
        public <T extends DoubleProcedure> T forEach(T procedure) {
            double[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length; ++i) {
                if (!localStates[i]) continue;
                procedure.apply(localKeys[i]);
            }
            return procedure;
        }

        @Override
        public <T extends DoublePredicate> T forEach(T predicate) {
            double[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length && (!localStates[i] || predicate.apply(localKeys[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<DoubleCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(DoublePredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(double e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<DoubleIntCursor> {
        private final DoubleIntCursor cursor = new DoubleIntCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected DoubleIntCursor fetch() {
            int i;
            int max = DoubleIntOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !DoubleIntOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (DoubleIntCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = DoubleIntOpenHashMap.this.keys[i];
            this.cursor.value = DoubleIntOpenHashMap.this.values[i];
            return this.cursor;
        }
    }
}

