/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.policies.DefaultRetryPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import java.util.concurrent.ThreadLocalRandom;

public class BackoffRetryPolicy
implements RetryPolicy {
    public static final BackoffRetryPolicy INSTANCE = new BackoffRetryPolicy();

    private BackoffRetryPolicy() {
    }

    public RetryPolicy.RetryDecision onUnavailable(Statement statement, ConsistencyLevel consistencyLevel, int requiredReplica, int aliveReplica, int retries) {
        if (retries >= 10) {
            return RetryPolicy.RetryDecision.rethrow();
        }
        try {
            int jitter = ThreadLocalRandom.current().nextInt(100);
            int delay = 100 * (retries + 1) + jitter;
            Thread.sleep(delay);
            return RetryPolicy.RetryDecision.retry((ConsistencyLevel)consistencyLevel);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return RetryPolicy.RetryDecision.rethrow();
        }
    }

    public RetryPolicy.RetryDecision onReadTimeout(Statement statement, ConsistencyLevel cl, int requiredResponses, int receivedResponses, boolean dataRetrieved, int nbRetry) {
        return DefaultRetryPolicy.INSTANCE.onReadTimeout(statement, cl, requiredResponses, receivedResponses, dataRetrieved, nbRetry);
    }

    public RetryPolicy.RetryDecision onWriteTimeout(Statement statement, ConsistencyLevel cl, WriteType writeType, int requiredAcks, int receivedAcks, int nbRetry) {
        return DefaultRetryPolicy.INSTANCE.onWriteTimeout(statement, cl, writeType, requiredAcks, receivedAcks, nbRetry);
    }
}

