/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CassandraColumnHandle;
import com.facebook.presto.cassandra.CassandraConnectorId;
import com.facebook.presto.cassandra.CassandraOutputTableHandle;
import com.facebook.presto.cassandra.CassandraSplit;
import com.facebook.presto.cassandra.CassandraTableHandle;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorIndexHandle;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import javax.inject.Inject;

public class CassandraHandleResolver
implements ConnectorHandleResolver {
    private final String connectorId;

    @Inject
    public CassandraHandleResolver(CassandraConnectorId connectorId) {
        this.connectorId = ((CassandraConnectorId)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null")).toString();
    }

    public boolean canHandle(ConnectorTableHandle tableHandle) {
        return tableHandle instanceof CassandraTableHandle && ((CassandraTableHandle)tableHandle).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorColumnHandle columnHandle) {
        return columnHandle instanceof CassandraColumnHandle && ((CassandraColumnHandle)columnHandle).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorSplit split) {
        return split instanceof CassandraSplit && ((CassandraSplit)split).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorIndexHandle indexHandle) {
        return false;
    }

    public boolean canHandle(ConnectorOutputTableHandle tableHandle) {
        return tableHandle instanceof CassandraOutputTableHandle && ((CassandraOutputTableHandle)tableHandle).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorInsertTableHandle tableHandle) {
        return false;
    }

    public Class<? extends ConnectorTableHandle> getTableHandleClass() {
        return CassandraTableHandle.class;
    }

    public Class<? extends ConnectorColumnHandle> getColumnHandleClass() {
        return CassandraColumnHandle.class;
    }

    public Class<? extends ConnectorSplit> getSplitClass() {
        return CassandraSplit.class;
    }

    public Class<? extends ConnectorIndexHandle> getIndexHandleClass() {
        throw new UnsupportedOperationException();
    }

    public Class<? extends ConnectorOutputTableHandle> getOutputTableHandleClass() {
        return CassandraOutputTableHandle.class;
    }

    public Class<? extends ConnectorInsertTableHandle> getInsertTableHandleClass() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).toString();
    }
}

