/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CassandraOutputTableHandle;
import com.facebook.presto.cassandra.CassandraSession;
import com.facebook.presto.spi.RecordSink;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class CassandraRecordSink
implements RecordSink {
    private static final DateTimeFormatter DATE_FORMATTER = ISODateTimeFormat.date().withZoneUTC();
    private final int fieldCount;
    private final CassandraSession cassandraSession;
    private final boolean sampled;
    private final String insertQuery;
    private final List<Object> values;
    private final String schemaName;
    private final List<Type> columnTypes;
    private int field = -1;

    @Inject
    public CassandraRecordSink(CassandraOutputTableHandle handle, CassandraSession cassandraSession) {
        this.fieldCount = ((CassandraOutputTableHandle)Preconditions.checkNotNull((Object)handle, (Object)"handle is null")).getColumnNames().size();
        this.cassandraSession = (CassandraSession)Preconditions.checkNotNull((Object)cassandraSession, (Object)"cassandraSession is null");
        this.sampled = handle.isSampled();
        this.schemaName = handle.getSchemaName();
        StringBuilder queryBuilder = new StringBuilder(String.format("INSERT INTO \"%s\".\"%s\"(", this.schemaName, handle.getTableName()));
        queryBuilder.append("id");
        if (this.sampled) {
            queryBuilder.append(",presto_sample_weight");
        }
        for (String columnName : handle.getColumnNames()) {
            queryBuilder.append(",").append(columnName);
        }
        queryBuilder.append(") VALUES (?");
        if (this.sampled) {
            queryBuilder.append(",?");
        }
        for (int i = 0; i < handle.getColumnNames().size(); ++i) {
            queryBuilder.append(",?");
        }
        queryBuilder.append(")");
        this.insertQuery = queryBuilder.toString();
        this.values = Lists.newArrayList();
        this.columnTypes = handle.getColumnTypes();
    }

    public void beginRecord(long sampleWeight) {
        Preconditions.checkState((this.field == -1 ? 1 : 0) != 0, (Object)"already in record");
        this.field = 0;
        this.values.clear();
        this.values.add(UUID.randomUUID());
        if (this.sampled) {
            this.values.add(sampleWeight);
        } else {
            Preconditions.checkArgument((sampleWeight == 1L ? 1 : 0) != 0, (Object)"Sample weight must be 1 when sampling is disabled");
        }
    }

    public void finishRecord() {
        Preconditions.checkState((this.field != -1 ? 1 : 0) != 0, (Object)"not in record");
        Preconditions.checkState((this.field == this.fieldCount ? 1 : 0) != 0, (Object)"not all fields set");
        this.field = -1;
        this.cassandraSession.execute(this.schemaName, this.insertQuery, this.values.toArray());
    }

    public void appendNull() {
        this.append(null);
    }

    public void appendBoolean(boolean value) {
        this.append(value);
    }

    public void appendLong(long value) {
        if (DateType.DATE.equals((Object)this.columnTypes.get(this.field))) {
            this.append(DATE_FORMATTER.print(TimeUnit.DAYS.toMillis(value)));
        } else {
            this.append(value);
        }
    }

    public void appendDouble(double value) {
        this.append(value);
    }

    public void appendString(byte[] value) {
        this.append(new String(value, StandardCharsets.UTF_8));
    }

    public Collection<Slice> commit() {
        Preconditions.checkState((this.field == -1 ? 1 : 0) != 0, (Object)"record not finished");
        return ImmutableList.of();
    }

    public void rollback() {
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    private void append(Object value) {
        Preconditions.checkState((this.field != -1 ? 1 : 0) != 0, (Object)"not in record");
        Preconditions.checkState((this.field < this.fieldCount ? 1 : 0) != 0, (Object)"all fields already set");
        this.values.add(value);
        ++this.field;
    }
}

