/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CassandraTableHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;

public class CassandraSplit
implements ConnectorSplit {
    private final String connectorId;
    private final String partitionId;
    private final List<HostAddress> addresses;
    private final String schema;
    private final String table;
    private final String splitCondition;

    @JsonCreator
    public CassandraSplit(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="schema") String schema, @JsonProperty(value="table") String table, @JsonProperty(value="partitionId") String partitionId, @JsonProperty(value="splitCondition") String splitCondition, @JsonProperty(value="addresses") List<HostAddress> addresses) {
        Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        Preconditions.checkNotNull((Object)schema, (Object)"schema is null");
        Preconditions.checkNotNull((Object)table, (Object)"table is null");
        Preconditions.checkNotNull((Object)partitionId, (Object)"partitionName is null");
        Preconditions.checkNotNull(addresses, (Object)"addresses is null");
        this.connectorId = connectorId;
        this.schema = schema;
        this.table = table;
        this.partitionId = partitionId;
        this.addresses = ImmutableList.copyOf(addresses);
        this.splitCondition = splitCondition;
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public String getSplitCondition() {
        return this.splitCondition;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonProperty
    public String getPartitionId() {
        return this.partitionId;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public Object getInfo() {
        return ImmutableMap.builder().put((Object)"hosts", this.addresses).put((Object)"schema", (Object)this.schema).put((Object)"table", (Object)this.table).put((Object)"partitionId", (Object)this.partitionId).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.table).addValue((Object)this.partitionId).toString();
    }

    public String getWhereClause() {
        if (this.partitionId.equals("<UNPARTITIONED>")) {
            if (this.splitCondition != null) {
                return " WHERE " + this.splitCondition;
            }
            return "";
        }
        if (this.splitCondition != null) {
            return " WHERE " + this.partitionId + " AND " + this.splitCondition;
        }
        return " WHERE " + this.partitionId;
    }

    public CassandraTableHandle getCassandraTableHandle() {
        return new CassandraTableHandle(this.connectorId, this.schema, this.table);
    }
}

