/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.datastax.driver.core.Host;
import com.facebook.presto.cassandra.CachingCassandraSchemaProvider;
import com.facebook.presto.cassandra.CassandraClientConfig;
import com.facebook.presto.cassandra.CassandraColumnHandle;
import com.facebook.presto.cassandra.CassandraConnectorId;
import com.facebook.presto.cassandra.CassandraPartition;
import com.facebook.presto.cassandra.CassandraSession;
import com.facebook.presto.cassandra.CassandraSplit;
import com.facebook.presto.cassandra.CassandraTable;
import com.facebook.presto.cassandra.CassandraTableHandle;
import com.facebook.presto.cassandra.CassandraTokenSplitManager;
import com.facebook.presto.cassandra.CassandraType;
import com.facebook.presto.cassandra.ForCassandra;
import com.facebook.presto.cassandra.util.CassandraCqlUtils;
import com.facebook.presto.cassandra.util.HostAddressFactory;
import com.facebook.presto.cassandra.util.Types;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorPartition;
import com.facebook.presto.spi.ConnectorPartitionResult;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.Domain;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.Range;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.log.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;

public class CassandraSplitManager
implements ConnectorSplitManager {
    private static final Logger log = Logger.get(CassandraSplitManager.class);
    private final String connectorId;
    private final CassandraSession cassandraSession;
    private final CachingCassandraSchemaProvider schemaProvider;
    private final int partitionSizeForBatchSelect;
    private final CassandraTokenSplitManager tokenSplitMgr;
    private final ListeningExecutorService executor;

    @Inject
    public CassandraSplitManager(CassandraConnectorId connectorId, CassandraClientConfig cassandraClientConfig, CassandraSession cassandraSession, CachingCassandraSchemaProvider schemaProvider, CassandraTokenSplitManager tokenSplitMgr, @ForCassandra ExecutorService executor) {
        this.connectorId = ((CassandraConnectorId)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null")).toString();
        this.schemaProvider = (CachingCassandraSchemaProvider)Preconditions.checkNotNull((Object)schemaProvider, (Object)"schemaProvider is null");
        this.cassandraSession = (CassandraSession)Preconditions.checkNotNull((Object)cassandraSession, (Object)"cassandraSession is null");
        this.partitionSizeForBatchSelect = cassandraClientConfig.getPartitionSizeForBatchSelect();
        this.tokenSplitMgr = tokenSplitMgr;
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)executor);
    }

    public ConnectorPartitionResult getPartitions(ConnectorTableHandle tableHandle, TupleDomain<ConnectorColumnHandle> tupleDomain) {
        CassandraTableHandle cassandraTableHandle = Types.checkType(tableHandle, CassandraTableHandle.class, "tableHandle");
        Preconditions.checkNotNull(tupleDomain, (Object)"tupleDomain is null");
        CassandraTable table = this.schemaProvider.getTable(cassandraTableHandle);
        List<CassandraColumnHandle> partitionKeys = table.getPartitionKeyColumns();
        List<CassandraPartition> allPartitions = this.getCassandraPartitions(table, tupleDomain);
        log.debug("%s.%s #partitions: %d", new Object[]{cassandraTableHandle.getSchemaName(), cassandraTableHandle.getTableName(), allPartitions.size()});
        Object partitions = FluentIterable.from(allPartitions).filter(CassandraSplitManager.partitionMatches(tupleDomain)).filter(ConnectorPartition.class).toList();
        TupleDomain remainingTupleDomain = TupleDomain.none();
        if (!tupleDomain.isNone()) {
            if (partitions.size() == 1 && ((CassandraPartition)partitions.get(0)).isUnpartitioned()) {
                remainingTupleDomain = tupleDomain;
            } else {
                List<CassandraColumnHandle> partitionColumns = partitionKeys;
                remainingTupleDomain = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)tupleDomain.getDomains(), (Predicate)Predicates.not((Predicate)Predicates.in(partitionColumns))));
            }
        }
        if (partitions.size() == 1 && ((CassandraPartition)partitions.get(0)).isUnpartitioned()) {
            Map domains = tupleDomain.getDomains();
            ArrayList indexedColumns = Lists.newArrayList();
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : domains.entrySet()) {
                CassandraColumnHandle column = (CassandraColumnHandle)entry.getKey();
                Domain domain = (Domain)entry.getValue();
                if (!column.isIndexed() || !domain.isSingleValue()) continue;
                sb.append(CassandraCqlUtils.validColumnName(column.getName())).append(" = ").append(CassandraCqlUtils.cqlValue(CassandraCqlUtils.toCQLCompatibleString(((Domain)entry.getValue()).getSingleValue()), column.getCassandraType()));
                indexedColumns.add(column);
                break;
            }
            if (sb.length() > 0) {
                CassandraPartition partition = (CassandraPartition)partitions.get(0);
                TupleDomain filterIndexedColumn = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)remainingTupleDomain.getDomains(), (Predicate)Predicates.not((Predicate)Predicates.in((Collection)indexedColumns))));
                partitions = Lists.newArrayList();
                partitions.add(new CassandraPartition(partition.getKey(), sb.toString(), (TupleDomain<ConnectorColumnHandle>)filterIndexedColumn, true));
                return new ConnectorPartitionResult((List)partitions, filterIndexedColumn);
            }
        }
        return new ConnectorPartitionResult((List)partitions, remainingTupleDomain);
    }

    private List<CassandraPartition> getCassandraPartitions(final CassandraTable table, TupleDomain<ConnectorColumnHandle> tupleDomain) {
        if (tupleDomain.isNone()) {
            return ImmutableList.of();
        }
        Set<List<Comparable<?>>> partitionKeysSet = CassandraSplitManager.getPartitionKeysSet(table, tupleDomain);
        if (partitionKeysSet.isEmpty()) {
            return this.schemaProvider.getAllPartitions(table);
        }
        ImmutableList.Builder getPartitionResults = ImmutableList.builder();
        for (final List<Comparable<?>> partitionKeys : partitionKeysSet) {
            getPartitionResults.add((Object)this.executor.submit((Callable)new Callable<List<CassandraPartition>>(){

                @Override
                public List<CassandraPartition> call() {
                    return CassandraSplitManager.this.schemaProvider.getPartitions(table, partitionKeys);
                }
            }));
        }
        ImmutableList.Builder partitions = ImmutableList.builder();
        for (ListenableFuture result : getPartitionResults.build()) {
            try {
                partitions.addAll((Iterable)result.get());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Throwables.propagate((Throwable)e);
            }
            catch (ExecutionException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.EXTERNAL, "Error fetching cassandra partitions", (Throwable)e);
            }
        }
        return partitions.build();
    }

    private static Set<List<Comparable<?>>> getPartitionKeysSet(CassandraTable table, TupleDomain<ConnectorColumnHandle> tupleDomain) {
        ImmutableList.Builder partitionColumnValues = ImmutableList.builder();
        for (CassandraColumnHandle columnHandle : table.getPartitionKeyColumns()) {
            Domain domain = (Domain)tupleDomain.getDomains().get(columnHandle);
            if (domain == null) {
                return ImmutableSet.of();
            }
            if (domain.isNullAllowed()) {
                return ImmutableSet.of();
            }
            ImmutableSet.Builder columnValues = ImmutableSet.builder();
            for (Range range : domain.getRanges()) {
                if (!range.isSingleValue()) {
                    return ImmutableSet.of();
                }
                Comparable value = range.getSingleValue();
                CassandraType valueType = columnHandle.getCassandraType();
                columnValues.add(valueType.getValueForPartitionKey(value));
            }
            partitionColumnValues.add((Object)columnValues.build());
        }
        return Sets.cartesianProduct((List)partitionColumnValues.build());
    }

    public ConnectorSplitSource getPartitionSplits(ConnectorTableHandle tableHandle, List<ConnectorPartition> partitions) {
        ConnectorPartition partition;
        CassandraPartition cassandraPartition;
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        CassandraTableHandle cassandraTableHandle = Types.checkType(tableHandle, CassandraTableHandle.class, "tableHandle");
        Preconditions.checkNotNull(partitions, (Object)"partitions is null");
        if (partitions.isEmpty()) {
            return new FixedSplitSource(this.connectorId, (Iterable)ImmutableList.of());
        }
        if (partitions.size() == 1 && ((cassandraPartition = Types.checkType(partition = partitions.get(0), CassandraPartition.class, "partition")).isUnpartitioned() || cassandraPartition.isIndexedColumnPredicatePushdown())) {
            CassandraTable table = this.schemaProvider.getTable(cassandraTableHandle);
            List<ConnectorSplit> splits = this.getSplitsByTokenRange(table, cassandraPartition.getPartitionId());
            return new FixedSplitSource(this.connectorId, splits);
        }
        return new FixedSplitSource(this.connectorId, this.getSplitsForPartitions(cassandraTableHandle, partitions));
    }

    private List<ConnectorSplit> getSplitsByTokenRange(CassandraTable table, String partitionId) {
        List<CassandraTokenSplitManager.TokenSplit> tokenSplits;
        String schema = table.getTableHandle().getSchemaName();
        String tableName = table.getTableHandle().getTableName();
        String tokenExpression = table.getTokenExpression();
        ImmutableList.Builder builder = ImmutableList.builder();
        try {
            tokenSplits = this.tokenSplitMgr.getSplits(schema, tableName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (CassandraTokenSplitManager.TokenSplit tokenSplit : tokenSplits) {
            String condition = CassandraSplitManager.buildTokenCondition(tokenExpression, tokenSplit.getStartToken(), tokenSplit.getEndToken());
            List<HostAddress> addresses = new HostAddressFactory().AddressNamesToHostAddressList(tokenSplit.getHosts());
            CassandraSplit split = new CassandraSplit(this.connectorId, schema, tableName, partitionId, condition, addresses);
            builder.add((Object)split);
        }
        return builder.build();
    }

    private static String buildTokenCondition(String tokenExpression, String startToken, String endToken) {
        return tokenExpression + " > " + startToken + " AND " + tokenExpression + " <= " + endToken;
    }

    private List<ConnectorSplit> getSplitsForPartitions(CassandraTableHandle cassTableHandle, List<ConnectorPartition> partitions) {
        CassandraSplit split;
        String schema = cassTableHandle.getSchemaName();
        String table = cassTableHandle.getTableName();
        HostAddressFactory hostAddressFactory = new HostAddressFactory();
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean singlePartitionKeyColumn = true;
        String partitionKeyColumnName = null;
        if (!partitions.isEmpty()) {
            boolean bl = singlePartitionKeyColumn = partitions.get(0).getTupleDomain().getNullableColumnDomains().size() == 1;
            if (singlePartitionKeyColumn) {
                String partitionId = partitions.get(0).getPartitionId();
                partitionKeyColumnName = partitionId.substring(0, partitionId.lastIndexOf("=") - 1);
            }
        }
        HashMap hostsToPartitionKeys = Maps.newHashMap();
        HashMap hostMap = Maps.newHashMap();
        for (ConnectorPartition connectorPartition : partitions) {
            CassandraPartition cassandraPartition = Types.checkType(connectorPartition, CassandraPartition.class, "partition");
            Set<Host> hosts = this.cassandraSession.getReplicas(schema, cassandraPartition.getKeyAsByteBuffer());
            List<HostAddress> addresses = hostAddressFactory.toHostAddressList(hosts);
            if (singlePartitionKeyColumn) {
                ImmutableSet.Builder sb = ImmutableSet.builder();
                Iterator<HostAddress> iterator = addresses.iterator();
                while (iterator.hasNext()) {
                    HostAddress address = iterator.next();
                    sb.add((Object)address.getHostText());
                }
                ImmutableSet hostAddresses = sb.build();
                Set values = (Set)hostsToPartitionKeys.get(hostAddresses);
                if (values == null) {
                    values = Sets.newHashSet();
                }
                String partitionId = cassandraPartition.getPartitionId();
                values.add(partitionId.substring(partitionId.lastIndexOf("=") + 2));
                hostsToPartitionKeys.put(hostAddresses, values);
                hostMap.put(hostAddresses, addresses);
                continue;
            }
            split = new CassandraSplit(this.connectorId, schema, table, cassandraPartition.getPartitionId(), null, addresses);
            builder.add((Object)split);
        }
        if (singlePartitionKeyColumn) {
            for (Map.Entry entry : hostsToPartitionKeys.entrySet()) {
                StringBuilder sb = new StringBuilder(this.partitionSizeForBatchSelect);
                int size = 0;
                for (String value : (Set)entry.getValue()) {
                    if (size > 0) {
                        sb.append(",");
                    }
                    sb.append(value);
                    if (++size <= this.partitionSizeForBatchSelect) continue;
                    String partitionId = String.format("%s in (%s)", partitionKeyColumnName, sb.toString());
                    CassandraSplit split2 = new CassandraSplit(this.connectorId, schema, table, partitionId, null, (List)hostMap.get(entry.getKey()));
                    builder.add((Object)split2);
                    size = 0;
                    sb.setLength(0);
                    sb.trimToSize();
                }
                if (size <= 0) continue;
                String partitionId = String.format("%s in (%s)", partitionKeyColumnName, sb.toString());
                split = new CassandraSplit(this.connectorId, schema, table, partitionId, null, (List)hostMap.get(entry.getKey()));
                builder.add((Object)split);
            }
        }
        return builder.build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientId", (Object)this.connectorId).toString();
    }

    public static Predicate<CassandraPartition> partitionMatches(final TupleDomain<ConnectorColumnHandle> tupleDomain) {
        return new Predicate<CassandraPartition>(){

            public boolean apply(CassandraPartition partition) {
                return tupleDomain.overlaps(partition.getTupleDomain());
            }
        };
    }
}

