/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CassandraClientConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.ITransportFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;

public class CassandraThriftConnectionFactory {
    private static final Logger log = Logger.get(CassandraThriftConnectionFactory.class);
    private final int port;
    private final List<String> addresses;
    private final String factoryClassName;
    private final Map<String, String> transportFactoryOptions;

    @Inject
    public CassandraThriftConnectionFactory(CassandraClientConfig config) {
        this.addresses = config.getContactPoints();
        this.port = config.getThriftPort();
        this.factoryClassName = config.getThriftConnectionFactoryClassName();
        this.transportFactoryOptions = ImmutableMap.copyOf(config.getTransportFactoryOptions());
    }

    public Cassandra.Client create() {
        try {
            return this.getClientFromAddressList();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Cassandra.Client getClientFromAddressList() throws IOException {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (String address : this.addresses) {
            try {
                return this.createConnection(address, this.port, this.factoryClassName);
            }
            catch (IOException ioe) {
                exceptions.add(ioe);
            }
        }
        log.error("failed to connect to any initial addresses");
        for (IOException exception : exceptions) {
            log.error((Throwable)exception);
        }
        throw (IOException)exceptions.get(exceptions.size() - 1);
    }

    public Cassandra.Client createConnection(String host, Integer port, String factoryClassName) throws IOException {
        try {
            TTransport transport = this.getClientTransportFactory(factoryClassName).openTransport(host, port.intValue());
            return new Cassandra.Client((TProtocol)new TBinaryProtocol(transport, true, true));
        }
        catch (Exception e) {
            throw new IOException("Unable to connect to server " + host + ":" + port, e);
        }
    }

    private ITransportFactory getClientTransportFactory(String factoryClassName) {
        try {
            ITransportFactory factory = (ITransportFactory)Class.forName(factoryClassName).newInstance();
            Map<String, String> options = this.getOptions(factory.supportedOptions());
            factory.setOptions(options);
            return factory;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate transport factory:" + factoryClassName, e);
        }
    }

    private Map<String, String> getOptions(Set<String> supportedOptions) {
        HashMap<String, String> options = new HashMap<String, String>();
        for (String optionKey : supportedOptions) {
            String optionValue = this.transportFactoryOptions.get(optionKey);
            if (optionValue == null) continue;
            options.put(optionKey, optionValue);
        }
        return options;
    }
}

