/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.UTMetaData;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.db.CFRowAdder;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.LocalStrategy;
import org.apache.cassandra.locator.NetworkTopologyStrategy;
import org.apache.cassandra.locator.SimpleStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.utils.FBUtilities;

public final class KSMetaData {
    public final String name;
    public final Class<? extends AbstractReplicationStrategy> strategyClass;
    public final Map<String, String> strategyOptions;
    private final Map<String, CFMetaData> cfMetaData;
    public final boolean durableWrites;
    public final UTMetaData userTypes;

    KSMetaData(String name, Class<? extends AbstractReplicationStrategy> strategyClass, Map<String, String> strategyOptions, boolean durableWrites, Iterable<CFMetaData> cfDefs) {
        this(name, strategyClass, strategyOptions, durableWrites, cfDefs, new UTMetaData());
    }

    KSMetaData(String name, Class<? extends AbstractReplicationStrategy> strategyClass, Map<String, String> strategyOptions, boolean durableWrites, Iterable<CFMetaData> cfDefs, UTMetaData userTypes) {
        this.name = name;
        this.strategyClass = strategyClass == null ? NetworkTopologyStrategy.class : strategyClass;
        this.strategyOptions = strategyOptions;
        HashMap<String, CFMetaData> cfmap = new HashMap<String, CFMetaData>();
        for (CFMetaData cfm : cfDefs) {
            cfmap.put(cfm.cfName, cfm);
        }
        this.cfMetaData = Collections.unmodifiableMap(cfmap);
        this.durableWrites = durableWrites;
        this.userTypes = userTypes;
    }

    public static KSMetaData newKeyspace(String name, String strategyName, Map<String, String> options, boolean durableWrites) throws ConfigurationException {
        Class<AbstractReplicationStrategy> cls = AbstractReplicationStrategy.getClass(strategyName);
        if (cls.equals(LocalStrategy.class)) {
            throw new ConfigurationException("Unable to use given strategy class: LocalStrategy is reserved for internal use.");
        }
        return KSMetaData.newKeyspace(name, cls, options, durableWrites, Collections.emptyList());
    }

    public static KSMetaData newKeyspace(String name, Class<? extends AbstractReplicationStrategy> strategyClass, Map<String, String> options, boolean durablesWrites, Iterable<CFMetaData> cfDefs) {
        return new KSMetaData(name, strategyClass, options, durablesWrites, cfDefs, new UTMetaData());
    }

    public static KSMetaData cloneWith(KSMetaData ksm, Iterable<CFMetaData> cfDefs) {
        return new KSMetaData(ksm.name, ksm.strategyClass, ksm.strategyOptions, ksm.durableWrites, cfDefs, ksm.userTypes);
    }

    public static KSMetaData systemKeyspace() {
        List<CFMetaData> cfDefs = Arrays.asList(CFMetaData.BatchlogCf, CFMetaData.RangeXfersCf, CFMetaData.LocalCf, CFMetaData.PeersCf, CFMetaData.PeerEventsCf, CFMetaData.HintsCf, CFMetaData.IndexCf, CFMetaData.SchemaKeyspacesCf, CFMetaData.SchemaColumnFamiliesCf, CFMetaData.SchemaColumnsCf, CFMetaData.SchemaTriggersCf, CFMetaData.SchemaUserTypesCf, CFMetaData.CompactionLogCf, CFMetaData.CompactionHistoryCf, CFMetaData.PaxosCf, CFMetaData.SSTableActivityCF);
        return new KSMetaData("system", LocalStrategy.class, Collections.emptyMap(), true, cfDefs);
    }

    public static KSMetaData traceKeyspace() {
        List<CFMetaData> cfDefs = Arrays.asList(CFMetaData.TraceSessionsCf, CFMetaData.TraceEventsCf);
        return new KSMetaData("system_traces", SimpleStrategy.class, (Map<String, String>)ImmutableMap.of((Object)"replication_factor", (Object)"2"), true, cfDefs);
    }

    public static KSMetaData testMetadata(String name, Class<? extends AbstractReplicationStrategy> strategyClass, Map<String, String> strategyOptions, CFMetaData ... cfDefs) {
        return new KSMetaData(name, strategyClass, strategyOptions, true, Arrays.asList(cfDefs));
    }

    public static KSMetaData testMetadataNotDurable(String name, Class<? extends AbstractReplicationStrategy> strategyClass, Map<String, String> strategyOptions, CFMetaData ... cfDefs) {
        return new KSMetaData(name, strategyClass, strategyOptions, false, Arrays.asList(cfDefs));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.strategyClass, this.strategyOptions, this.cfMetaData, this.durableWrites, this.userTypes});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KSMetaData)) {
            return false;
        }
        KSMetaData other = (KSMetaData)o;
        return Objects.equal((Object)this.name, (Object)other.name) && Objects.equal(this.strategyClass, other.strategyClass) && Objects.equal(this.strategyOptions, other.strategyOptions) && Objects.equal(this.cfMetaData, other.cfMetaData) && Objects.equal((Object)this.durableWrites, (Object)other.durableWrites) && Objects.equal((Object)this.userTypes, (Object)other.userTypes);
    }

    public Map<String, CFMetaData> cfMetaData() {
        return this.cfMetaData;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("strategyClass", (Object)this.strategyClass.getSimpleName()).add("strategyOptions", this.strategyOptions).add("cfMetaData", this.cfMetaData).add("durableWrites", this.durableWrites).add("userTypes", (Object)this.userTypes).toString();
    }

    public static Map<String, String> optsWithRF(Integer rf) {
        return Collections.singletonMap("replication_factor", rf.toString());
    }

    public static KSMetaData fromThrift(KsDef ksd, CFMetaData ... cfDefs) throws ConfigurationException {
        Class<AbstractReplicationStrategy> cls = AbstractReplicationStrategy.getClass(ksd.strategy_class);
        if (cls.equals(LocalStrategy.class)) {
            throw new ConfigurationException("Unable to use given strategy class: LocalStrategy is reserved for internal use.");
        }
        return new KSMetaData(ksd.name, cls, ksd.strategy_options == null ? Collections.emptyMap() : ksd.strategy_options, ksd.durable_writes, Arrays.asList(cfDefs));
    }

    public KsDef toThrift() {
        ArrayList<CfDef> cfDefs = new ArrayList<CfDef>(this.cfMetaData.size());
        for (CFMetaData cfm : this.cfMetaData().values()) {
            if (!cfm.isThriftCompatible()) continue;
            cfDefs.add(cfm.toThrift());
        }
        KsDef ksdef = new KsDef(this.name, this.strategyClass.getName(), cfDefs);
        ksdef.setStrategy_options(this.strategyOptions);
        ksdef.setDurable_writes(this.durableWrites);
        return ksdef;
    }

    public Mutation toSchemaUpdate(KSMetaData newState, long modificationTimestamp) {
        return newState.toSchema(modificationTimestamp);
    }

    public KSMetaData validate() throws ConfigurationException {
        if (!CFMetaData.isNameValid(this.name)) {
            throw new ConfigurationException(String.format("Keyspace name must not be empty, more than %s characters long, or contain non-alphanumeric-underscore characters (got \"%s\")", 48, this.name));
        }
        TokenMetadata tmd = StorageService.instance.getTokenMetadata();
        IEndpointSnitch eps = DatabaseDescriptor.getEndpointSnitch();
        AbstractReplicationStrategy.validateReplicationStrategy(this.name, this.strategyClass, tmd, eps, this.strategyOptions);
        for (CFMetaData cfm : this.cfMetaData.values()) {
            cfm.validate();
        }
        return this;
    }

    public KSMetaData reloadAttributes() {
        Row ksDefRow = SystemKeyspace.readSchemaRow(this.name);
        if (ksDefRow.cf == null) {
            throw new RuntimeException(String.format("%s not found in the schema definitions keyspaceName (%s).", this.name, "schema_keyspaces"));
        }
        return KSMetaData.fromSchema(ksDefRow, Collections.emptyList(), this.userTypes);
    }

    public Mutation dropFromSchema(long timestamp) {
        Mutation mutation = new Mutation("system", SystemKeyspace.getSchemaKSKey(this.name));
        mutation.delete("schema_keyspaces", timestamp);
        mutation.delete("schema_columnfamilies", timestamp);
        mutation.delete("schema_columns", timestamp);
        mutation.delete("schema_triggers", timestamp);
        mutation.delete("schema_usertypes", timestamp);
        mutation.delete("IndexInfo", timestamp);
        return mutation;
    }

    public Mutation toSchema(long timestamp) {
        Mutation mutation = new Mutation("system", SystemKeyspace.getSchemaKSKey(this.name));
        ColumnFamily cf = mutation.addOrGet(CFMetaData.SchemaKeyspacesCf);
        CFRowAdder adder = new CFRowAdder(cf, CFMetaData.SchemaKeyspacesCf.comparator.builder().build(), timestamp);
        adder.add("durable_writes", this.durableWrites);
        adder.add("strategy_class", this.strategyClass.getName());
        adder.add("strategy_options", FBUtilities.json(this.strategyOptions));
        for (CFMetaData cfm : this.cfMetaData.values()) {
            cfm.toSchema(mutation, timestamp);
        }
        this.userTypes.toSchema(mutation, timestamp);
        return mutation;
    }

    public static KSMetaData fromSchema(Row row, Iterable<CFMetaData> cfms, UTMetaData userTypes) {
        UntypedResultSet.Row result = QueryProcessor.resultify("SELECT * FROM system.schema_keyspaces", row).one();
        try {
            return new KSMetaData(result.getString("keyspace_name"), AbstractReplicationStrategy.getClass(result.getString("strategy_class")), FBUtilities.fromJsonMap(result.getString("strategy_options")), result.getBoolean("durable_writes"), cfms, userTypes);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static KSMetaData fromSchema(Row serializedKs, Row serializedCFs, Row serializedUserTypes) {
        Map<String, CFMetaData> cfs = KSMetaData.deserializeColumnFamilies(serializedCFs);
        UTMetaData userTypes = new UTMetaData(UTMetaData.fromSchema(serializedUserTypes));
        return KSMetaData.fromSchema(serializedKs, cfs.values(), userTypes);
    }

    public static Map<String, CFMetaData> deserializeColumnFamilies(Row row) {
        if (row.cf == null) {
            return Collections.emptyMap();
        }
        HashMap<String, CFMetaData> cfms = new HashMap<String, CFMetaData>();
        UntypedResultSet results = QueryProcessor.resultify("SELECT * FROM system.schema_columnfamilies", row);
        for (UntypedResultSet.Row result : results) {
            CFMetaData cfm = CFMetaData.fromSchema(result);
            cfms.put(cfm.cfName, cfm);
        }
        return cfms;
    }
}

