/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.composites;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.composites.CBuilder;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.CompoundDenseCellNameType;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.composites.CompositesIndex;

public class CompositesIndexOnClusteringKey
extends CompositesIndex {
    public static CellNameType buildIndexComparator(CFMetaData baseMetadata, ColumnDefinition columnDef) {
        int i;
        int ckCount = baseMetadata.clusteringColumns().size();
        ArrayList types = new ArrayList(ckCount);
        types.add(SecondaryIndex.keyComparator);
        for (i = 0; i < columnDef.position(); ++i) {
            types.add(baseMetadata.clusteringColumns().get((int)i).type);
        }
        for (i = columnDef.position() + 1; i < ckCount; ++i) {
            types.add(baseMetadata.clusteringColumns().get((int)i).type);
        }
        return new CompoundDenseCellNameType(types);
    }

    @Override
    protected ByteBuffer getIndexedValue(ByteBuffer rowKey, Cell cell) {
        return cell.name().get(this.columnDef.position());
    }

    @Override
    protected Composite makeIndexColumnPrefix(ByteBuffer rowKey, Composite columnName) {
        int i;
        int count = Math.min(this.baseCfs.metadata.clusteringColumns().size(), columnName.size());
        CBuilder builder = this.getIndexComparator().prefixBuilder();
        builder.add(rowKey);
        for (i = 0; i < Math.min(this.columnDef.position(), count); ++i) {
            builder.add(columnName.get(i));
        }
        for (i = this.columnDef.position() + 1; i < count; ++i) {
            builder.add(columnName.get(i));
        }
        return builder.build();
    }

    @Override
    public CompositesIndex.IndexedEntry decodeEntry(DecoratedKey indexedValue, Cell indexEntry) {
        int i;
        int ckCount = this.baseCfs.metadata.clusteringColumns().size();
        CBuilder builder = this.baseCfs.getComparator().builder();
        for (i = 0; i < this.columnDef.position(); ++i) {
            builder.add(indexEntry.name().get(i + 1));
        }
        builder.add(indexedValue.getKey());
        for (i = this.columnDef.position() + 1; i < ckCount; ++i) {
            builder.add(indexEntry.name().get(i));
        }
        return new CompositesIndex.IndexedEntry(indexedValue, indexEntry.name(), indexEntry.timestamp(), indexEntry.name().get(0), builder.build());
    }

    @Override
    public boolean indexes(CellName name) {
        return true;
    }

    @Override
    public boolean isStale(CompositesIndex.IndexedEntry entry, ColumnFamily data, long now) {
        return data.hasOnlyTombstones(now);
    }
}

