/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.jsr310.ser.JSR310ArraySerializerBase;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;

public class LocalDateTimeSerializer
extends JSR310ArraySerializerBase<LocalDateTime> {
    public static final LocalDateTimeSerializer INSTANCE = new LocalDateTimeSerializer();

    private LocalDateTimeSerializer() {
        super(LocalDateTime.class);
    }

    public void serialize(LocalDateTime dateTime, JsonGenerator generator, SerializerProvider provider) throws IOException {
        if (provider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            generator.writeStartArray();
            generator.writeNumber(dateTime.getYear());
            generator.writeNumber(dateTime.getMonthValue());
            generator.writeNumber(dateTime.getDayOfMonth());
            generator.writeNumber(dateTime.getHour());
            generator.writeNumber(dateTime.getMinute());
            if (dateTime.getSecond() > 0 || dateTime.getNano() > 0) {
                generator.writeNumber(dateTime.getSecond());
                if (dateTime.getNano() > 0) {
                    if (provider.isEnabled(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                        generator.writeNumber(dateTime.getNano());
                    } else {
                        generator.writeNumber(dateTime.get(ChronoField.MILLI_OF_SECOND));
                    }
                }
            }
            generator.writeEndArray();
        } else {
            generator.writeString(dateTime.toString());
        }
    }
}

