/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetAttributesRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String domainName;
    private String itemName;
    private ListWithAutoConstructFlag<String> attributeNames;
    private Boolean consistentRead;

    public GetAttributesRequest() {
    }

    public GetAttributesRequest(String domainName, String itemName) {
        this.setDomainName(domainName);
        this.setItemName(itemName);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public GetAttributesRequest withDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public GetAttributesRequest withItemName(String itemName) {
        this.itemName = itemName;
        return this;
    }

    public List<String> getAttributeNames() {
        if (this.attributeNames == null) {
            this.attributeNames = new ListWithAutoConstructFlag();
            this.attributeNames.setAutoConstruct(true);
        }
        return this.attributeNames;
    }

    public void setAttributeNames(Collection<String> attributeNames) {
        if (attributeNames == null) {
            this.attributeNames = null;
            return;
        }
        ListWithAutoConstructFlag attributeNamesCopy = new ListWithAutoConstructFlag(attributeNames.size());
        attributeNamesCopy.addAll(attributeNames);
        this.attributeNames = attributeNamesCopy;
    }

    public GetAttributesRequest withAttributeNames(String ... attributeNames) {
        if (this.getAttributeNames() == null) {
            this.setAttributeNames(new ArrayList<String>(attributeNames.length));
        }
        for (String value : attributeNames) {
            this.getAttributeNames().add(value);
        }
        return this;
    }

    public GetAttributesRequest withAttributeNames(Collection<String> attributeNames) {
        if (attributeNames == null) {
            this.attributeNames = null;
        } else {
            ListWithAutoConstructFlag attributeNamesCopy = new ListWithAutoConstructFlag(attributeNames.size());
            attributeNamesCopy.addAll(attributeNames);
            this.attributeNames = attributeNamesCopy;
        }
        return this;
    }

    public Boolean isConsistentRead() {
        return this.consistentRead;
    }

    public void setConsistentRead(Boolean consistentRead) {
        this.consistentRead = consistentRead;
    }

    public GetAttributesRequest withConsistentRead(Boolean consistentRead) {
        this.consistentRead = consistentRead;
        return this;
    }

    public Boolean getConsistentRead() {
        return this.consistentRead;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainName() != null) {
            sb.append("DomainName: " + this.getDomainName() + ",");
        }
        if (this.getItemName() != null) {
            sb.append("ItemName: " + this.getItemName() + ",");
        }
        if (this.getAttributeNames() != null) {
            sb.append("AttributeNames: " + this.getAttributeNames() + ",");
        }
        if (this.isConsistentRead() != null) {
            sb.append("ConsistentRead: " + this.isConsistentRead());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getItemName() == null ? 0 : this.getItemName().hashCode());
        hashCode = 31 * hashCode + (this.getAttributeNames() == null ? 0 : this.getAttributeNames().hashCode());
        hashCode = 31 * hashCode + (this.isConsistentRead() == null ? 0 : this.isConsistentRead().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAttributesRequest)) {
            return false;
        }
        GetAttributesRequest other = (GetAttributesRequest)obj;
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (other.getDomainName() != null && !other.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (other.getItemName() == null ^ this.getItemName() == null) {
            return false;
        }
        if (other.getItemName() != null && !other.getItemName().equals(this.getItemName())) {
            return false;
        }
        if (other.getAttributeNames() == null ^ this.getAttributeNames() == null) {
            return false;
        }
        if (other.getAttributeNames() != null && !other.getAttributeNames().equals(this.getAttributeNames())) {
            return false;
        }
        if (other.isConsistentRead() == null ^ this.isConsistentRead() == null) {
            return false;
        }
        return other.isConsistentRead() == null || other.isConsistentRead().equals(this.isConsistentRead());
    }
}

