/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import io.airlift.units.DataSize;

public final class HiveSessionProperties {
    public static final String STORAGE_FORMAT_PROPERTY = "storage_format";
    private static final String OPTIMIZED_READER_ENABLED = "optimized_reader_enabled";
    private static final String ORC_MAX_MERGE_DISTANCE = "orc_max_merge_distance";

    private HiveSessionProperties() {
    }

    public static HiveStorageFormat getHiveStorageFormat(ConnectorSession session, HiveStorageFormat defaultValue) {
        String storageFormatString = (String)session.getProperties().get(STORAGE_FORMAT_PROPERTY);
        if (storageFormatString == null) {
            return defaultValue;
        }
        try {
            return HiveStorageFormat.valueOf(storageFormatString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Hive storage-format is invalid: " + storageFormatString);
        }
    }

    public static boolean isOptimizedReaderEnabled(ConnectorSession session, boolean defaultValue) {
        return HiveSessionProperties.isEnabled(OPTIMIZED_READER_ENABLED, session, defaultValue);
    }

    public static DataSize getOrcMaxMergeDistance(ConnectorSession session, DataSize defaultValue) {
        String maxMergeDistanceString = (String)session.getProperties().get(ORC_MAX_MERGE_DISTANCE);
        if (maxMergeDistanceString == null) {
            return defaultValue;
        }
        try {
            return DataSize.valueOf((String)maxMergeDistanceString);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "orc_max_merge_distance is invalid: " + maxMergeDistanceString);
        }
    }

    private static boolean isEnabled(String propertyName, ConnectorSession session, boolean defaultValue) {
        String enabled = (String)session.getProperties().get(propertyName);
        if (enabled == null) {
            return defaultValue;
        }
        return Boolean.valueOf(enabled);
    }
}

