/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveRecordCursor;
import com.facebook.presto.hive.HiveRecordCursorProvider;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.ParquetHiveRecordCursor;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.joda.time.DateTimeZone;

public class ParquetRecordCursorProvider
implements HiveRecordCursorProvider {
    @Override
    public Optional<HiveRecordCursor> createHiveRecordCursor(String clientId, Configuration configuration, ConnectorSession session, Path path, long start, long length, Properties schema, List<HiveColumnHandle> columns, List<HivePartitionKey> partitionKeys, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone, TypeManager typeManager) {
        Deserializer deserializer = HiveUtil.getDeserializer(schema);
        if (!(deserializer instanceof ParquetHiveSerDe)) {
            return Optional.empty();
        }
        ImmutableList unsupportedColumns = ImmutableList.copyOf((Iterable)Iterables.filter(columns, (Predicate)Predicates.not(ParquetRecordCursorProvider.isParquetSupportedType())));
        if (!unsupportedColumns.isEmpty()) {
            throw new IllegalArgumentException("Can not read Parquet column: " + unsupportedColumns);
        }
        return Optional.of(new ParquetHiveRecordCursor(configuration, path, start, length, schema, partitionKeys, columns, typeManager));
    }

    private static Predicate<HiveColumnHandle> isParquetSupportedType() {
        return new Predicate<HiveColumnHandle>(){

            public boolean apply(HiveColumnHandle columnHandle) {
                HiveType hiveType = columnHandle.getHiveType();
                return hiveType != HiveType.HIVE_TIMESTAMP && hiveType != HiveType.HIVE_DATE && hiveType != HiveType.HIVE_BINARY;
            }
        };
    }
}

