/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.google.common.base.Preconditions;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class SuspendingExecutor
implements Executor {
    private final Executor executor;
    private final Queue<Runnable> taskQueue = new LinkedBlockingQueue<Runnable>();
    @GuardedBy(value="this")
    private boolean suspended;
    @GuardedBy(value="this")
    private int suspendedTaskCount;

    public SuspendingExecutor(Executor executor) {
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
    }

    @Override
    public void execute(Runnable task) {
        this.taskQueue.add(task);
        this.activateOneTask();
    }

    private void activateOneTask() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (SuspendingExecutor.this.acquire()) {
                    Runnable task = (Runnable)SuspendingExecutor.this.taskQueue.poll();
                    Preconditions.checkState((task != null ? 1 : 0) != 0, (Object)"No task to execute");
                    task.run();
                }
            }
        });
    }

    private synchronized boolean acquire() {
        if (this.suspended) {
            ++this.suspendedTaskCount;
        }
        return !this.suspended;
    }

    public synchronized boolean isSuspended() {
        return this.suspended;
    }

    public synchronized void resume() {
        this.suspended = false;
        int count = this.suspendedTaskCount;
        this.suspendedTaskCount = 0;
        for (int i = 0; i < count; ++i) {
            this.activateOneTask();
        }
    }

    public synchronized void suspend() {
        this.suspended = true;
    }
}

