/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.OrcFile;
import com.facebook.hive.orc.StripeInformation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class StripeReader {
    private final FSDataInputStream file;
    private final List<StripeInformation> stripes = new ArrayList<StripeInformation>();
    private StripeInformation currentStripe;
    private byte[] currentData;
    private int stripesRead = 0;

    StripeReader(Iterable<StripeInformation> stripes, FileSystem fileSystem, Path path, long offset, long length) throws IOException {
        this.file = fileSystem.open(path);
        for (StripeInformation stripe : stripes) {
            long stripeStart = stripe.getOffset();
            if (stripeStart < offset || stripeStart >= offset + length) continue;
            this.stripes.add(stripe);
        }
    }

    private void readStripe() throws IOException {
        this.currentStripe = this.stripes.get(this.stripesRead);
        this.currentData = new byte[(int)(this.currentStripe.getIndexLength() + this.currentStripe.getDataLength() + this.currentStripe.getFooterLength())];
        this.file.seek(this.currentStripe.getOffset());
        this.file.readFully(this.currentData, 0, this.currentData.length);
    }

    public boolean hasNext() throws IOException {
        return this.stripesRead < this.stripes.size();
    }

    public boolean nextStripe(OrcFile.KeyWrapper keyWrapper, OrcFile.ValueWrapper valueWrapper) throws IOException {
        if (this.hasNext()) {
            this.readStripe();
            keyWrapper.key = this.currentStripe;
            valueWrapper.value = this.currentData;
            ++this.stripesRead;
        }
        return this.hasNext();
    }

    public void close() throws IOException {
        this.file.close();
    }

    public long getPosition() throws IOException {
        return this.file.getPos();
    }

    public float getProgress() {
        return (float)this.stripesRead / (float)this.stripes.size();
    }
}

