/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.SerializationUtils;
import com.facebook.hive.orc.lazy.LazyNumericDirectTreeReader;
import com.facebook.hive.orc.lazy.OrcLazyObject;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;

class LazyLongDirectTreeReader
extends LazyNumericDirectTreeReader {
    private long latestRead = 0L;

    LazyLongDirectTreeReader(int columnId, long rowIndexStride) {
        super(columnId, rowIndexStride);
    }

    private long readLong() throws IOException {
        this.latestRead = SerializationUtils.readIntegerType(this.input, 8, true, this.input.useVInts());
        return this.latestRead;
    }

    private LongWritable createWritable(Object previous, long v) throws IOException {
        LongWritable result = null;
        result = previous == null ? new LongWritable() : (LongWritable)previous;
        result.set(v);
        return result;
    }

    @Override
    public Object createWritableFromLatest(Object previous) throws IOException {
        return this.createWritable(previous, this.latestRead);
    }

    @Override
    public long nextLong(boolean readStream) throws IOException {
        if (!readStream) {
            return this.latestRead;
        }
        if (!this.valuePresent) {
            throw new OrcLazyObject.ValueNotPresentException("Cannot materialize long.");
        }
        return this.readLong();
    }

    @Override
    public Object next(Object previous) throws IOException {
        LongWritable result = null;
        if (this.valuePresent) {
            result = this.createWritable(previous, this.readLong());
        }
        return result;
    }

    @Override
    public void skipRows(long numNonNullValues) throws IOException {
        int i = 0;
        while ((long)i < numNonNullValues) {
            SerializationUtils.readIntegerType(this.input, 8, true, this.input.useVInts());
            ++i;
        }
    }
}

