/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.RunLengthIntegerReader;
import com.facebook.hive.orc.StreamName;
import com.facebook.hive.orc.lazy.LazyTreeReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LazyMapTreeReader
extends LazyTreeReader {
    private final LazyTreeReader keyReader;
    private final LazyTreeReader valueReader;
    private RunLengthIntegerReader lengths;

    public LazyMapTreeReader(int columnId, long rowIndexStride, LazyTreeReader keyReader, LazyTreeReader valueReader) {
        super(columnId, rowIndexStride);
        this.keyReader = keyReader;
        this.valueReader = valueReader;
    }

    @Override
    public Object next(Object previous) throws IOException {
        HashMap<Object, Object> result = null;
        if (this.valuePresent) {
            result = previous == null ? new HashMap<Object, Object>() : (HashMap<Object, Object>)previous;
            result.clear();
            int length = this.nextLength();
            for (int i = 0; i < length; ++i) {
                result.put(this.keyReader.getInComplexType(null, this.previousRow), this.valueReader.getInComplexType(null, this.previousRow));
            }
        }
        return result;
    }

    @Override
    protected void seek(int rowIndexEntry, boolean backwards) throws IOException {
        super.seek(rowIndexEntry, backwards);
        this.keyReader.seek(rowIndexEntry, backwards);
        this.valueReader.seek(rowIndexEntry, backwards);
    }

    @Override
    public void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings, OrcProto.RowIndex[] indexes, long rowBaseInStripe) throws IOException {
        super.startStripe(streams, encodings, indexes, rowBaseInStripe);
        this.keyReader.startStripe(streams, encodings, indexes, rowBaseInStripe);
        this.valueReader.startStripe(streams, encodings, indexes, rowBaseInStripe);
        this.lengths = new RunLengthIntegerReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH)), false, 4);
        if (indexes[this.columnId] != null) {
            this.loadIndeces(indexes[this.columnId].getEntryList(), 0);
        }
    }

    @Override
    public void seek(int index) throws IOException {
        this.lengths.seek(index);
    }

    @Override
    public int loadIndeces(List<OrcProto.RowIndexEntry> rowIndexEntries, int startIndex) {
        int updatedStartIndex = super.loadIndeces(rowIndexEntries, startIndex);
        return this.lengths.loadIndeces(rowIndexEntries, updatedStartIndex);
    }

    public int nextLength() throws IOException {
        return (int)this.lengths.next();
    }

    @Override
    public void skipRows(long numNonNullValues) throws IOException {
        long childSkip = 0L;
        for (long i = 0L; i < numNonNullValues; ++i) {
            childSkip += this.lengths.next();
        }
        this.keyReader.skipRowsInComplexType(childSkip);
        this.valueReader.skipRowsInComplexType(childSkip);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.keyReader != null) {
            this.keyReader.close();
        }
        if (this.valueReader != null) {
            this.valueReader.close();
        }
        if (this.lengths != null) {
            this.lengths.close();
        }
    }
}

