/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.json;

import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.json.JsonMapKeyReader;
import com.facebook.presto.orc.json.LongDictionaryJsonReader;
import com.facebook.presto.orc.json.LongDirectJsonReader;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.stream.StreamSources;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;

public class LongJsonReader
implements JsonMapKeyReader {
    private final StreamDescriptor streamDescriptor;
    private final LongDirectJsonReader directReader;
    private final LongDictionaryJsonReader dictionaryReader;
    private JsonMapKeyReader currentReader;

    public LongJsonReader(StreamDescriptor streamDescriptor) {
        this.streamDescriptor = (StreamDescriptor)Preconditions.checkNotNull((Object)streamDescriptor, (Object)"stream is null");
        this.directReader = new LongDirectJsonReader(streamDescriptor);
        this.dictionaryReader = new LongDictionaryJsonReader(streamDescriptor);
    }

    @Override
    public void readNextValueInto(JsonGenerator generator) throws IOException {
        this.currentReader.readNextValueInto(generator);
    }

    @Override
    public String nextValueAsMapKey() throws IOException {
        return this.currentReader.nextValueAsMapKey();
    }

    @Override
    public void skip(int skipSize) throws IOException {
        this.currentReader.skip(skipSize);
    }

    @Override
    public void openStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        ColumnEncoding.ColumnEncodingKind kind = encoding.get(this.streamDescriptor.getStreamId()).getColumnEncodingKind();
        if (kind == ColumnEncoding.ColumnEncodingKind.DIRECT || kind == ColumnEncoding.ColumnEncodingKind.DIRECT_V2 || kind == ColumnEncoding.ColumnEncodingKind.DWRF_DIRECT) {
            this.currentReader = this.directReader;
        } else if (kind == ColumnEncoding.ColumnEncodingKind.DICTIONARY || kind == ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2) {
            this.currentReader = this.dictionaryReader;
        } else {
            throw new IllegalArgumentException("Unsupported encoding " + (Object)((Object)kind));
        }
        this.currentReader.openStripe(dictionaryStreamSources, encoding);
    }

    @Override
    public void openRowGroup(StreamSources dataStreamSources) throws IOException {
        this.currentReader.openRowGroup(dataStreamSources);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

