/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.reader.LongDictionaryStreamReader;
import com.facebook.presto.orc.reader.LongDirectStreamReader;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.stream.StreamSources;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;

public class LongStreamReader
implements StreamReader {
    private final StreamDescriptor streamDescriptor;
    private final LongDirectStreamReader directReader;
    private final LongDictionaryStreamReader dictionaryReader;
    private StreamReader currentReader;

    public LongStreamReader(StreamDescriptor streamDescriptor) {
        this.streamDescriptor = (StreamDescriptor)Preconditions.checkNotNull((Object)streamDescriptor, (Object)"stream is null");
        this.directReader = new LongDirectStreamReader(streamDescriptor);
        this.dictionaryReader = new LongDictionaryStreamReader(streamDescriptor);
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.currentReader.prepareNextRead(batchSize);
    }

    @Override
    public void readBatch(Object vector) throws IOException {
        this.currentReader.readBatch(vector);
    }

    @Override
    public void startStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        ColumnEncoding.ColumnEncodingKind kind = encoding.get(this.streamDescriptor.getStreamId()).getColumnEncodingKind();
        if (kind == ColumnEncoding.ColumnEncodingKind.DIRECT || kind == ColumnEncoding.ColumnEncodingKind.DIRECT_V2 || kind == ColumnEncoding.ColumnEncodingKind.DWRF_DIRECT) {
            this.currentReader = this.directReader;
        } else if (kind == ColumnEncoding.ColumnEncodingKind.DICTIONARY) {
            this.currentReader = this.dictionaryReader;
        } else {
            throw new IllegalArgumentException("Unsupported encoding " + (Object)((Object)kind));
        }
        this.currentReader.startStripe(dictionaryStreamSources, encoding);
    }

    @Override
    public void startRowGroup(StreamSources dataStreamSources) throws IOException {
        this.currentReader.startRowGroup(dataStreamSources);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

