/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DUHelper;
import org.apache.hadoop.util.Shell;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class DU
extends Shell {
    private String dirPath;
    private AtomicLong used = new AtomicLong();
    private volatile boolean shouldRun = true;
    private Thread refreshUsed;
    private IOException duException = null;
    private long refreshInterval;

    public DU(File path, long interval) throws IOException {
        super(0L);
        this.refreshInterval = interval;
        this.dirPath = path.getCanonicalPath();
        this.run();
    }

    public DU(File path, Configuration conf) throws IOException {
        this(path, 600000L);
    }

    public void decDfsUsed(long value) {
        this.used.addAndGet(-value);
    }

    public void incDfsUsed(long value) {
        this.used.addAndGet(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUsed() throws IOException {
        if (this.refreshUsed == null) {
            this.run();
        } else {
            DU dU = this;
            synchronized (dU) {
                if (this.duException != null) {
                    IOException tmp = this.duException;
                    this.duException = null;
                    throw tmp;
                }
            }
        }
        return Math.max(this.used.longValue(), 0L);
    }

    public String getDirPath() {
        return this.dirPath;
    }

    @Override
    protected void run() throws IOException {
        if (WINDOWS) {
            this.used.set(DUHelper.getFolderUsage(this.dirPath));
            return;
        }
        super.run();
    }

    public void start() {
        if (this.refreshInterval > 0L) {
            this.refreshUsed = new Thread((Runnable)new DURefreshThread(), "refreshUsed-" + this.dirPath);
            this.refreshUsed.setDaemon(true);
            this.refreshUsed.start();
        }
    }

    public void shutdown() {
        this.shouldRun = false;
        if (this.refreshUsed != null) {
            this.refreshUsed.interrupt();
        }
    }

    public String toString() {
        return "du -sk " + this.dirPath + "\n" + this.used + "\t" + this.dirPath;
    }

    @Override
    protected String[] getExecString() {
        return new String[]{"du", "-sk", this.dirPath};
    }

    @Override
    protected void parseExecResult(BufferedReader lines) throws IOException {
        String line = lines.readLine();
        if (line == null) {
            throw new IOException("Expecting a line not the end of stream");
        }
        String[] tokens = line.split("\t");
        if (tokens.length == 0) {
            throw new IOException("Illegal du output");
        }
        this.used.set(Long.parseLong(tokens[0]) * 1024L);
    }

    public static void main(String[] args) throws Exception {
        String path = ".";
        if (args.length > 0) {
            path = args[0];
        }
        System.out.println(new DU(new File(path), new Configuration()).toString());
    }

    class DURefreshThread
    implements Runnable {
        DURefreshThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (DU.this.shouldRun) {
                try {
                    Thread.sleep(DU.this.refreshInterval);
                    try {
                        DU.this.run();
                    }
                    catch (IOException e) {
                        DU dU = DU.this;
                        synchronized (dU) {
                            DU.this.duException = e;
                        }
                        Shell.LOG.warn("Could not get disk usage information", e);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

