/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HdfsUtils {
    private static final Log LOG = LogFactory.getLog(HdfsUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isHealthy(URI uri) {
        boolean bl;
        String scheme = uri.getScheme();
        if (!"hdfs".equalsIgnoreCase(scheme)) {
            throw new IllegalArgumentException("The scheme is not hdfs, uri=" + uri);
        }
        Configuration conf = new Configuration();
        conf.setBoolean(String.format("fs.%s.impl.disable.cache", scheme), true);
        conf.setBoolean("dfs.client.retry.policy.enabled", false);
        conf.setInt("ipc.client.connect.max.retries", 0);
        DistributedFileSystem fs = null;
        try {
            fs = (DistributedFileSystem)FileSystem.get(uri, conf);
            boolean safemode = fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Is namenode in safemode? " + safemode + "; uri=" + uri);
            }
            fs.close();
            fs = null;
            bl = !safemode;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got an exception for uri=" + uri, e);
                }
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(LOG, fs);
                throw throwable;
            }
            IOUtils.cleanup(LOG, fs);
            return bl2;
        }
        IOUtils.cleanup(LOG, fs);
        return bl;
    }
}

