/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.json;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.MoreTypes;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecProvider;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class JsonCodecBinder {
    private final Binder binder;

    public static JsonCodecBinder jsonCodecBinder(Binder binder) {
        return new JsonCodecBinder(binder);
    }

    private JsonCodecBinder(Binder binder) {
        this.binder = binder;
    }

    public void bindJsonCodec(Class<?> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        this.binder.bind(this.getJsonCodecKey(type)).toProvider((Provider)new JsonCodecProvider(type)).in(Scopes.SINGLETON);
    }

    public void bindJsonCodec(TypeLiteral<?> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        this.binder.bind(this.getJsonCodecKey(type.getType())).toProvider((Provider)new JsonCodecProvider(type.getType())).in(Scopes.SINGLETON);
    }

    public void bindListJsonCodec(Class<?> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        MoreTypes.ParameterizedTypeImpl listType = new MoreTypes.ParameterizedTypeImpl(null, List.class, new Type[]{type});
        this.binder.bind(this.getJsonCodecKey((Type)listType)).toProvider((Provider)new JsonCodecProvider((Type)listType)).in(Scopes.SINGLETON);
    }

    public void bindListJsonCodec(JsonCodec<?> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        MoreTypes.ParameterizedTypeImpl listType = new MoreTypes.ParameterizedTypeImpl(null, List.class, new Type[]{type.getType()});
        this.binder.bind(this.getJsonCodecKey((Type)listType)).toProvider((Provider)new JsonCodecProvider((Type)listType)).in(Scopes.SINGLETON);
    }

    public void bindMapJsonCodec(Class<?> keyType, Class<?> valueType) {
        Preconditions.checkNotNull(keyType, (Object)"keyType is null");
        Preconditions.checkNotNull(valueType, (Object)"valueType is null");
        MoreTypes.ParameterizedTypeImpl mapType = new MoreTypes.ParameterizedTypeImpl(null, Map.class, new Type[]{keyType, valueType});
        this.binder.bind(this.getJsonCodecKey((Type)mapType)).toProvider((Provider)new JsonCodecProvider((Type)mapType)).in(Scopes.SINGLETON);
    }

    public void bindMapJsonCodec(Class<?> keyType, JsonCodec<?> valueType) {
        Preconditions.checkNotNull(keyType, (Object)"keyType is null");
        Preconditions.checkNotNull(valueType, (Object)"valueType is null");
        MoreTypes.ParameterizedTypeImpl mapType = new MoreTypes.ParameterizedTypeImpl(null, Map.class, new Type[]{keyType, valueType.getType()});
        this.binder.bind(this.getJsonCodecKey((Type)mapType)).toProvider((Provider)new JsonCodecProvider((Type)mapType)).in(Scopes.SINGLETON);
    }

    private Key<JsonCodec<?>> getJsonCodecKey(Type type) {
        return Key.get((Type)new MoreTypes.ParameterizedTypeImpl(null, JsonCodec.class, new Type[]{type}));
    }
}

