/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.util.Types;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class HiveColumnHandle
implements ConnectorColumnHandle {
    public static final String SAMPLE_WEIGHT_COLUMN_NAME = "__presto__sample_weight__";
    private final String clientId;
    private final String name;
    private final int ordinalPosition;
    private final HiveType hiveType;
    private final TypeSignature typeName;
    private final int hiveColumnIndex;
    private final boolean partitionKey;

    @JsonCreator
    public HiveColumnHandle(@JsonProperty(value="clientId") String clientId, @JsonProperty(value="name") String name, @JsonProperty(value="ordinalPosition") int ordinalPosition, @JsonProperty(value="hiveType") HiveType hiveType, @JsonProperty(value="typeSignature") TypeSignature typeSignature, @JsonProperty(value="hiveColumnIndex") int hiveColumnIndex, @JsonProperty(value="partitionKey") boolean partitionKey) {
        this.clientId = (String)Preconditions.checkNotNull((Object)clientId, (Object)"clientId is null");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkArgument((ordinalPosition >= 0 ? 1 : 0) != 0, (Object)"ordinalPosition is negative");
        this.ordinalPosition = ordinalPosition;
        Preconditions.checkArgument((hiveColumnIndex >= 0 || partitionKey ? 1 : 0) != 0, (Object)"hiveColumnIndex is negative");
        this.hiveColumnIndex = hiveColumnIndex;
        this.hiveType = (HiveType)Preconditions.checkNotNull((Object)hiveType, (Object)"hiveType is null");
        this.typeName = (TypeSignature)Preconditions.checkNotNull((Object)typeSignature, (Object)"type is null");
        this.partitionKey = partitionKey;
    }

    @JsonProperty
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @JsonProperty
    public HiveType getHiveType() {
        return this.hiveType;
    }

    @JsonProperty
    public int getHiveColumnIndex() {
        return this.hiveColumnIndex;
    }

    @JsonProperty
    public boolean isPartitionKey() {
        return this.partitionKey;
    }

    public ColumnMetadata getColumnMetadata(TypeManager typeManager) {
        return new ColumnMetadata(this.name, typeManager.getType(this.typeName), this.ordinalPosition, this.partitionKey);
    }

    @JsonProperty
    public TypeSignature getTypeSignature() {
        return this.typeName;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.clientId, this.name, this.hiveColumnIndex, this.hiveType, this.partitionKey});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HiveColumnHandle other = (HiveColumnHandle)obj;
        return Objects.equal((Object)this.clientId, (Object)other.clientId) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.hiveColumnIndex, (Object)other.hiveColumnIndex) && Objects.equal((Object)this.hiveType, (Object)other.hiveType) && Objects.equal((Object)this.partitionKey, (Object)other.partitionKey);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientId", (Object)this.clientId).add("name", (Object)this.name).add("ordinalPosition", this.ordinalPosition).add("hiveType", (Object)this.hiveType).add("hiveColumnIndex", this.hiveColumnIndex).add("partitionKey", this.partitionKey).toString();
    }

    public static HiveColumnHandle toHiveColumnHandle(ConnectorColumnHandle columnHandle) {
        return Types.checkType(columnHandle, HiveColumnHandle.class, "columnHandle");
    }
}

