/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hadoop.HadoopFileStatus;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HivePartitionMetadata;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.UnpartitionedPartition;
import com.facebook.presto.hive.util.AsyncWalker;
import com.facebook.presto.hive.util.FileStatusCallback;
import com.facebook.presto.hive.util.SuspendingExecutor;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.SetThreadName;
import io.airlift.units.DataSize;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;

class HiveSplitSourceProvider {
    public static final String FORCE_LOCAL_SCHEDULING = "force_local_scheduling";
    private static final ConnectorSplit FINISHED_MARKER = new ConnectorSplit(){

        public boolean isRemotelyAccessible() {
            throw new UnsupportedOperationException();
        }

        public List<HostAddress> getAddresses() {
            throw new UnsupportedOperationException();
        }

        public Object getInfo() {
            throw new UnsupportedOperationException();
        }
    };
    private final String connectorId;
    private final Table table;
    private final Iterable<HivePartitionMetadata> partitions;
    private final Optional<HiveBucketing.HiveBucket> bucket;
    private final int maxOutstandingSplits;
    private final int maxThreads;
    private final HdfsEnvironment hdfsEnvironment;
    private final NamenodeStats namenodeStats;
    private final DirectoryLister directoryLister;
    private final Executor executor;
    private final ClassLoader classLoader;
    private final DataSize maxSplitSize;
    private final int maxPartitionBatchSize;
    private final DataSize maxInitialSplitSize;
    private long remainingInitialSplits;
    private final ConnectorSession session;
    private final boolean recursiveDirWalkerEnabled;
    private final boolean forceLocalScheduling;

    HiveSplitSourceProvider(String connectorId, Table table, Iterable<HivePartitionMetadata> partitions, Optional<HiveBucketing.HiveBucket> bucket, DataSize maxSplitSize, int maxOutstandingSplits, int maxThreads, HdfsEnvironment hdfsEnvironment, NamenodeStats namenodeStats, DirectoryLister directoryLister, Executor executor, int maxPartitionBatchSize, ConnectorSession session, DataSize maxInitialSplitSize, int maxInitialSplits, boolean forceLocalScheduling, boolean recursiveDirWalkerEnabled) {
        this.connectorId = connectorId;
        this.table = table;
        this.partitions = partitions;
        this.bucket = bucket;
        this.maxSplitSize = maxSplitSize;
        this.maxPartitionBatchSize = maxPartitionBatchSize;
        this.maxOutstandingSplits = maxOutstandingSplits;
        this.maxThreads = maxThreads;
        this.hdfsEnvironment = hdfsEnvironment;
        this.namenodeStats = namenodeStats;
        this.directoryLister = directoryLister;
        this.executor = executor;
        this.session = session;
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.maxInitialSplitSize = maxInitialSplitSize;
        this.remainingInitialSplits = maxInitialSplits;
        this.recursiveDirWalkerEnabled = recursiveDirWalkerEnabled;
        this.forceLocalScheduling = forceLocalScheduling;
    }

    public ConnectorSplitSource get() {
        final SuspendingExecutor suspendingExecutor = new SuspendingExecutor((Executor)new BoundedExecutor(this.executor, this.maxThreads));
        final HiveSplitSource splitSource = new HiveSplitSource(this.connectorId, this.maxOutstandingSplits, suspendingExecutor);
        FutureTask<Object> producer = new FutureTask<Object>(new Runnable(){

            @Override
            public void run() {
                try (SetThreadName ignored = new SetThreadName("HiveSplitProducer", new Object[0]);){
                    HiveSplitSourceProvider.this.loadPartitionSplits(splitSource, suspendingExecutor, HiveSplitSourceProvider.this.session);
                }
            }
        }, null);
        this.executor.execute(producer);
        splitSource.setProducerFuture(producer);
        return splitSource;
    }

    private void loadPartitionSplits(final HiveSplitSource hiveSplitSource, SuspendingExecutor suspendingExecutor, final ConnectorSession session) {
        final Semaphore semaphore = new Semaphore(this.maxPartitionBatchSize);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ImmutableList.Builder futureBuilder = ImmutableList.builder();
            for (HivePartitionMetadata partition : this.partitions) {
                Optional<FileStatus> bucketFile;
                final String partitionName = partition.getHivePartition().getPartitionId();
                final Properties schema = HiveSplitSourceProvider.getPartitionSchema(this.table, partition.getPartition());
                final List<HivePartitionKey> partitionKeys = HiveSplitSourceProvider.getPartitionKeys(this.table, partition.getPartition());
                final TupleDomain<HiveColumnHandle> effectivePredicate = partition.getHivePartition().getEffectivePredicate();
                Path path = new Path(HiveSplitSourceProvider.getPartitionLocation(this.table, partition.getPartition()));
                Configuration configuration = this.hdfsEnvironment.getConfiguration(path);
                final InputFormat<?, ?> inputFormat = HiveUtil.getInputFormat(configuration, schema, false);
                if (inputFormat instanceof SymlinkTextInputFormat) {
                    InputSplit[] splits;
                    JobConf jobConf = new JobConf(configuration);
                    FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{path});
                    for (InputSplit rawSplit : splits = inputFormat.getSplits(jobConf, 0)) {
                        FileSplit split = ((SymlinkTextInputFormat.SymlinkTextInputSplit)rawSplit).getTargetSplit();
                        FileSystem targetFilesystem = this.hdfsEnvironment.getFileSystem(split.getPath());
                        FileStatus fileStatus = targetFilesystem.getFileStatus(split.getPath());
                        hiveSplitSource.addToQueue(this.createHiveSplits(partitionName, fileStatus, targetFilesystem.getFileBlockLocations(fileStatus, split.getStart(), split.getLength()), split.getStart(), split.getLength(), schema, partitionKeys, false, session, effectivePredicate));
                    }
                    continue;
                }
                FileSystem fs = this.hdfsEnvironment.getFileSystem(path);
                if (this.bucket.isPresent() && (bucketFile = HiveSplitSourceProvider.getBucketFile(this.bucket.get(), fs, path)).isPresent()) {
                    FileStatus file = bucketFile.get();
                    BlockLocation[] blockLocations = fs.getFileBlockLocations(file, 0L, file.getLen());
                    boolean splittable = HiveUtil.isSplittable(inputFormat, fs, file.getPath());
                    hiveSplitSource.addToQueue(this.createHiveSplits(partitionName, file, blockLocations, 0L, file.getLen(), schema, partitionKeys, splittable, session, effectivePredicate));
                    continue;
                }
                try {
                    semaphore.acquire();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    if (ignored != null) {
                        if (var6_7 != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable) {
                                var6_7.addSuppressed(throwable);
                            }
                        } else {
                            ignored.close();
                        }
                    }
                    return;
                }
                ListenableFuture<Void> partitionFuture = this.createAsyncWalker(fs, suspendingExecutor).beginWalk(path, new FileStatusCallback(){

                    @Override
                    public void process(FileStatus file, BlockLocation[] blockLocations) {
                        try {
                            boolean splittable = HiveUtil.isSplittable(inputFormat, HiveSplitSourceProvider.this.hdfsEnvironment.getFileSystem(file.getPath()), file.getPath());
                            hiveSplitSource.addToQueue(HiveSplitSourceProvider.this.createHiveSplits(partitionName, file, blockLocations, 0L, file.getLen(), schema, partitionKeys, splittable, session, (TupleDomain<HiveColumnHandle>)effectivePredicate));
                        }
                        catch (IOException e) {
                            hiveSplitSource.fail(e);
                        }
                    }
                });
                Futures.addCallback(partitionFuture, (FutureCallback)new FutureCallback<Void>(){

                    public void onSuccess(Void result) {
                        semaphore.release();
                    }

                    public void onFailure(Throwable t) {
                        semaphore.release();
                    }
                });
                futureBuilder.add(partitionFuture);
            }
            Futures.addCallback((ListenableFuture)Futures.allAsList((Iterable)futureBuilder.build()), (FutureCallback)new FutureCallback<List<Void>>(){

                public void onSuccess(List<Void> result) {
                    hiveSplitSource.finished();
                }

                public void onFailure(Throwable t) {
                    hiveSplitSource.fail(t);
                }
            });
        }
        catch (Throwable e) {
            hiveSplitSource.fail(e);
            Throwables.propagateIfInstanceOf((Throwable)e, Error.class);
        }
    }

    private AsyncWalker createAsyncWalker(FileSystem fs, SuspendingExecutor suspendingExecutor) {
        return new AsyncWalker(fs, suspendingExecutor, this.directoryLister, this.namenodeStats, this.recursiveDirWalkerEnabled);
    }

    private static Optional<FileStatus> getBucketFile(HiveBucketing.HiveBucket bucket, FileSystem fs, Path path) {
        FileStatus[] statuses = HiveSplitSourceProvider.listStatus(fs, path);
        if (statuses.length != bucket.getBucketCount()) {
            return Optional.empty();
        }
        HashMap<String, FileStatus> map = new HashMap<String, FileStatus>();
        ArrayList<String> paths = new ArrayList<String>();
        for (FileStatus status : statuses) {
            if (!HadoopFileStatus.isFile((FileStatus)status)) {
                return Optional.empty();
            }
            String pathString = status.getPath().toString();
            map.put(pathString, status);
            paths.add(pathString);
        }
        Collections.sort(paths);
        String pathString = (String)paths.get(bucket.getBucketNumber());
        return Optional.of(map.get(pathString));
    }

    private static FileStatus[] listStatus(FileSystem fs, Path path) {
        try {
            return fs.listStatus(path);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private List<HiveSplit> createHiveSplits(String partitionName, FileStatus file, BlockLocation[] blockLocations, long start, long length, Properties schema, List<HivePartitionKey> partitionKeys, boolean splittable, ConnectorSession session, TupleDomain<HiveColumnHandle> effectivePredicate) throws IOException {
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean forceLocalScheduling = this.getForceLocalScheduling(session);
        if (splittable) {
            for (BlockLocation blockLocation : blockLocations) {
                List<HostAddress> addresses = HiveSplitSourceProvider.toHostAddress(blockLocation.getHosts());
                long maxBytes = this.maxSplitSize.toBytes();
                if (this.remainingInitialSplits > 0L) {
                    maxBytes = this.maxInitialSplitSize.toBytes();
                }
                int chunks = Math.max(1, (int)(blockLocation.getLength() / maxBytes));
                long targetChunkSize = (long)Math.ceil((double)blockLocation.getLength() * 1.0 / (double)chunks);
                long chunkOffset = 0L;
                while (chunkOffset < blockLocation.getLength()) {
                    long chunkLength = Math.min(targetChunkSize, blockLocation.getLength() - chunkOffset);
                    builder.add((Object)new HiveSplit(this.connectorId, this.table.getDbName(), this.table.getTableName(), partitionName, file.getPath().toString(), blockLocation.getOffset() + chunkOffset, chunkLength, schema, partitionKeys, addresses, forceLocalScheduling, session, effectivePredicate));
                    chunkOffset += chunkLength;
                    --this.remainingInitialSplits;
                }
                Preconditions.checkState((chunkOffset == blockLocation.getLength() ? 1 : 0) != 0, (Object)"Error splitting blocks");
            }
        } else {
            Object addresses = ImmutableList.of();
            if (blockLocations.length > 0) {
                addresses = HiveSplitSourceProvider.toHostAddress(blockLocations[0].getHosts());
            }
            builder.add((Object)new HiveSplit(this.connectorId, this.table.getDbName(), this.table.getTableName(), partitionName, file.getPath().toString(), start, length, schema, partitionKeys, (List<HostAddress>)addresses, forceLocalScheduling, session, effectivePredicate));
        }
        return builder.build();
    }

    private boolean getForceLocalScheduling(ConnectorSession session) {
        String forceLocalScheduling = (String)session.getProperties().get(FORCE_LOCAL_SCHEDULING);
        if (forceLocalScheduling == null) {
            return this.forceLocalScheduling;
        }
        try {
            return Boolean.valueOf(forceLocalScheduling);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invalid Hive session property 'force_local_scheduling=" + forceLocalScheduling + "'");
        }
    }

    private static List<HostAddress> toHostAddress(String[] hosts) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String host : hosts) {
            builder.add((Object)HostAddress.fromString((String)host));
        }
        return builder.build();
    }

    private static List<HivePartitionKey> getPartitionKeys(Table table, Partition partition) {
        if (UnpartitionedPartition.isUnpartitioned(partition)) {
            return ImmutableList.of();
        }
        ImmutableList.Builder partitionKeys = ImmutableList.builder();
        List keys = table.getPartitionKeys();
        List values = partition.getValues();
        Preconditions.checkArgument((keys.size() == values.size() ? 1 : 0) != 0, (String)"Expected %s partition key values, but got %s", (Object[])new Object[]{keys.size(), values.size()});
        for (int i = 0; i < keys.size(); ++i) {
            String name = ((FieldSchema)keys.get(i)).getName();
            HiveType hiveType = HiveType.getSupportedHiveType(((FieldSchema)keys.get(i)).getType());
            String value = (String)values.get(i);
            Preconditions.checkNotNull((Object)value, (String)"partition key value cannot be null for field: %s", (Object[])new Object[]{name});
            partitionKeys.add((Object)new HivePartitionKey(name, hiveType, value));
        }
        return partitionKeys.build();
    }

    private static Properties getPartitionSchema(Table table, Partition partition) {
        if (UnpartitionedPartition.isUnpartitioned(partition)) {
            return MetaStoreUtils.getTableMetadata((Table)table);
        }
        return MetaStoreUtils.getSchema((Partition)partition, (Table)table);
    }

    private static String getPartitionLocation(Table table, Partition partition) {
        if (UnpartitionedPartition.isUnpartitioned(partition)) {
            return table.getSd().getLocation();
        }
        return partition.getSd().getLocation();
    }

    @VisibleForTesting
    static class HiveSplitSource
    implements ConnectorSplitSource {
        private final String connectorId;
        private final BlockingQueue<ConnectorSplit> queue = new LinkedBlockingQueue<ConnectorSplit>();
        private final AtomicInteger outstandingSplitCount = new AtomicInteger();
        private final AtomicReference<Throwable> throwable = new AtomicReference();
        private final int maxOutstandingSplits;
        private final SuspendingExecutor suspendingExecutor;
        private volatile boolean closed;
        @GuardedBy(value="this")
        private Future<?> producerFuture;

        @VisibleForTesting
        HiveSplitSource(String connectorId, int maxOutstandingSplits, SuspendingExecutor suspendingExecutor) {
            this.connectorId = connectorId;
            this.maxOutstandingSplits = maxOutstandingSplits;
            this.suspendingExecutor = suspendingExecutor;
        }

        @VisibleForTesting
        int getOutstandingSplitCount() {
            return this.outstandingSplitCount.get();
        }

        void addToQueue(Iterable<? extends ConnectorSplit> splits) {
            for (ConnectorSplit connectorSplit : splits) {
                this.addToQueue(connectorSplit);
            }
        }

        @VisibleForTesting
        void addToQueue(ConnectorSplit split) {
            if (this.throwable.get() == null) {
                this.queue.add(split);
                if (this.outstandingSplitCount.incrementAndGet() >= this.maxOutstandingSplits) {
                    this.suspendingExecutor.suspend();
                }
            }
        }

        @VisibleForTesting
        void finished() {
            if (this.throwable.get() == null) {
                this.queue.add(FINISHED_MARKER);
            }
        }

        @VisibleForTesting
        void fail(Throwable e) {
            if (this.throwable.compareAndSet(null, e)) {
                this.queue.add(FINISHED_MARKER);
                this.suspendingExecutor.suspend();
            }
        }

        public String getDataSourceName() {
            return this.connectorId;
        }

        public List<ConnectorSplit> getNextBatch(int maxSize) throws InterruptedException {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Provider is already closed");
            ArrayList<ConnectorSplit> splits = new ArrayList<ConnectorSplit>(maxSize);
            splits.add(this.queue.take());
            this.queue.drainTo(splits, maxSize - 1);
            int finishedIndex = splits.indexOf(FINISHED_MARKER);
            if (finishedIndex >= 0) {
                this.queue.add(FINISHED_MARKER);
                splits = splits.subList(0, finishedIndex);
            }
            if (this.throwable.get() != null) {
                throw this.propagatePrestoException(this.throwable.get());
            }
            if (this.outstandingSplitCount.addAndGet(-splits.size()) < this.maxOutstandingSplits) {
                this.suspendingExecutor.resume();
            }
            return splits;
        }

        public boolean isFinished() {
            boolean isFinished;
            boolean bl = isFinished = this.queue.peek() == FINISHED_MARKER;
            if (this.throwable.get() != null) {
                throw this.propagatePrestoException(this.throwable.get());
            }
            return isFinished;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.queue.add(FINISHED_MARKER);
            this.suspendingExecutor.suspend();
            HiveSplitSource hiveSplitSource = this;
            synchronized (hiveSplitSource) {
                this.closed = true;
                if (this.producerFuture != null) {
                    this.producerFuture.cancel(true);
                }
            }
        }

        public synchronized void setProducerFuture(Future<?> future) {
            this.producerFuture = future;
            if (this.closed) {
                this.producerFuture.cancel(true);
            }
        }

        private RuntimeException propagatePrestoException(Throwable throwable) {
            if (throwable instanceof PrestoException) {
                throw (PrestoException)throwable;
            }
            if (throwable instanceof FileNotFoundException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILE_NOT_FOUND, throwable);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_ERROR, throwable);
        }
    }
}

