/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;

public final class HadoopFileSystem {
    private HadoopFileSystem() {
    }

    public static RemoteIterator<LocatedFileStatus> listLocatedStatus(final FileSystem fs, Path path) throws IOException {
        final FileStatus[] files = fs.listStatus(path);
        if (files == null) {
            throw new FileNotFoundException("Path does not exist: " + path);
        }
        return new RemoteIterator<LocatedFileStatus>(){
            private final Iterator<FileStatus> iterator;
            {
                this.iterator = Arrays.asList(files).iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public LocatedFileStatus next() throws IOException {
                FileStatus file = this.iterator.next();
                BlockLocation[] blocks = null;
                if (!file.isDir()) {
                    blocks = fs.getFileBlockLocations(file, 0L, file.getLen());
                }
                return new LocatedFileStatus(file, blocks);
            }
        };
    }
}

