/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.shaded.org.apache.commons.httpclient.util;

import com.facebook.presto.hadoop.shaded.org.apache.commons.httpclient.HttpConnection;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class IdleConnectionHandler {
    private static final Log LOG = LogFactory.getLog(class$org$apache$commons$httpclient$util$IdleConnectionHandler == null ? (class$org$apache$commons$httpclient$util$IdleConnectionHandler = IdleConnectionHandler.class$("com.facebook.presto.hadoop.shaded.org.apache.commons.httpclient.util.IdleConnectionHandler")) : class$org$apache$commons$httpclient$util$IdleConnectionHandler);
    private Map connectionToAdded = new HashMap();
    static /* synthetic */ Class class$org$apache$commons$httpclient$util$IdleConnectionHandler;

    public void add(HttpConnection connection) {
        Long timeAdded = new Long(System.currentTimeMillis());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding connection at: " + timeAdded);
        }
        this.connectionToAdded.put(connection, timeAdded);
    }

    public void remove(HttpConnection connection) {
        this.connectionToAdded.remove(connection);
    }

    public void removeAll() {
        this.connectionToAdded.clear();
    }

    public void closeIdleConnections(long idleTime) {
        long idleTimeout = System.currentTimeMillis() - idleTime;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking for connections, idleTimeout: " + idleTimeout);
        }
        Iterator connectionIter = this.connectionToAdded.keySet().iterator();
        while (connectionIter.hasNext()) {
            HttpConnection conn = (HttpConnection)connectionIter.next();
            Long connectionTime = (Long)this.connectionToAdded.get(conn);
            if (connectionTime > idleTimeout) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing connection, connection time: " + connectionTime);
            }
            connectionIter.remove();
            conn.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

