/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web.resources;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.server.datanode.web.resources.DatanodeWebHdfsMethods;
import org.apache.hadoop.io.IOUtils;

public class OpenEntity {
    private final DFSClient.DFSDataInputStream in;
    private final long length;
    private final DFSClient dfsclient;

    OpenEntity(DFSClient.DFSDataInputStream in, long length, DFSClient dfsclient) {
        this.in = in;
        this.length = length;
        this.dfsclient = dfsclient;
    }

    @Provider
    public static class Writer
    implements MessageBodyWriter<OpenEntity> {
        public boolean isWriteable(Class<?> clazz, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return clazz == OpenEntity.class && MediaType.APPLICATION_OCTET_STREAM_TYPE.isCompatible(mediaType);
        }

        public long getSize(OpenEntity e, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return e.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(OpenEntity e, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream out) throws IOException {
            try {
                IOUtils.copyBytes(e.in, out, e.length, 4096, false);
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(DatanodeWebHdfsMethods.LOG, e.in);
                IOUtils.cleanup(DatanodeWebHdfsMethods.LOG, e.dfsclient);
                throw throwable;
            }
            IOUtils.cleanup(DatanodeWebHdfsMethods.LOG, e.in);
            IOUtils.cleanup(DatanodeWebHdfsMethods.LOG, e.dfsclient);
        }
    }
}

