/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import com.facebook.presto.hadoop.shaded.org.apache.commons.cli.CommandLine;
import com.facebook.presto.hadoop.shaded.org.apache.commons.cli.Options;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HftpFileSystem;
import org.apache.hadoop.hdfs.HsftpFileSystem;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.Krb5AndCertsSslSocketConnector;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.GenericOptionsParser;

public class DelegationTokenFetcher {
    private static final Log LOG;
    private static final String WEBSERVICE = "webservice";
    private static final String CANCEL = "cancel";
    private static final String RENEW = "renew";

    private static void printUsage(PrintStream err) throws IOException {
        err.println("fetchdt retrieves delegation tokens from the NameNode");
        err.println();
        err.println("fetchdt <opts> <token file>");
        err.println("Options:");
        err.println("  --webservice <url>  Url to contact NN on");
        err.println("  --cancel            Cancel the delegation token");
        err.println("  --renew             Renew the delegation token");
        err.println();
        GenericOptionsParser.printGenericCommandUsage(err);
        System.exit(1);
    }

    private static Collection<Token<?>> readTokens(Path file, Configuration conf) throws IOException {
        Credentials creds = Credentials.readTokenStorageFile(file, conf);
        return creds.getAllTokens();
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        DelegationTokenFetcher.setupSsl(conf);
        Options fetcherOptions = new Options();
        fetcherOptions.addOption(WEBSERVICE, true, "HTTP/S url to reach the NameNode at");
        fetcherOptions.addOption(CANCEL, false, "cancel the token");
        fetcherOptions.addOption(RENEW, false, "renew the token");
        GenericOptionsParser parser = new GenericOptionsParser(conf, fetcherOptions, args);
        CommandLine cmd = parser.getCommandLine();
        String webUrl = cmd.hasOption(WEBSERVICE) ? cmd.getOptionValue(WEBSERVICE) : null;
        boolean cancel = cmd.hasOption(CANCEL);
        boolean renew = cmd.hasOption(RENEW);
        String[] remaining = parser.getRemainingArgs();
        if (cancel && renew) {
            System.err.println("ERROR: Only specify cancel or renew.");
            DelegationTokenFetcher.printUsage(System.err);
        }
        if (remaining.length != 1 || remaining[0].charAt(0) == '-') {
            System.err.println("ERROR: Must specify exactly one token file");
            DelegationTokenFetcher.printUsage(System.err);
        }
        LocalFileSystem local = FileSystem.getLocal(conf);
        Path tokenFile = new Path(((FileSystem)local).getWorkingDirectory(), remaining[0]);
        if (cancel) {
            for (Token<?> token : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
                if (!token.isManaged()) continue;
                token.cancel(conf);
            }
        } else if (renew) {
            for (Token<?> token : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
                if (!token.isManaged()) continue;
                token.renew(conf);
            }
        } else if (webUrl != null) {
            URI uri = new URI(webUrl);
            DelegationTokenFetcher.getDTfromRemote(uri.getScheme(), new InetSocketAddress(uri.getHost(), uri.getPort()), null, conf).writeTokenStorageFile(tokenFile, conf);
        } else {
            FileSystem fs = FileSystem.get(conf);
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            Token<?> token = fs.getDelegationToken(ugi.getShortUserName());
            Credentials cred = new Credentials();
            cred.addToken(token.getService(), token);
            cred.writeTokenStorageFile(tokenFile, conf);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fetched token for " + fs.getUri() + " into " + tokenFile);
            }
        }
    }

    public static void setupSsl(Configuration conf) {
        Configuration sslConf = new Configuration(false);
        sslConf.addResource(conf.get("dfs.https.client.keystore.resource", "ssl-client.xml"));
        System.setProperty("javax.net.ssl.trustStore", sslConf.get("ssl.client.truststore.location", ""));
        System.setProperty("javax.net.ssl.trustStorePassword", sslConf.get("ssl.client.truststore.password", ""));
        System.setProperty("javax.net.ssl.trustStoreType", sslConf.get("ssl.client.truststore.type", "jks"));
        System.setProperty("javax.net.ssl.keyStore", sslConf.get("ssl.client.keystore.location", ""));
        System.setProperty("javax.net.ssl.keyStorePassword", sslConf.get("ssl.client.keystore.password", ""));
        System.setProperty("javax.net.ssl.keyPassword", sslConf.get("ssl.client.keystore.keypassword", ""));
        System.setProperty("javax.net.ssl.keyStoreType", sslConf.get("ssl.client.keystore.type", "jks"));
    }

    public static Credentials getDTfromRemote(String protocol, final InetSocketAddress nnAddr, String renewer, Configuration conf) throws IOException {
        String renewAddress = DelegationTokenFetcher.getRenewAddress(protocol, nnAddr, conf);
        final boolean https = "https".equals(protocol);
        try {
            StringBuffer url = new StringBuffer(renewAddress);
            url.append("/getDelegationToken");
            if (renewer != null) {
                url.append("?").append("renewer").append("=").append(renewer);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Retrieving token from: " + url);
            }
            final URL remoteURL = new URL(url.toString());
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            return ugi.doAs(new PrivilegedExceptionAction<Credentials>(){

                @Override
                public Credentials run() throws Exception {
                    URLConnection connection = SecurityUtil.openSecureHttpConnection(remoteURL);
                    InputStream in = connection.getInputStream();
                    Credentials ts = new Credentials();
                    DataInputStream dis = new DataInputStream(in);
                    try {
                        ts.readFields(dis);
                        for (Token<? extends TokenIdentifier> token : ts.getAllTokens()) {
                            if (https) {
                                token.setKind(HsftpFileSystem.TOKEN_KIND);
                            } else {
                                token.setKind(HftpFileSystem.TOKEN_KIND);
                            }
                            SecurityUtil.setTokenService(token, nnAddr);
                        }
                        dis.close();
                    }
                    catch (IOException ie) {
                        IOUtils.cleanup(LOG, dis);
                    }
                    return ts;
                }
            });
        }
        catch (InterruptedException ie) {
            return null;
        }
    }

    protected static String getRenewAddress(String protocol, InetSocketAddress addr, Configuration conf) {
        if (SecurityUtil.useKsslAuth() && "http".equals(protocol)) {
            protocol = "https";
            int port = conf.getInt("dfs.https.port", 50470);
            addr = new InetSocketAddress(addr.getAddress(), port);
        }
        return DFSUtil.createUri(protocol, addr).toString();
    }

    public static long renewDelegationToken(String protocol, InetSocketAddress addr, Token<DelegationTokenIdentifier> tok, Configuration conf) throws IOException {
        final String renewAddress = DelegationTokenFetcher.getRenewAddress(protocol, addr, conf);
        final StringBuilder buf = new StringBuilder(renewAddress);
        final String service = tok.getService().toString();
        buf.append("/renewDelegationToken");
        buf.append("?");
        buf.append("token");
        buf.append("=");
        buf.append(tok.encodeToUrlString());
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        try {
            return ugi.doAs(new PrivilegedExceptionAction<Long>(){

                @Override
                public Long run() throws Exception {
                    BufferedReader in = null;
                    HttpURLConnection connection = null;
                    try {
                        URL url = new URL(buf.toString());
                        connection = (HttpURLConnection)SecurityUtil.openSecureHttpConnection(url);
                        in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                        long result = Long.parseLong(in.readLine());
                        in.close();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Renewed token for " + service + " via " + renewAddress);
                        }
                        return result;
                    }
                    catch (IOException ie) {
                        LOG.info("Error renewing token for " + renewAddress, ie);
                        IOException e = null;
                        if (connection != null) {
                            String resp = connection.getResponseMessage();
                            e = DelegationTokenFetcher.getExceptionFromResponse(resp);
                        }
                        IOUtils.cleanup(LOG, in);
                        if (e != null) {
                            LOG.info("rethrowing exception from HTTP request: " + e.getLocalizedMessage());
                            throw e;
                        }
                        throw ie;
                    }
                }
            });
        }
        catch (InterruptedException ie) {
            return 0L;
        }
    }

    private static IOException getExceptionFromResponse(String resp) {
        String exceptionClass = "";
        String exceptionMsg = "";
        if (resp != null && !resp.isEmpty()) {
            String[] rs = resp.split(";");
            exceptionClass = rs[0];
            exceptionMsg = rs[1];
        }
        LOG.info("Error response from HTTP request=" + resp + ";ec=" + exceptionClass + ";em=" + exceptionMsg);
        Throwable e = null;
        if (exceptionClass != null && !exceptionClass.isEmpty()) {
            if (exceptionClass.contains("InvalidToken")) {
                e = new SecretManager.InvalidToken(exceptionMsg);
                e.setStackTrace(new StackTraceElement[0]);
            } else if (exceptionClass.contains("AccessControlException")) {
                e = new AccessControlException(exceptionMsg);
                e.setStackTrace(new StackTraceElement[0]);
            }
        }
        LOG.info("Exception from HTTP response=" + e.getLocalizedMessage());
        return e;
    }

    public static void cancelDelegationToken(String protocol, InetSocketAddress addr, Token<DelegationTokenIdentifier> tok, Configuration conf) throws IOException {
        final String renewAddress = DelegationTokenFetcher.getRenewAddress(protocol, addr, conf);
        StringBuilder buf = new StringBuilder(renewAddress);
        buf.append("/cancelDelegationToken");
        buf.append("?");
        buf.append("token");
        buf.append("=");
        buf.append(tok.encodeToUrlString());
        Object in = null;
        try {
            final URL url = new URL(buf.toString());
            if (LOG.isDebugEnabled()) {
                LOG.debug("cancelling token at " + buf.toString());
            }
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            ugi.doAs(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    HttpURLConnection connection = (HttpURLConnection)SecurityUtil.openSecureHttpConnection(url);
                    if (connection.getResponseCode() != 200) {
                        throw new IOException("Error cancelling token for " + renewAddress + " response: " + connection.getResponseMessage());
                    }
                    return null;
                }
            });
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cancelled token for " + tok.getService() + " via " + renewAddress);
            }
        }
        catch (IOException ie) {
            LOG.warn("Error cancelling token for " + renewAddress, ie);
            IOUtils.cleanup(LOG, in);
            throw ie;
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
    }

    static {
        Configuration.addDefaultResource("hdfs-default.xml");
        Configuration.addDefaultResource("hdfs-site.xml");
        LOG = LogFactory.getLog(DelegationTokenFetcher.class);
        int n = Krb5AndCertsSslSocketConnector.KRB5_CIPHER_SUITES.size();
    }
}

